/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.rollback;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilterFilePathStrings;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.FilePathsHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnChangeProvider;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.rollback.SuperfluousRemover;
import org.jetbrains.idea.svn.rollback.SvnRollbackEnvironment;
import org.jetbrains.idea.svn.rollback.UnversionedAndNotTouchedFilesGroupCollector;
import org.tmatesoft.svn.core.SVNException;

public class ChangesChecker {
    @NotNull
    private final SuperfluousRemover myForAdds;
    @NotNull
    private final SuperfluousRemover myForDeletes;
    private final List<File> myForEdits;
    private final SvnChangeProvider myChangeProvider;
    @NotNull
    private final UnversionedAndNotTouchedFilesGroupCollector myCollector;
    private final List<VcsException> myExceptions;

    ChangesChecker(@NotNull SvnVcs vcs, @NotNull UnversionedAndNotTouchedFilesGroupCollector collector) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/rollback/ChangesChecker", "<init>"));
        }
        if (collector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "org/jetbrains/idea/svn/rollback/ChangesChecker", "<init>"));
        }
        this.myChangeProvider = (SvnChangeProvider)vcs.getChangeProvider();
        this.myCollector = collector;
        this.myForAdds = new SuperfluousRemover(true);
        this.myForDeletes = new SuperfluousRemover(false);
        this.myForEdits = new ArrayList<File>();
        this.myExceptions = new ArrayList<VcsException>();
    }

    public void gather(List<Change> changes) {
        TreeMap<String, File> renames = new TreeMap<String, File>();
        HashSet<String> alsoReverted = new HashSet<String>();
        HashMap<String, FilePath> files = new HashMap<String, FilePath>();
        for (Change change : changes) {
            String key;
            ContentRevision beforeRevision = change.getBeforeRevision();
            ContentRevision afterRevision = change.getAfterRevision();
            String string = key = afterRevision == null ? null : FilePathsHelper.convertWithLastSeparator((FilePath)afterRevision.getFile());
            if (SvnRollbackEnvironment.isMoveRenameReplace(change)) {
                File beforeFile = beforeRevision.getFile().getIOFile();
                renames.put(key, beforeFile);
                files.put(key, afterRevision.getFile());
                this.myCollector.markRename(beforeFile, afterRevision.getFile().getIOFile());
                continue;
            }
            if (afterRevision == null) continue;
            alsoReverted.add(key);
        }
        if (!renames.isEmpty()) {
            ArrayList paths = new ArrayList(renames.keySet());
            if (paths.size() > 1) {
                FilterFilePathStrings.getInstance().doFilter(paths);
            }
            this.myCollector.setRenamesMap(renames);
            this.myCollector.setAlsoReverted(alsoReverted);
            for (String path : paths) {
                try {
                    this.myChangeProvider.getChanges((FilePath)files.get(path), true, (ChangelistBuilder)this.myCollector);
                }
                catch (SVNException e) {
                    this.myExceptions.add(new VcsException((Throwable)e));
                }
                catch (SvnBindException e) {
                    this.myExceptions.add(e);
                }
            }
        }
        for (Change change : changes) {
            ContentRevision afterRevision = change.getAfterRevision();
            boolean checked = this.myForAdds.accept(change);
            if (checked |= this.myForDeletes.accept(change)) continue;
            this.myForEdits.add(afterRevision.getFile().getIOFile());
        }
    }

    @NotNull
    public Collection<File> getForAdds() {
        Set<File> set = this.myForAdds.getParentPaths();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/rollback/ChangesChecker", "getForAdds"));
        }
        return set;
    }

    @NotNull
    public Collection<File> getForDeletes() {
        Set<File> set = this.myForDeletes.getParentPaths();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/rollback/ChangesChecker", "getForDeletes"));
        }
        return set;
    }

    public List<VcsException> getExceptions() {
        return this.myExceptions;
    }

    @NotNull
    public List<File> getForEdits() {
        List<File> list = this.myForEdits;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/rollback/ChangesChecker", "getForEdits"));
        }
        return list;
    }
}

