/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.conflict;

import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public enum ConflictAction {
    EDIT("edit", "edited"),
    ADD("add", "added"),
    DELETE("delete", "deleted"),
    REPLACE("replace", "replaced");

    @NotNull
    private static final Map<String, ConflictAction> ourAllActions;
    @NotNull
    private final String myKey;
    @NotNull
    private final String[] myOtherKeys;

    private ConflictAction(String key, String ... otherKeys) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/idea/svn/conflict/ConflictAction", "<init>"));
        }
        if (otherKeys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherKeys", "org/jetbrains/idea/svn/conflict/ConflictAction", "<init>"));
        }
        this.myKey = key;
        this.myOtherKeys = otherKeys;
    }

    public String toString() {
        return this.myKey;
    }

    private static void register(@NotNull ConflictAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "org/jetbrains/idea/svn/conflict/ConflictAction", "register"));
        }
        ourAllActions.put(action.myKey, action);
        for (String otherKey : action.myOtherKeys) {
            ourAllActions.put(otherKey, action);
        }
    }

    @NotNull
    public static ConflictAction from(@NotNull String actionName) {
        if (actionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionName", "org/jetbrains/idea/svn/conflict/ConflictAction", "from"));
        }
        ConflictAction result = ourAllActions.get(actionName);
        if (result == null) {
            throw new IllegalArgumentException("Unknown conflict action " + actionName);
        }
        ConflictAction conflictAction = result;
        if (conflictAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/conflict/ConflictAction", "from"));
        }
        return conflictAction;
    }

    static {
        ourAllActions = ContainerUtil.newHashMap();
        for (ConflictAction action : ConflictAction.values()) {
            ConflictAction.register(action);
        }
    }
}

