/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandAdapter;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ObjectsConvertor;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.LocalFileOperationsHandler;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.Processor;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.ActionWithTempFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RepeatSvnActionThroughBusy;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnChangelistListener;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.NodeKind;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.wc.SVNMoveClient;

public class SvnFileSystemListener
extends CommandAdapter
implements LocalFileOperationsHandler,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.SvnFileSystemListener");
    private final LocalFileSystem myLfs;
    private final MultiMap<Project, AddedFileInfo> myAddedFiles = new MultiMap();
    private final MultiMap<Project, File> myDeletedFiles = new MultiMap();
    private final List<MovedFileInfo> myMovedFiles = new ArrayList<MovedFileInfo>();
    private final Map<Project, List<VcsException>> myMoveExceptions = new HashMap<Project, List<VcsException>>();
    private final List<VirtualFile> myFilesToRefresh = new ArrayList<VirtualFile>();
    @Nullable
    private File myStorageForUndo;
    private final List<Couple<File>> myUndoStorageContents = new ArrayList<Couple<File>>();
    private boolean myUndoingMove = false;
    private boolean myIsInCommand;
    @Nullable
    private Project myGuessedProject;

    public SvnFileSystemListener() {
        this.myLfs = LocalFileSystem.getInstance();
        this.myLfs.registerAuxiliaryFileOperationsHandler((LocalFileOperationsHandler)this);
        CommandProcessor.getInstance().addCommandListener((CommandListener)this);
    }

    public void dispose() {
        this.myLfs.unregisterAuxiliaryFileOperationsHandler((LocalFileOperationsHandler)this);
        CommandProcessor.getInstance().removeCommandListener((CommandListener)this);
    }

    private void addToMoveExceptions(@NotNull Project project, @NotNull Exception e) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/SvnFileSystemListener", "addToMoveExceptions"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/svn/SvnFileSystemListener", "addToMoveExceptions"));
        }
        List<VcsException> exceptionList = this.myMoveExceptions.get(project);
        if (exceptionList == null) {
            exceptionList = new ArrayList<VcsException>();
            this.myMoveExceptions.put(project, exceptionList);
        }
        exceptionList.add(SvnFileSystemListener.handleMoveException(e));
    }

    private static VcsException handleMoveException(@NotNull Exception e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/svn/SvnFileSystemListener", "handleMoveException"));
        }
        VcsException vcsException = e instanceof SVNException && SVNErrorCode.ENTRY_EXISTS.equals((Object)((SVNException)((Object)e)).getErrorMessage().getErrorCode()) || e instanceof SvnBindException && ((SvnBindException)((Object)e)).contains(SVNErrorCode.ENTRY_EXISTS) ? SvnFileSystemListener.createMoveTargetExistsError(e) : (e instanceof VcsException ? (VcsException)((Object)e) : new VcsException((Throwable)e));
        return vcsException;
    }

    private static VcsException createMoveTargetExistsError(@NotNull Exception e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/svn/SvnFileSystemListener", "createMoveTargetExistsError"));
        }
        return new VcsException(Arrays.asList("Target of move operation is already under version control.", "Subversion move had not been performed. ", e.getMessage()));
    }

    @Nullable
    public File copy(VirtualFile file, VirtualFile toDir, String copyName) throws IOException {
        this.startOperation(file);
        SvnVcs vcs = SvnFileSystemListener.getVCS(toDir);
        if (vcs == null) {
            vcs = SvnFileSystemListener.getVCS(file);
        }
        if (vcs == null) {
            return null;
        }
        File srcFile = new File(file.getPath());
        File destFile = new File(new File(toDir.getPath()), copyName);
        boolean dstDirUnderControl = SvnUtil.isSvnVersioned(vcs.getProject(), destFile.getParentFile());
        if (!dstDirUnderControl && !this.isPendingAdd(vcs.getProject(), toDir)) {
            return null;
        }
        if (!SvnUtil.isSvnVersioned(vcs.getProject(), srcFile.getParentFile())) {
            this.myAddedFiles.putValue((Object)vcs.getProject(), (Object)new AddedFileInfo(toDir, copyName, null, false));
            return null;
        }
        Status fileStatus = SvnFileSystemListener.getFileStatus(vcs, srcFile);
        if (fileStatus != null && fileStatus.is(StatusType.STATUS_ADDED)) {
            this.myAddedFiles.putValue((Object)vcs.getProject(), (Object)new AddedFileInfo(toDir, copyName, null, false));
            return null;
        }
        if (this.sameRoot(vcs, file.getParent(), toDir)) {
            this.myAddedFiles.putValue((Object)vcs.getProject(), (Object)new AddedFileInfo(toDir, copyName, srcFile, false));
            return null;
        }
        this.myAddedFiles.putValue((Object)vcs.getProject(), (Object)new AddedFileInfo(toDir, copyName, null, false));
        return null;
    }

    private boolean sameRoot(SvnVcs vcs, VirtualFile srcDir, VirtualFile dstDir) {
        UUIDHelper helper = new UUIDHelper(vcs);
        String srcUUID = helper.getRepositoryUUID(vcs.getProject(), srcDir);
        String dstUUID = helper.getRepositoryUUID(vcs.getProject(), dstDir);
        return srcUUID != null && dstUUID != null && srcUUID.equals(dstUUID);
    }

    public boolean move(VirtualFile file, VirtualFile toDir) throws IOException {
        this.startOperation(file);
        File srcFile = SvnFileSystemListener.getIOFile(file);
        File dstFile = new File(SvnFileSystemListener.getIOFile(toDir), file.getName());
        SvnVcs vcs = SvnFileSystemListener.getVCS(toDir);
        SvnVcs sourceVcs = SvnFileSystemListener.getVCS(file);
        if (vcs == null) {
            return false;
        }
        if (sourceVcs == null) {
            return this.createItem(toDir, file.getName(), file.isDirectory(), true);
        }
        if (this.isPendingAdd(vcs.getProject(), toDir)) {
            this.myMovedFiles.add(new MovedFileInfo(sourceVcs.getProject(), srcFile, dstFile));
            return true;
        }
        this.myFilesToRefresh.add(file.getParent());
        this.myFilesToRefresh.add(toDir);
        return this.doMove(sourceVcs, srcFile, dstFile);
    }

    public boolean rename(VirtualFile file, String newName) throws IOException {
        this.startOperation(file);
        File srcFile = SvnFileSystemListener.getIOFile(file);
        File dstFile = new File(srcFile.getParentFile(), newName);
        SvnVcs vcs = SvnFileSystemListener.getVCS(file);
        if (vcs != null) {
            this.myFilesToRefresh.add(file.getParent());
            return this.doMove(vcs, srcFile, dstFile);
        }
        return false;
    }

    private boolean doMove(@NotNull SvnVcs vcs, File src, File dst) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/SvnFileSystemListener", "doMove"));
        }
        try {
            Status srcStatus;
            boolean isUndo = SvnFileSystemListener.isUndo(vcs);
            String list = isUndo ? null : SvnChangelistListener.getCurrentMapping(vcs, src);
            WorkingCopyFormat format = vcs.getWorkingCopyFormat(src);
            boolean is17OrLater = format.isOrGreater(WorkingCopyFormat.ONE_DOT_SEVEN);
            if (is17OrLater ? SvnFileSystemListener.isUnversioned(srcStatus = SvnFileSystemListener.getFileStatus(vcs, src)) && (SvnFileSystemListener.isUnversioned(vcs, dst.getParentFile()) || SvnFileSystemListener.isUnversioned(vcs, dst)) || this.for17move(vcs, src, dst, isUndo, srcStatus) : this.for16move(vcs, src, dst, isUndo)) {
                return false;
            }
            if (!isUndo && list != null) {
                SvnChangelistListener.putUnderList(vcs, list, dst);
            }
        }
        catch (VcsException e) {
            this.addToMoveExceptions(vcs.getProject(), (Exception)((Object)e));
            return false;
        }
        return true;
    }

    private static boolean isUnversioned(@Nullable Status status) {
        return status == null || status.is(StatusType.STATUS_UNVERSIONED);
    }

    private static boolean isUnversioned(@NotNull SvnVcs vcs, @NotNull File file) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/SvnFileSystemListener", "isUnversioned"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/SvnFileSystemListener", "isUnversioned"));
        }
        return SvnFileSystemListener.isUnversioned(SvnFileSystemListener.getFileStatus(vcs, file));
    }

    private boolean for17move(SvnVcs vcs, File src, File dst, boolean undo, Status srcStatus) throws VcsException {
        if (srcStatus != null && srcStatus.getCopyFromURL() == null) {
            undo = false;
        }
        if (undo) {
            this.myUndoingMove = true;
            SvnFileSystemListener.createRevertAction(vcs, dst, true).execute();
            SvnFileSystemListener.copyUnversionedMembersOfDirectory(src, dst);
            if (SvnFileSystemListener.isUnversioned(srcStatus)) {
                FileUtil.delete((File)src);
            } else {
                SvnFileSystemListener.createRevertAction(vcs, src, true).execute();
            }
            this.restoreFromUndoStorage(dst);
        } else {
            if (SvnFileSystemListener.doUsualMove(vcs, src)) {
                return true;
            }
            if (SvnFileSystemListener.isUnversioned(vcs, dst.getParentFile())) {
                try {
                    FileUtil.copyFileOrDir((File)src, (File)dst);
                }
                catch (IOException e) {
                    throw new SvnBindException(e);
                }
                SvnFileSystemListener.createDeleteAction(vcs, src, true).execute();
                return false;
            }
            SvnFileSystemListener.moveFileWithSvn(vcs, src, dst);
        }
        return false;
    }

    public static void moveFileWithSvn(final SvnVcs vcs, final File src, final File dst) throws VcsException {
        new RepeatSvnActionThroughBusy(){

            @Override
            protected void executeImpl() throws VcsException {
                vcs.getFactory(src).createCopyMoveClient().copy(src, dst, false, true);
            }
        }.execute();
    }

    private static void copyUnversionedMembersOfDirectory(final File src, final File dst) throws SvnBindException {
        if (src.isDirectory()) {
            final SvnBindException[] exc = new SvnBindException[1];
            FileUtil.processFilesRecursively((File)src, (Processor)new Processor<File>(){

                public boolean process(File file) {
                    String relativePath = FileUtil.getRelativePath((File)src, (File)file);
                    File newFile = new File(dst, relativePath);
                    if (!newFile.exists()) {
                        try {
                            FileUtil.copyFileOrDir((File)src, (File)dst);
                        }
                        catch (IOException e) {
                            exc[0] = new SvnBindException(e);
                            return false;
                        }
                    }
                    return true;
                }
            });
            if (exc[0] != null) {
                throw exc[0];
            }
        }
    }

    private static boolean doUsualMove(SvnVcs vcs, File src) {
        Status srcStatus = SvnFileSystemListener.getFileStatus(vcs, src);
        return srcStatus == null || srcStatus.is(StatusType.STATUS_UNVERSIONED, StatusType.STATUS_OBSTRUCTED, StatusType.STATUS_MISSING, StatusType.STATUS_EXTERNAL);
    }

    private boolean for16move(SvnVcs vcs, final File src, final File dst, final boolean undo) throws VcsException {
        final SVNMoveClient mover = vcs.getSvnKitManager().createMoveClient();
        if (undo) {
            this.myUndoingMove = true;
            this.restoreFromUndoStorage(dst);
        } else if (SvnFileSystemListener.doUsualMove(vcs, src)) {
            return true;
        }
        new RepeatSvnActionThroughBusy(){

            @Override
            protected void executeImpl() throws VcsException {
                try {
                    if (undo) {
                        mover.undoMove(src, dst);
                    } else {
                        mover.doMove(src, dst);
                    }
                }
                catch (SVNException e) {
                    throw new SvnBindException(e);
                }
            }
        }.execute();
        return false;
    }

    private void restoreFromUndoStorage(File dst) {
        File[] files;
        String normPath = FileUtil.toSystemIndependentName((String)dst.getPath());
        Iterator<Couple<File>> it = this.myUndoStorageContents.iterator();
        while (it.hasNext()) {
            Couple<File> e = it.next();
            String p = FileUtil.toSystemIndependentName((String)((File)e.first).getPath());
            if (!p.startsWith(normPath)) continue;
            try {
                FileUtil.rename((File)((File)e.second), (File)((File)e.first));
            }
            catch (IOException ex) {
                LOG.error((Throwable)ex);
                FileUtil.asyncDelete((File)((File)e.second));
            }
            it.remove();
        }
        if (this.myStorageForUndo != null && ((files = this.myStorageForUndo.listFiles()) == null || files.length == 0)) {
            FileUtil.asyncDelete((File)this.myStorageForUndo);
            this.myStorageForUndo = null;
        }
    }

    public boolean createFile(VirtualFile dir, String name) throws IOException {
        this.startOperation(dir);
        return this.createItem(dir, name, false, false);
    }

    public boolean createDirectory(VirtualFile dir, String name) throws IOException {
        this.startOperation(dir);
        return this.createItem(dir, name, true, false);
    }

    public boolean delete(VirtualFile file) throws IOException {
        this.startOperation(file);
        SvnVcs vcs = SvnFileSystemListener.getVCS(file);
        if (vcs != null && SvnUtil.isAdminDirectory(file)) {
            return true;
        }
        if (vcs == null) {
            return false;
        }
        VcsShowConfirmationOption.Value value = vcs.getDeleteConfirmation().getValue();
        if (VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY.equals((Object)value)) {
            return false;
        }
        File ioFile = SvnFileSystemListener.getIOFile(file);
        if (!SvnUtil.isSvnVersioned(vcs, ioFile.getParentFile()) || SvnUtil.isWorkingCopyRoot(ioFile)) {
            return false;
        }
        Status status = SvnFileSystemListener.getFileStatus(vcs, ioFile);
        if (status == null || status.is(StatusType.STATUS_UNVERSIONED, StatusType.STATUS_OBSTRUCTED, StatusType.STATUS_MISSING, StatusType.STATUS_EXTERNAL, StatusType.STATUS_IGNORED)) {
            return false;
        }
        if (status.is(StatusType.STATUS_DELETED)) {
            if (SvnFileSystemListener.isUndo(vcs)) {
                this.moveToUndoStorage(file);
            }
            return true;
        }
        if (this.isAboveSourceOfCopyOrMove(vcs.getProject(), ioFile)) {
            this.myDeletedFiles.putValue((Object)vcs.getProject(), (Object)ioFile);
            return true;
        }
        if (status.is(StatusType.STATUS_ADDED)) {
            try {
                SvnFileSystemListener.createRevertAction(vcs, ioFile, false).execute();
            }
            catch (VcsException vcsException) {}
        } else {
            this.myDeletedFiles.putValue((Object)vcs.getProject(), (Object)ioFile);
            if (file.isDirectory() || SvnFileSystemListener.isUndo(vcs)) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static RepeatSvnActionThroughBusy createRevertAction(final @NotNull SvnVcs vcs, final @NotNull File file, final boolean recursive) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/SvnFileSystemListener", "createRevertAction"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/SvnFileSystemListener", "createRevertAction"));
        }
        RepeatSvnActionThroughBusy repeatSvnActionThroughBusy = new RepeatSvnActionThroughBusy(){

            @Override
            protected void executeImpl() throws VcsException {
                vcs.getFactory(file).createRevertClient().revert(Collections.singletonList(file), Depth.allOrFiles(recursive), null);
            }
        };
        if (repeatSvnActionThroughBusy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnFileSystemListener", "createRevertAction"));
        }
        return repeatSvnActionThroughBusy;
    }

    @NotNull
    private static RepeatSvnActionThroughBusy createDeleteAction(final @NotNull SvnVcs vcs, final @NotNull File file, final boolean force) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/SvnFileSystemListener", "createDeleteAction"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/SvnFileSystemListener", "createDeleteAction"));
        }
        RepeatSvnActionThroughBusy repeatSvnActionThroughBusy = new RepeatSvnActionThroughBusy(){

            @Override
            protected void executeImpl() throws VcsException {
                vcs.getFactory(file).createDeleteClient().delete(file, force, false, null);
            }
        };
        if (repeatSvnActionThroughBusy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnFileSystemListener", "createDeleteAction"));
        }
        return repeatSvnActionThroughBusy;
    }

    private boolean isAboveSourceOfCopyOrMove(Project p, File ioFile) {
        for (MovedFileInfo file : this.myMovedFiles) {
            if (!FileUtil.isAncestor((File)ioFile, (File)file.mySrc, (boolean)false)) continue;
            return true;
        }
        for (AddedFileInfo info : this.myAddedFiles.get((Object)p)) {
            if (info.myCopyFrom == null || !FileUtil.isAncestor((File)ioFile, (File)info.myCopyFrom, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private void moveToUndoStorage(VirtualFile file) {
        if (this.myStorageForUndo == null) {
            try {
                this.myStorageForUndo = FileUtil.createTempDirectory((String)"svnUndoStorage", (String)"");
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return;
            }
        }
        File tmpFile = FileUtil.findSequentNonexistentFile((File)this.myStorageForUndo, (String)"tmp", (String)"");
        this.myUndoStorageContents.add(0, (Couple<File>)Couple.of((Object)new File(file.getPath()), (Object)tmpFile));
        new File(file.getPath()).renameTo(tmpFile);
    }

    private boolean createItem(VirtualFile dir, String name, boolean directory, boolean recursive) {
        SvnVcs vcs = SvnFileSystemListener.getVCS(dir);
        if (vcs == null) {
            return false;
        }
        VcsShowConfirmationOption.Value value = vcs.getAddConfirmation().getValue();
        if (VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY.equals((Object)value)) {
            return false;
        }
        if (SvnFileSystemListener.isUndo(vcs) && SvnUtil.isAdminDirectory(dir, name)) {
            return false;
        }
        File ioDir = SvnFileSystemListener.getIOFile(dir);
        boolean pendingAdd = this.isPendingAdd(vcs.getProject(), dir);
        if (!SvnUtil.isSvnVersioned(vcs, ioDir) && !pendingAdd) {
            return false;
        }
        File targetFile = new File(ioDir, name);
        Status status = SvnFileSystemListener.getFileStatus(vcs, targetFile);
        if (status == null || status.getContentsStatus() == StatusType.STATUS_NONE || status.getContentsStatus() == StatusType.STATUS_UNVERSIONED) {
            this.myAddedFiles.putValue((Object)vcs.getProject(), (Object)new AddedFileInfo(dir, name, null, recursive));
            return false;
        }
        if (status.is(StatusType.STATUS_MISSING)) {
            return false;
        }
        if (status.is(StatusType.STATUS_DELETED)) {
            NodeKind kind = status.getKind();
            if (directory && !kind.isDirectory() || !directory && !kind.isFile()) {
                return false;
            }
            try {
                if (SvnFileSystemListener.isUndo(vcs)) {
                    SvnFileSystemListener.createRevertAction(vcs, targetFile, false).execute();
                    return true;
                }
                this.myAddedFiles.putValue((Object)vcs.getProject(), (Object)new AddedFileInfo(dir, name, null, recursive));
                return false;
            }
            catch (VcsException e) {
                SVNFileUtil.deleteAll((File)targetFile, (boolean)true);
                return false;
            }
        }
        return false;
    }

    private boolean isPendingAdd(Project project, VirtualFile dir) {
        Collection addedFileInfos = this.myAddedFiles.get((Object)project);
        for (AddedFileInfo i : addedFileInfos) {
            if (!Comparing.equal((Object)i.myDir, (Object)dir.getParent()) || !i.myName.equals(dir.getName())) continue;
            return true;
        }
        return false;
    }

    public void commandStarted(@NotNull CommandEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/svn/SvnFileSystemListener", "commandStarted"));
        }
        this.myIsInCommand = true;
        this.myUndoingMove = false;
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        this.commandStarted(project);
    }

    void commandStarted(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/SvnFileSystemListener", "commandStarted"));
        }
        this.myUndoingMove = false;
        this.myMoveExceptions.remove(project);
    }

    public void commandFinished(@NotNull CommandEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/svn/SvnFileSystemListener", "commandFinished"));
        }
        this.myIsInCommand = false;
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        this.commandFinished(project);
    }

    void commandFinished(@NotNull Project project) {
        List<VcsException> exceptionList;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/SvnFileSystemListener", "commandFinished"));
        }
        this.checkOverwrites(project);
        if (this.myAddedFiles.containsKey((Object)project)) {
            this.processAddedFiles(project);
        }
        this.processMovedFiles(project);
        if (this.myDeletedFiles.containsKey((Object)project)) {
            this.processDeletedFiles(project);
        }
        if ((exceptionList = this.myMoveExceptions.get(project)) != null && !exceptionList.isEmpty()) {
            AbstractVcsHelper.getInstance((Project)project).showErrors(exceptionList, SvnBundle.message("move.files.errors.title", new Object[0]));
        }
        if (!this.myFilesToRefresh.isEmpty()) {
            this.refreshFiles(project);
        }
    }

    private void checkOverwrites(Project project) {
        Collection addedFileInfos = this.myAddedFiles.get((Object)project);
        Collection deletedFiles = this.myDeletedFiles.get((Object)project);
        if (addedFileInfos.isEmpty() || deletedFiles.isEmpty()) {
            return;
        }
        Iterator iterator = addedFileInfos.iterator();
        while (iterator.hasNext()) {
            AddedFileInfo addedFileInfo = (AddedFileInfo)iterator.next();
            File ioFile = new File(addedFileInfo.myDir.getPath(), addedFileInfo.myName);
            if (!deletedFiles.remove(ioFile)) continue;
            iterator.remove();
        }
    }

    private void refreshFiles(final Project project) {
        final ArrayList<VirtualFile> toRefreshFiles = new ArrayList<VirtualFile>();
        final ArrayList<VirtualFile> toRefreshDirs = new ArrayList<VirtualFile>();
        for (VirtualFile file : this.myFilesToRefresh) {
            if (file == null) continue;
            if (file.isDirectory()) {
                toRefreshDirs.add(file);
                continue;
            }
            toRefreshFiles.add(file);
        }
        SvnFileSystemListener.filterOutInvalid(this.myFilesToRefresh);
        RefreshQueue.getInstance().refresh(true, true, new Runnable(){

            @Override
            public void run() {
                if (project.isDisposed()) {
                    return;
                }
                SvnFileSystemListener.filterOutInvalid(toRefreshFiles);
                SvnFileSystemListener.filterOutInvalid(toRefreshDirs);
                VcsDirtyScopeManager vcsDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)project);
                vcsDirtyScopeManager.filesDirty((Collection)toRefreshFiles, (Collection)toRefreshDirs);
            }
        }, this.myFilesToRefresh);
        this.myFilesToRefresh.clear();
    }

    private static void filterOutInvalid(Collection<VirtualFile> files) {
        Iterator<VirtualFile> iterator = files.iterator();
        while (iterator.hasNext()) {
            VirtualFile file = iterator.next();
            if (file.isValid() && file.exists()) continue;
            LOG.info("Refresh root is not valid: " + file.getPath());
            iterator.remove();
        }
    }

    private void processAddedFiles(final Project project) {
        final SvnVcs vcs = SvnVcs.getInstance(project);
        final ArrayList<VirtualFile> addedVFiles = new ArrayList<VirtualFile>();
        final HashMap<VirtualFile, File> copyFromMap = new HashMap<VirtualFile, File>();
        HashSet<VirtualFile> recursiveItems = new HashSet<VirtualFile>();
        this.fillAddedFiles(project, vcs, addedVFiles, copyFromMap, recursiveItems);
        if (addedVFiles.isEmpty()) {
            return;
        }
        final VcsShowConfirmationOption.Value value = vcs.getAddConfirmation().getValue();
        if (value != VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
            SvnFileSystemListener.runNotUnderWriteAction(project, new Runnable(){

                @Override
                public void run() {
                    AbstractVcsHelper vcsHelper = AbstractVcsHelper.getInstance((Project)project);
                    Collection filesToProcess = SvnFileSystemListener.promptAboutAddition(vcs, addedVFiles, value, vcsHelper);
                    if (filesToProcess != null && !filesToProcess.isEmpty()) {
                        ArrayList exceptions = new ArrayList();
                        SvnFileSystemListener.runInBackground(project, "Adding files to Subversion", SvnFileSystemListener.createAdditionRunnable(project, vcs, copyFromMap, filesToProcess, exceptions));
                        if (!exceptions.isEmpty()) {
                            vcsHelper.showErrors(exceptions, SvnBundle.message("add.files.errors.title", new Object[0]));
                        }
                    }
                }
            });
        }
    }

    private static void runNotUnderWriteAction(@NotNull Project project, @NotNull Runnable runnable) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/SvnFileSystemListener", "runNotUnderWriteAction"));
        }
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "org/jetbrains/idea/svn/SvnFileSystemListener", "runNotUnderWriteAction"));
        }
        Application application = ApplicationManager.getApplication();
        if (application.isWriteAccessAllowed()) {
            application.invokeLater(runnable, project.getDisposed());
        } else {
            runnable.run();
        }
    }

    private static void runInBackground(Project project, String name, Runnable runnable) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, name, false, project);
        } else {
            runnable.run();
        }
    }

    private static Runnable createAdditionRunnable(final Project project, final SvnVcs vcs, final Map<VirtualFile, File> copyFromMap, final Collection<VirtualFile> filesToProcess, final List<VcsException> exceptions) {
        return new Runnable(){

            @Override
            public void run() {
                for (VirtualFile file : filesToProcess) {
                    final File ioFile = new File(file.getPath());
                    try {
                        final File copyFrom = (File)copyFromMap.get(file);
                        if (copyFrom != null) {
                            try {
                                new ActionWithTempFile(ioFile){

                                    protected void executeInternal() throws VcsException {
                                        new RepeatSvnActionThroughBusy(){

                                            @Override
                                            protected void executeImpl() throws VcsException {
                                                vcs.getFactory(copyFrom).createCopyMoveClient().copy(copyFrom, ioFile, true, false);
                                            }
                                        }.execute();
                                    }
                                }.execute();
                            }
                            catch (VcsException e) {
                                exceptions.add(e);
                            }
                        } else {
                            new RepeatSvnActionThroughBusy(){

                                @Override
                                protected void executeImpl() throws VcsException {
                                    vcs.getFactory(ioFile).createAddClient().add(ioFile, null, false, false, true, null);
                                }
                            }.execute();
                        }
                        VcsDirtyScopeManager.getInstance((Project)project).fileDirty(file);
                    }
                    catch (VcsException e) {
                        exceptions.add(e);
                    }
                }
            }
        };
    }

    private static Collection<VirtualFile> promptAboutAddition(SvnVcs vcs, List<VirtualFile> addedVFiles, VcsShowConfirmationOption.Value value, AbstractVcsHelper vcsHelper) {
        Collection<Object> filesToProcess;
        if (value == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY) {
            filesToProcess = addedVFiles;
        } else {
            String singleFilePrompt = addedVFiles.size() == 1 && addedVFiles.get(0).isDirectory() ? SvnBundle.getString("confirmation.text.add.dir") : SvnBundle.getString("confirmation.text.add.file");
            filesToProcess = vcsHelper.selectFilesToProcess(addedVFiles, SvnBundle.message("confirmation.title.add.multiple.files", new Object[0]), null, SvnBundle.message("confirmation.title.add.file", new Object[0]), singleFilePrompt, vcs.getAddConfirmation());
        }
        return filesToProcess;
    }

    private void fillAddedFiles(Project project, SvnVcs vcs, List<VirtualFile> addedVFiles, Map<VirtualFile, File> copyFromMap, Set<VirtualFile> recursiveItems) {
        Collection addedFileInfos = this.myAddedFiles.remove((Object)project);
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        for (AddedFileInfo addedFileInfo : addedFileInfos) {
            boolean isIgnored;
            Status fileStatus;
            File ioFile = new File(SvnFileSystemListener.getIOFile(addedFileInfo.myDir), addedFileInfo.myName);
            VirtualFile addedFile = addedFileInfo.myDir.findChild(addedFileInfo.myName);
            if (addedFile == null) {
                addedFile = this.myLfs.refreshAndFindFileByIoFile(ioFile);
            }
            if (addedFile == null || (fileStatus = SvnFileSystemListener.getFileStatus(vcs, ioFile)) != null && fileStatus.is(StatusType.STATUS_IGNORED) || (isIgnored = changeListManager.isIgnoredFile(addedFile))) continue;
            addedVFiles.add(addedFile);
            copyFromMap.put(addedFile, addedFileInfo.myCopyFrom);
            if (!addedFileInfo.myRecursive) continue;
            recursiveItems.add(addedFile);
        }
    }

    private void processDeletedFiles(Project project) {
        ArrayList<Pair<FilePath, WorkingCopyFormat>> deletedFiles = new ArrayList<Pair<FilePath, WorkingCopyFormat>>();
        ArrayList<FilePath> filesToProcess = new ArrayList<FilePath>();
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        AbstractVcsHelper vcsHelper = AbstractVcsHelper.getInstance((Project)project);
        try {
            this.fillDeletedFiles(project, deletedFiles, filesToProcess);
            if (deletedFiles.isEmpty() && filesToProcess.isEmpty() || this.myUndoingMove) {
                return;
            }
            SvnVcs vcs = SvnVcs.getInstance(project);
            VcsShowConfirmationOption.Value value = vcs.getDeleteConfirmation().getValue();
            if (value != VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
                Collection<FilePath> confirmed;
                if (!deletedFiles.isEmpty() && (confirmed = SvnFileSystemListener.promptAboutDeletion(deletedFiles, vcs, value, vcsHelper)) != null) {
                    filesToProcess.addAll(confirmed);
                }
                if (!filesToProcess.isEmpty()) {
                    SvnFileSystemListener.runInBackground(project, "Deleting files from Subversion", SvnFileSystemListener.createDeleteRunnable(project, vcs, filesToProcess, exceptions));
                }
                List deletedFilesFiles = ObjectsConvertor.convert(deletedFiles, (Convertor)new Convertor<Pair<FilePath, WorkingCopyFormat>, FilePath>(){

                    public FilePath convert(Pair<FilePath, WorkingCopyFormat> o) {
                        return (FilePath)o.getFirst();
                    }
                });
                for (FilePath file : deletedFilesFiles) {
                    FilePath parent = file.getParentPath();
                    if (parent == null) continue;
                    this.myFilesToRefresh.add(parent.getVirtualFile());
                }
                deletedFilesFiles.removeAll(filesToProcess);
                for (FilePath file : deletedFilesFiles) {
                    FileUtil.delete((File)file.getIOFile());
                }
            }
        }
        catch (VcsException e) {
            exceptions.add(e);
        }
        if (!exceptions.isEmpty()) {
            vcsHelper.showErrors(exceptions, SvnBundle.message("delete.files.errors.title", new Object[0]));
        }
    }

    private static Runnable createDeleteRunnable(final Project project, final SvnVcs vcs, final Collection<FilePath> filesToProcess, final List<VcsException> exceptions) {
        return new Runnable(){

            @Override
            public void run() {
                for (FilePath file : filesToProcess) {
                    VirtualFile vFile = file.getVirtualFile();
                    File ioFile = new File(file.getPath());
                    try {
                        SvnFileSystemListener.createDeleteAction(vcs, ioFile, true).execute();
                        if (vFile != null && vFile.isValid() && vFile.isDirectory()) {
                            vFile.refresh(true, true);
                            VcsDirtyScopeManager.getInstance((Project)project).dirDirtyRecursively(vFile);
                            continue;
                        }
                        VcsDirtyScopeManager.getInstance((Project)project).fileDirty(file);
                    }
                    catch (VcsException e) {
                        exceptions.add(e);
                    }
                }
            }
        };
    }

    private static Collection<FilePath> promptAboutDeletion(List<Pair<FilePath, WorkingCopyFormat>> deletedFiles, SvnVcs vcs, VcsShowConfirmationOption.Value value, AbstractVcsHelper vcsHelper) {
        List filesToProcess;
        Convertor<Pair<FilePath, WorkingCopyFormat>, FilePath> convertor = new Convertor<Pair<FilePath, WorkingCopyFormat>, FilePath>(){

            public FilePath convert(Pair<FilePath, WorkingCopyFormat> o) {
                return (FilePath)o.getFirst();
            }
        };
        if (value == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY) {
            filesToProcess = ObjectsConvertor.convert(deletedFiles, (Convertor)convertor);
        } else {
            String singleFilePrompt = deletedFiles.size() == 1 && ((FilePath)deletedFiles.get(0).getFirst()).isDirectory() ? (((WorkingCopyFormat)((Object)deletedFiles.get(0).getSecond())).isOrGreater(WorkingCopyFormat.ONE_DOT_SEVEN) ? SvnBundle.getString("confirmation.text.delete.dir.17") : SvnBundle.getString("confirmation.text.delete.dir")) : SvnBundle.getString("confirmation.text.delete.file");
            Collection files = vcsHelper.selectFilePathsToProcess(ObjectsConvertor.convert(deletedFiles, (Convertor)convertor), SvnBundle.message("confirmation.title.delete.multiple.files", new Object[0]), null, SvnBundle.message("confirmation.title.delete.file", new Object[0]), singleFilePrompt, vcs.getDeleteConfirmation());
            filesToProcess = files == null ? null : new ArrayList(files);
        }
        return filesToProcess;
    }

    private void fillDeletedFiles(Project project, List<Pair<FilePath, WorkingCopyFormat>> deletedFiles, Collection<FilePath> deleteAnyway) throws VcsException {
        final SvnVcs vcs = SvnVcs.getInstance(project);
        Collection files = this.myDeletedFiles.remove((Object)project);
        for (final File file : files) {
            Status status = (Status)new RepeatSvnActionThroughBusy(){

                @Override
                protected void executeImpl() throws VcsException {
                    this.myT = vcs.getFactory(file).createStatusClient().doStatus(file, false);
                }
            }.compute();
            FilePath filePath = VcsUtil.getFilePath((File)file);
            if (StatusType.STATUS_ADDED.equals((Object)status.getNodeStatus())) {
                deleteAnyway.add(filePath);
                continue;
            }
            deletedFiles.add((Pair<FilePath, WorkingCopyFormat>)Pair.create((Object)filePath, (Object)((Object)vcs.getWorkingCopyFormat(file))));
        }
    }

    private void processMovedFiles(final Project project) {
        if (this.myMovedFiles.isEmpty()) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Iterator iterator = SvnFileSystemListener.this.myMovedFiles.iterator();
                while (iterator.hasNext()) {
                    MovedFileInfo movedFileInfo = (MovedFileInfo)iterator.next();
                    if (movedFileInfo.myProject != project) continue;
                    SvnFileSystemListener.this.doMove(SvnVcs.getInstance(project), movedFileInfo.mySrc, movedFileInfo.myDst);
                    iterator.remove();
                }
            }
        };
        SvnFileSystemListener.runInBackground(project, "Moving files in Subversion", runnable);
    }

    @Nullable
    private static SvnVcs getVCS(VirtualFile file) {
        Project[] projects;
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(file);
            if (!(vcs instanceof SvnVcs)) continue;
            return (SvnVcs)vcs;
        }
        return null;
    }

    private static File getIOFile(VirtualFile vf) {
        return new File(vf.getPath()).getAbsoluteFile();
    }

    @Nullable
    private static Status getFileStatus(final @NotNull SvnVcs vcs, final @NotNull File file) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/SvnFileSystemListener", "getFileStatus"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/SvnFileSystemListener", "getFileStatus"));
        }
        try {
            return (Status)new RepeatSvnActionThroughBusy(){

                @Override
                protected void executeImpl() throws VcsException {
                    this.myT = vcs.getFactory(file).createStatusClient().doStatus(file, false);
                }
            }.compute();
        }
        catch (VcsException e) {
            return null;
        }
    }

    private static boolean isUndo(SvnVcs vcs) {
        if (vcs == null || vcs.getProject() == null) {
            return false;
        }
        Project p = vcs.getProject();
        return UndoManager.getInstance((Project)p).isUndoInProgress();
    }

    public void startOperation(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/SvnFileSystemListener", "startOperation"));
        }
        if (!this.myIsInCommand) {
            this.myGuessedProject = ProjectLocator.getInstance().guessProjectForFile(file);
            if (this.myGuessedProject != null) {
                this.commandStarted(this.myGuessedProject);
            }
        }
    }

    public void afterDone(ThrowableConsumer<LocalFileOperationsHandler, IOException> invoker) {
        if (!this.myIsInCommand && this.myGuessedProject != null) {
            this.commandFinished(this.myGuessedProject);
            this.myGuessedProject = null;
        }
    }

    private class UUIDHelper {
        private final SvnVcs myVcs;

        private UUIDHelper(SvnVcs vcs) {
            this.myVcs = vcs;
        }

        @Nullable
        public String getRepositoryUUID(Project project, final VirtualFile dir) {
            block5: {
                try {
                    Info info1 = (Info)new RepeatSvnActionThroughBusy(){

                        @Override
                        protected void executeImpl() {
                            this.myT = UUIDHelper.this.myVcs.getInfo(new File(dir.getPath()));
                        }
                    }.compute();
                    if (info1 == null || info1.getRepositoryUUID() == null) {
                        VirtualFile parent = dir.getParent();
                        if (parent == null) {
                            return null;
                        }
                        if (SvnFileSystemListener.this.isPendingAdd(project, parent)) {
                            return this.getRepositoryUUID(project, parent);
                        }
                        break block5;
                    }
                    return info1.getRepositoryUUID();
                }
                catch (VcsException vcsException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private static class MovedFileInfo {
        private final Project myProject;
        private final File mySrc;
        private final File myDst;

        private MovedFileInfo(Project project, File src, File dst) {
            this.myProject = project;
            this.mySrc = src;
            this.myDst = dst;
        }
    }

    private static class AddedFileInfo {
        private final VirtualFile myDir;
        private final String myName;
        @Nullable
        private final File myCopyFrom;
        private final boolean myRecursive;

        public AddedFileInfo(VirtualFile dir, String name, @Nullable File copyFrom, boolean recursive) {
            this.myDir = dir;
            this.myName = name;
            this.myCopyFrom = copyFrom;
            this.myRecursive = recursive;
        }
    }
}

