/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.actions.DvcsCompareWithBranchAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsDiffUtil;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitBranch;
import git4idea.GitContentRevision;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.history.GitHistoryUtils;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitCompareWithBranchAction
extends DvcsCompareWithBranchAction<GitRepository> {
    protected boolean noBranchesToCompare(@NotNull GitRepository repository) {
        boolean haveRemotes;
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/actions/GitCompareWithBranchAction", "noBranchesToCompare"));
        }
        int locals = repository.getBranches().getLocalBranches().size();
        boolean bl = haveRemotes = !repository.getBranches().getRemoteBranches().isEmpty();
        if (repository.isOnBranch()) {
            return locals < 2 && !haveRemotes;
        }
        return locals == 0 && !haveRemotes;
    }

    @NotNull
    protected List<String> getBranchNamesExceptCurrent(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/actions/GitCompareWithBranchAction", "getBranchNamesExceptCurrent"));
        }
        ArrayList<GitLocalBranch> localBranches = new ArrayList<GitLocalBranch>(repository.getBranches().getLocalBranches());
        Collections.sort(localBranches);
        ArrayList<GitRemoteBranch> remoteBranches = new ArrayList<GitRemoteBranch>(repository.getBranches().getRemoteBranches());
        Collections.sort(remoteBranches);
        if (repository.isOnBranch()) {
            localBranches.remove(repository.getCurrentBranch());
        }
        ArrayList branchNames = ContainerUtil.newArrayList();
        for (GitBranch gitBranch : localBranches) {
            branchNames.add(gitBranch.getName());
        }
        for (GitBranch gitBranch : remoteBranches) {
            branchNames.add(gitBranch.getName());
        }
        ArrayList arrayList = branchNames;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/actions/GitCompareWithBranchAction", "getBranchNamesExceptCurrent"));
        }
        return arrayList;
    }

    @NotNull
    protected GitRepositoryManager getRepositoryManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/actions/GitCompareWithBranchAction", "getRepositoryManager"));
        }
        GitRepositoryManager gitRepositoryManager = GitUtil.getRepositoryManager(project);
        if (gitRepositoryManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/actions/GitCompareWithBranchAction", "getRepositoryManager"));
        }
        return gitRepositoryManager;
    }

    @NotNull
    protected Collection<Change> getDiffChanges(@NotNull Project project, @NotNull VirtualFile file, @NotNull String branchToCompare) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/actions/GitCompareWithBranchAction", "getDiffChanges"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "git4idea/actions/GitCompareWithBranchAction", "getDiffChanges"));
        }
        if (branchToCompare == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchToCompare", "git4idea/actions/GitCompareWithBranchAction", "getDiffChanges"));
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
        GitRepository gitRepository = (GitRepository)GitUtil.getRepositoryManager(project).getRepositoryForFile(file);
        if (gitRepository == null) {
            throw new VcsException("Couldn't find Git Repository for " + file.getName());
        }
        VirtualFile gitRepositoryRoot = gitRepository.getRoot();
        GitRevisionNumber compareRevisionNumber = new GitRevisionNumber(branchToCompare);
        List changes = GitChangeUtils.getDiffWithWorkingDir(project, gitRepositoryRoot, branchToCompare, Collections.singletonList(filePath), false);
        if (changes.isEmpty() && GitHistoryUtils.getCurrentRevision(project, filePath, branchToCompare) == null) {
            throw new VcsException(GitCompareWithBranchAction.fileDoesntExistInBranchError((VirtualFile)file, (String)branchToCompare));
        }
        List list = changes.isEmpty() && !filePath.isDirectory() ? VcsDiffUtil.createChangesWithCurrentContentForFile((FilePath)filePath, (ContentRevision)GitContentRevision.createRevision(filePath, (VcsRevisionNumber)compareRevisionNumber, project, null)) : changes;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/actions/GitCompareWithBranchAction", "getDiffChanges"));
        }
        return list;
    }
}

