/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionBase;
import org.jetbrains.idea.devkit.util.ExtensionPointLocator;

public class StatefulEpInspection
extends DevKitInspectionBase {
    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass psiClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/idea/devkit/inspections/StatefulEpInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/idea/devkit/inspections/StatefulEpInspection", "checkClass"));
        }
        PsiField[] fields = psiClass.getFields();
        if (fields.length == 0) {
            return super.checkClass(psiClass, manager, isOnTheFly);
        }
        boolean isQuickFix = InheritanceUtil.isInheritor((PsiClass)psiClass, (String)LocalQuickFix.class.getCanonicalName());
        boolean isProjectComponent = InheritanceUtil.isInheritor((PsiClass)psiClass, (String)ProjectComponent.class.getCanonicalName());
        if (isQuickFix || ExtensionPointLocator.isRegisteredExtension(psiClass)) {
            ArrayList result = ContainerUtil.newArrayList();
            for (PsiField field : fields) {
                for (Class c : new Class[]{PsiElement.class, PsiReference.class, Project.class}) {
                    String message;
                    if (c == Project.class && (field.hasModifierProperty("final") || isProjectComponent)) continue;
                    String string = c == PsiElement.class ? "Potential memory leak: don't hold PsiElement, use SmartPsiElementPointer instead" + (isQuickFix ? "; also see LocalQuickFixOnPsiElement" : "") : (message = "Don't use " + c.getSimpleName() + " as a field in extension");
                    if (!InheritanceUtil.isInheritor((PsiType)field.getType(), (String)c.getCanonicalName())) continue;
                    result.add(manager.createProblemDescriptor((PsiElement)field, message, true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[0]));
                }
            }
            return result.toArray(new ProblemDescriptor[result.size()]);
        }
        return super.checkClass(psiClass, manager, isOnTheFly);
    }
}

