/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.ref;

import com.intellij.psi.PsiChildLink;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstanceofLink<Parent extends PsiElement, Child extends PsiElement, CastTo extends Child>
extends PsiChildLink<Parent, CastTo> {
    private final PsiChildLink<Parent, Child> myDelegate;
    private final Class<CastTo> myCastTo;

    private InstanceofLink(PsiChildLink<Parent, Child> delegate, Class<CastTo> castTo) {
        this.myDelegate = delegate;
        this.myCastTo = castTo;
    }

    @Override
    public CastTo findLinkedChild(@Nullable Parent parent) {
        Child existing = this.myDelegate.findLinkedChild(parent);
        return (CastTo)(this.myCastTo.isInstance(existing) ? existing : null);
    }

    @Override
    @NotNull
    public CastTo createChild(@NotNull Parent parent) throws IncorrectOperationException {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/ref/InstanceofLink", "createChild"));
        }
        PsiElement psiElement = (PsiElement)this.myDelegate.createChild(parent);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/ref/InstanceofLink", "createChild"));
        }
        return (CastTo)psiElement;
    }

    public static <Parent extends PsiElement, Child extends PsiElement, CastTo extends Child> InstanceofLink<Parent, Child, CastTo> create(PsiChildLink<Parent, Child> delegate, Class<CastTo> castTo) {
        return new InstanceofLink<Parent, Child, CastTo>(delegate, castTo);
    }
}

