/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.ui.UIUtil;
import java.awt.RenderingHints;
import sun.swing.SwingUtilities2;

public enum AntialiasingType {
    SUBPIXEL("Subpixel", RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB, true),
    GREYSCALE("Greyscale", RenderingHints.VALUE_TEXT_ANTIALIAS_ON, true),
    OFF("No antialiasing", RenderingHints.VALUE_TEXT_ANTIALIAS_OFF, false);

    private final String myName;
    private final Object myHint;
    private final boolean isEnabled;

    public static Object getAAHintForSwingComponent() {
        AntialiasingType type;
        Application application = ApplicationManager.getApplication();
        if (application != null && (type = UISettings.getInstance().IDE_AA_TYPE) != null) {
            return type.getTextInfo();
        }
        return GREYSCALE.getTextInfo();
    }

    public static Object getKeyForCurrentScope(boolean inEditor) {
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings != null) {
            AntialiasingType type;
            AntialiasingType antialiasingType = type = inEditor ? uiSettings.EDITOR_AA_TYPE : uiSettings.IDE_AA_TYPE;
            if (type != null) {
                return type.myHint;
            }
        }
        return RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
    }

    private AntialiasingType(String name, Object hint, boolean enabled) {
        this.myName = name;
        this.myHint = hint;
        this.isEnabled = enabled;
    }

    public SwingUtilities2.AATextInfo getTextInfo() {
        return !this.isEnabled ? null : new SwingUtilities2.AATextInfo(this.myHint, Integer.valueOf(UIUtil.getLcdContrastValue()));
    }

    public String toString() {
        return this.myName;
    }
}

