/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.quickfix;

import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.quickfix.AddGradleJUnitDependencyFix;
import com.android.tools.idea.gradle.quickfix.AddGradleJetbrainsAnnotationFix;
import com.android.tools.idea.gradle.quickfix.AddGradleLibraryDependencyFix;
import com.android.tools.idea.gradle.quickfix.AddGradleProjectDependencyFix;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.jarFinder.FindJarFix;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AndroidUnresolvedReferenceQuickFixProvider
extends UnresolvedReferenceQuickFixProvider<PsiJavaCodeReferenceElement> {
    public void registerFixes(@NotNull PsiJavaCodeReferenceElement reference, @NotNull QuickFixActionRegistrar registrar) {
        PsiClass[] classes;
        List<PsiClass> allowedDependencies;
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/android/tools/idea/gradle/quickfix/AndroidUnresolvedReferenceQuickFixProvider", "registerFixes"));
        }
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/android/tools/idea/gradle/quickfix/AndroidUnresolvedReferenceQuickFixProvider", "registerFixes"));
        }
        Module contextModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)reference);
        if (contextModule == null) {
            return;
        }
        AndroidGradleFacet gradleFacet = AndroidGradleFacet.getInstance(contextModule);
        if (gradleFacet == null) {
            return;
        }
        GradleBuildFile gradleBuildFile = GradleBuildFile.get(contextModule);
        if (gradleBuildFile == null) {
            return;
        }
        PsiFile contextFile = reference.getContainingFile();
        if (contextFile == null) {
            return;
        }
        VirtualFile classVFile = contextFile.getVirtualFile();
        if (classVFile == null) {
            return;
        }
        registrar.unregister((Condition)new Condition<IntentionAction>(){

            public boolean value(IntentionAction intentionAction) {
                return intentionAction instanceof OrderEntryFix || intentionAction instanceof FindJarFix;
            }
        });
        if (GradleUtil.getGradleBuildFile(contextModule) == null) {
            return;
        }
        PsiElement psiElement = reference.getElement();
        String referenceName = reference.getRangeInElement().substring(psiElement.getText());
        Project project = psiElement.getProject();
        if ("TestCase".equals(referenceName) || AndroidUnresolvedReferenceQuickFixProvider.isAnnotation(psiElement) && AndroidUnresolvedReferenceQuickFixProvider.isJunitAnnotationName(referenceName, psiElement)) {
            boolean isJunit4 = !referenceName.equals("TestCase");
            String className = isJunit4 ? "org.junit." + referenceName : "junit.framework.TestCase";
            GlobalSearchScope scope = contextModule.getModuleWithDependenciesAndLibrariesScope(true);
            PsiClass found = JavaPsiFacade.getInstance((Project)project).findClass(className, scope);
            if (found == null) {
                registrar.register((IntentionAction)new AddGradleJUnitDependencyFix(contextModule, (PsiReference)reference, className, isJunit4));
            }
        }
        if (AndroidUnresolvedReferenceQuickFixProvider.isAnnotation(psiElement) && AnnotationUtil.isJetbrainsAnnotation((String)referenceName) && !referenceName.equals("Nullable")) {
            String className = "org.jetbrains.annotations." + referenceName;
            GlobalSearchScope scope = contextModule.getModuleWithDependenciesAndLibrariesScope(true);
            PsiClass found = JavaPsiFacade.getInstance((Project)project).findClass(className, scope);
            if (found == null) {
                registrar.register((IntentionAction)new AddGradleJetbrainsAnnotationFix(contextModule, (PsiReference)reference, className));
            }
        }
        if (!(allowedDependencies = AndroidUnresolvedReferenceQuickFixProvider.filterAllowedDependencies(psiElement, classes = PsiShortNamesCache.getInstance((Project)project).getClassesByName(referenceName, GlobalSearchScope.allScope((Project)project)))).isEmpty()) {
            classes = allowedDependencies.toArray(new PsiClass[allowedDependencies.size()]);
            registrar.register((IntentionAction)new AddGradleProjectDependencyFix(contextModule, classVFile, classes, (PsiReference)reference));
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)psiElement.getProject());
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        HashSet librariesToAdd = Sets.newHashSet();
        for (PsiClass aClass : classes) {
            VirtualFile virtualFile;
            PsiFile psiFile;
            if (!facade.getResolveHelper().isAccessible((PsiMember)aClass, psiElement, aClass) || (psiFile = aClass.getContainingFile()) == null || (virtualFile = psiFile.getVirtualFile()) == null) continue;
            ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance((Module)contextModule).getFileIndex();
            for (OrderEntry orderEntry : fileIndex.getOrderEntriesForFile(virtualFile)) {
                OrderEntry entryForFile;
                VirtualFile jar;
                VirtualFile[] files;
                LibraryOrderEntry libraryEntry;
                Library library;
                if (!(orderEntry instanceof LibraryOrderEntry) || (library = (libraryEntry = (LibraryOrderEntry)orderEntry).getLibrary()) == null || (files = library.getFiles(OrderRootType.CLASSES)).length == 0 || (jar = files[0]) == null || libraryEntry.isModuleLevel() && !librariesToAdd.add(jar) || !librariesToAdd.add(library) || (entryForFile = moduleFileIndex.getOrderEntryForFile(virtualFile)) != null && (!(entryForFile instanceof ExportableOrderEntry) || ((ExportableOrderEntry)entryForFile).getScope() != DependencyScope.TEST || ModuleRootManager.getInstance((Module)contextModule).getFileIndex().isInTestSourceContent(classVFile))) continue;
                registrar.register((IntentionAction)new AddGradleLibraryDependencyFix(libraryEntry, aClass, contextModule, (PsiReference)reference));
            }
        }
    }

    @NotNull
    private static List<PsiClass> filterAllowedDependencies(@NotNull PsiElement element, @NotNull PsiClass[] classes) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/gradle/quickfix/AndroidUnresolvedReferenceQuickFixProvider", "filterAllowedDependencies"));
        }
        if (classes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/android/tools/idea/gradle/quickfix/AndroidUnresolvedReferenceQuickFixProvider", "filterAllowedDependencies"));
        }
        DependencyValidationManager dependencyValidationManager = DependencyValidationManager.getInstance((Project)element.getProject());
        PsiFile fromFile = element.getContainingFile();
        ArrayList result = Lists.newArrayList();
        for (PsiClass psiClass : classes) {
            if (dependencyValidationManager.getViolatorDependencyRule(fromFile, psiClass.getContainingFile()) != null) continue;
            result.add(psiClass);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/quickfix/AndroidUnresolvedReferenceQuickFixProvider", "filterAllowedDependencies"));
        }
        return arrayList;
    }

    private static boolean isAnnotation(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/android/tools/idea/gradle/quickfix/AndroidUnresolvedReferenceQuickFixProvider", "isAnnotation"));
        }
        return PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiAnnotation.class) != null && PsiUtil.isLanguageLevel5OrHigher((PsiElement)psiElement);
    }

    private static boolean isJunitAnnotationName(@NonNls String referenceName, @NotNull PsiElement psiElement) {
        PsiReference reference;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/android/tools/idea/gradle/quickfix/AndroidUnresolvedReferenceQuickFixProvider", "isJunitAnnotationName"));
        }
        if ("Test".equals(referenceName) || "Ignore".equals(referenceName) || "RunWith".equals(referenceName) || "Before".equals(referenceName) || "BeforeClass".equals(referenceName) || "After".equals(referenceName) || "AfterClass".equals(referenceName)) {
            return true;
        }
        PsiElement parent = psiElement.getParent();
        if (parent != null && !(parent instanceof PsiAnnotation) && (reference = parent.getReference()) != null) {
            String referenceText = parent.getText();
            if (AndroidUnresolvedReferenceQuickFixProvider.isJunitAnnotationName(reference.getRangeInElement().substring(referenceText), parent)) {
                int lastDot = referenceText.lastIndexOf(46);
                return lastDot > -1 && referenceText.substring(0, lastDot).equals("org.junit");
            }
        }
        return false;
    }

    @NotNull
    public Class<PsiJavaCodeReferenceElement> getReferenceClass() {
        if (PsiJavaCodeReferenceElement.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/quickfix/AndroidUnresolvedReferenceQuickFixProvider", "getReferenceClass"));
        }
        return PsiJavaCodeReferenceElement.class;
    }
}

