/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.service.image;

import com.android.tools.idea.editors.gfxtrace.service.ServiceClient;
import com.android.tools.idea.editors.gfxtrace.service.gfxapi.Cubemap;
import com.android.tools.idea.editors.gfxtrace.service.gfxapi.Texture2D;
import com.android.tools.idea.editors.gfxtrace.service.image.FmtRGBA;
import com.android.tools.idea.editors.gfxtrace.service.image.Format;
import com.android.tools.idea.editors.gfxtrace.service.image.ImageInfo;
import com.android.tools.idea.editors.gfxtrace.service.path.ImageInfoPath;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.google.common.base.Function;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;

public class FetchedImage {
    @NotNull
    private static final Logger LOG = Logger.getInstance(FetchedImage.class);
    @NotNull
    public final ImageInfo myImageInfo;
    @NotNull
    public final byte[] myData;
    @NotNull
    public final Dimension dimensions;
    @NotNull
    public final ImageIcon icon;

    public static ListenableFuture<FetchedImage> load(final ServiceClient client, ListenableFuture<ImageInfoPath> imageInfo) {
        return Futures.transform(imageInfo, (AsyncFunction)new AsyncFunction<ImageInfoPath, FetchedImage>(){

            public ListenableFuture<FetchedImage> apply(ImageInfoPath imageInfoPath) throws Exception {
                return FetchedImage.load(client, imageInfoPath);
            }
        });
    }

    public static ListenableFuture<FetchedImage> load(final ServiceClient client, Path imagePath) {
        return Futures.transform(client.get(imagePath.as(Format.RGBA)), (AsyncFunction)new AsyncFunction<Object, FetchedImage>(){

            public ListenableFuture<FetchedImage> apply(Object object) throws Exception {
                if (object instanceof ImageInfo) {
                    return FetchedImage.load(client, (ImageInfo)object);
                }
                if (object instanceof Texture2D) {
                    return FetchedImage.load(client, ((Texture2D)object).getLevels()[0]);
                }
                if (object instanceof Cubemap) {
                    return FetchedImage.load(client, ((Cubemap)object).getLevels()[0].getNegativeX());
                }
                throw new UnsupportedOperationException("Unexpected resource type " + object.toString());
            }
        });
    }

    private static ListenableFuture<FetchedImage> load(ServiceClient client, final ImageInfo imageInfo) {
        return Futures.transform(client.get(imageInfo.getData()), (Function)new Function<byte[], FetchedImage>(){

            public FetchedImage apply(byte[] data) {
                return new FetchedImage(imageInfo, data);
            }
        });
    }

    public FetchedImage(@NotNull ImageInfo imageInfo, @NotNull byte[] data) {
        if (imageInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imageInfo", "com/android/tools/idea/editors/gfxtrace/service/image/FetchedImage", "<init>"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/idea/editors/gfxtrace/service/image/FetchedImage", "<init>"));
        }
        this.myImageInfo = imageInfo;
        this.myData = data;
        this.dimensions = new Dimension(this.myImageInfo.getWidth(), this.myImageInfo.getHeight());
        BufferedImage image = new BufferedImage(this.dimensions.width, this.dimensions.height, 6);
        WritableRaster raster = image.getRaster();
        DataBufferByte dataBuffer = (DataBufferByte)raster.getDataBuffer();
        assert (this.myImageInfo.getFormat() instanceof FmtRGBA);
        int stride = this.dimensions.width * 4;
        int length = stride * this.dimensions.height;
        byte[] destination = dataBuffer.getData();
        assert (destination.length >= length);
        for (int y = 0; y < this.dimensions.height; ++y) {
            int yOffsetSource = stride * y;
            int yOffsetDestination = length - stride - yOffsetSource;
            for (int x = 0; x < stride; x += 4) {
                int destinationOffset = yOffsetDestination + x;
                int sourceOffset = yOffsetSource + x;
                destination[destinationOffset + 0] = data[sourceOffset + 3];
                destination[destinationOffset + 1] = data[sourceOffset + 2];
                destination[destinationOffset + 2] = data[sourceOffset + 1];
                destination[destinationOffset + 3] = data[sourceOffset + 0];
            }
        }
        this.icon = new ImageIcon(image);
    }
}

