/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.devices.Abi;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.tools.idea.avdmanager.HaxmWizard;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.welcome.install.Haxm;
import com.android.tools.idea.welcome.install.WizardException;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.View;
import org.jetbrains.android.sdk.AndroidSdkUtils;

public class HaxmAlert
extends JPanel {
    private JBLabel myWarningMessage;
    private HyperlinkLabel myErrorInstructionsLink = new HyperlinkLabel();
    private HyperlinkListener myErrorLinkListener;
    SystemImageDescription myImageDescription;
    private static final IdDisplay GOOGLE_APIS_TAG = new IdDisplay("google_apis", "");
    private static HaxmState ourHaxmState = HaxmState.NOT_INITIALIZED;

    public HaxmAlert() {
        this.myWarningMessage = new JBLabel(){

            public Dimension getPreferredSize() {
                View view = (View)this.getClientProperty("html");
                Container parent = this.getParent();
                if (view != null && parent != null && parent.getWidth() > 0) {
                    view.setSize(parent.getWidth(), 0.0f);
                    return new Dimension((int)view.getPreferredSpan(0), (int)view.getPreferredSpan(1));
                }
                return super.getPreferredSize();
            }
        };
        this.setLayout((LayoutManager)new GridLayoutManager(2, 1));
        GridConstraints constraints = new GridConstraints();
        constraints.setAnchor(8);
        this.add((Component)this.myWarningMessage, constraints);
        constraints.setRow(1);
        this.add((Component)this.myErrorInstructionsLink, constraints);
        this.myErrorInstructionsLink.setOpaque(false);
        this.myWarningMessage.setForeground((Color)JBColor.RED);
        this.myWarningMessage.setHorizontalAlignment(2);
        this.setOpaque(false);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Recommendation"), BorderFactory.createEmptyBorder(0, 5, 3, 5)));
    }

    public void setSystemImageDescription(SystemImageDescription description) {
        this.myImageDescription = description;
        this.refresh();
    }

    private void refresh() {
        String warningText;
        if (this.myImageDescription == null) {
            this.setVisible(false);
            return;
        }
        boolean hasLink = false;
        StringBuilder warningTextBuilder = new StringBuilder();
        if (Haxm.canRun() || SystemInfo.isUnix) {
            if (!this.myImageDescription.getAbiType().startsWith(Abi.X86.toString())) {
                warningTextBuilder.append("Consider using an x86 system image for better emulation performance.<br>");
            } else {
                HaxmState haxmState = HaxmAlert.getHaxmState(false);
                if (haxmState == HaxmState.NOT_INSTALLED) {
                    if (SystemInfo.isLinux) {
                        warningTextBuilder.append("Enable Linux KVM for better emulation performance.<br>");
                        this.myErrorInstructionsLink.setHyperlinkTarget("https://software.intel.com/blogs/2012/03/12/how-to-start-intel-hardware-assisted-virtualization-hypervisor-on-linux-to-speed-up-intel-android-x86-emulator");
                        this.myErrorInstructionsLink.setHtmlText("<a>KVM Instructions</a>");
                        if (this.myErrorLinkListener != null) {
                            this.myErrorInstructionsLink.removeHyperlinkListener(this.myErrorLinkListener);
                        }
                        hasLink = true;
                    } else {
                        warningTextBuilder.append("Install Intel HAXM for better emulation performance.<br>");
                        this.setupDownloadLink();
                        hasLink = true;
                    }
                } else if (haxmState == HaxmState.NOT_LATEST) {
                    warningTextBuilder.append("Newer HAXM Version Available<br>");
                    this.setupDownloadLink();
                    hasLink = true;
                }
            }
        }
        if (this.myImageDescription.getVersion().getApiLevel() < 8) {
            warningTextBuilder.append("This API Level is Deprecated<br>");
        }
        if (!GOOGLE_APIS_TAG.equals((Object)this.myImageDescription.getTag())) {
            warningTextBuilder.append("Consider using a system image with Google APIs to enable testing with Google Play Services.");
        }
        if (!(warningText = warningTextBuilder.toString()).isEmpty()) {
            warningTextBuilder.insert(0, "<html>");
            warningTextBuilder.append("</html>");
            this.myWarningMessage.setText(warningTextBuilder.toString());
            this.setVisible(true);
            this.myErrorInstructionsLink.setVisible(hasLink);
        } else {
            this.setVisible(false);
        }
    }

    private void setupDownloadLink() {
        this.myErrorInstructionsLink.setHyperlinkTarget(null);
        this.myErrorInstructionsLink.setHtmlText("<a>Download and install HAXM<a>");
        if (this.myErrorLinkListener != null) {
            this.myErrorInstructionsLink.removeHyperlinkListener(this.myErrorLinkListener);
        }
        this.myErrorLinkListener = new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                HaxmWizard wizard = new HaxmWizard();
                wizard.init();
                wizard.show();
                HaxmAlert.getHaxmState(true);
                HaxmAlert.this.refresh();
            }
        };
        this.myErrorInstructionsLink.addHyperlinkListener(this.myErrorLinkListener);
    }

    public static HaxmState getHaxmState(boolean forceRefresh) {
        if (ourHaxmState == HaxmState.NOT_INITIALIZED || forceRefresh) {
            ourHaxmState = HaxmAlert.computeHaxmState();
        }
        return ourHaxmState;
    }

    private static HaxmState computeHaxmState() {
        boolean found;
        block11: {
            found = false;
            try {
                if (SystemInfo.isMac) {
                    Pattern pattern;
                    Matcher matcher;
                    String output = ExecUtil.execAndReadLine((String[])new String[]{"/usr/sbin/kextstat", "-l", "-b", "com.intel.kext.intelhaxm"});
                    if (output != null && !output.isEmpty() && (matcher = (pattern = Pattern.compile("com\\.intel\\.kext\\.intelhaxm( \\((.+)\\))?")).matcher(output)).find()) {
                        found = true;
                    }
                    break block11;
                }
                if (SystemInfo.isWindows) {
                    ProcessOutput processOutput = ExecUtil.execAndGetOutput((List)ImmutableList.of((Object)"sc", (Object)"query", (Object)"intelhaxm"), null);
                    found = Iterables.all((Iterable)processOutput.getStdoutLines(), (Predicate)new Predicate<String>(){

                        public boolean apply(String input) {
                            return input == null || !input.contains("does not exist");
                        }
                    });
                    break block11;
                }
                if (SystemInfo.isUnix) {
                    File kvm = new File("/dev/kvm");
                    return kvm.exists() ? HaxmState.INSTALLED : HaxmState.NOT_INSTALLED;
                }
                assert (!SystemInfo.isLinux);
                return HaxmState.NOT_INSTALLED;
            }
            catch (ExecutionException e) {
                return HaxmState.NOT_INSTALLED;
            }
        }
        if (found) {
            try {
                FullRevision revision = Haxm.getInstalledVersion(AndroidSdkUtils.tryToChooseAndroidSdk().getLocation());
                FullRevision current = new FullRevision(1, 1, 5);
                if (revision.compareTo(current) < 0) {
                    return HaxmState.NOT_LATEST;
                }
            }
            catch (WizardException e) {
                return HaxmState.NOT_INSTALLED;
            }
            return HaxmState.INSTALLED;
        }
        return HaxmState.NOT_INSTALLED;
    }

    public static enum HaxmState {
        NOT_INITIALIZED,
        INSTALLED,
        NOT_INSTALLED,
        NOT_LATEST;

    }
}

