/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.RenderContext;
import com.android.tools.idea.rendering.PsiResourceItem;
import com.android.tools.idea.rendering.ResourceHelper;
import com.android.utils.Pair;
import com.google.common.collect.Lists;
import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.actions.ElementCreator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.android.actions.CreateResourceDirectoryDialog;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OverrideResourceAction
extends AbstractIntentionAction {
    @Nullable
    public static String ourTargetFolderName;

    private static String getActionName(@Nullable String folder) {
        return "Override Resource in " + (folder != null ? folder : "Other Configuration...");
    }

    @NotNull
    public String getText() {
        String string = OverrideResourceAction.getActionName(null);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/actions/OverrideResourceAction", "getText"));
        }
        return string;
    }

    public boolean startInWriteAction() {
        return true;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/actions/OverrideResourceAction", "isAvailable"));
        }
        if (file instanceof XmlFile && file.isValid() && AndroidFacet.getInstance((PsiElement)file) != null) {
            ResourceFolderType folderType = ResourceHelper.getFolderType(file);
            if (folderType == null) {
                return false;
            }
            if (folderType != ResourceFolderType.VALUES) {
                return true;
            }
            return this.isAvailable(OverrideResourceAction.getValueTag(editor, file), file);
        }
        return false;
    }

    public boolean isAvailable(@Nullable XmlTag tag, PsiFile file) {
        if (file instanceof XmlFile && file.isValid() && AndroidFacet.getInstance((PsiElement)file) != null) {
            ResourceFolderType folderType = ResourceHelper.getFolderType(file);
            if (folderType == null) {
                return false;
            }
            if (folderType != ResourceFolderType.VALUES) {
                return true;
            }
            if (tag != null && tag.getAttributeValue("name") != null) {
                return AndroidResourceUtil.getResourceForResourceTag(tag) != null;
            }
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/actions/OverrideResourceAction", "invoke"));
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        ResourceFolderType folderType = ResourceHelper.getFolderType(file);
        if (facet == null || folderType == null) {
            return;
        }
        if (folderType != ResourceFolderType.VALUES) {
            OverrideResourceAction.forkResourceFile((XmlFile)file, null, true);
        } else if (editor != null) {
            OverrideResourceAction.forkResourceValue(project, editor, file, facet, null, true);
        }
    }

    private static void forkResourceValue(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull AndroidFacet facet, @Nullable PsiDirectory dir, boolean open) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/actions/OverrideResourceAction", "forkResourceValue"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/actions/OverrideResourceAction", "forkResourceValue"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/actions/OverrideResourceAction", "forkResourceValue"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/actions/OverrideResourceAction", "forkResourceValue"));
        }
        XmlTag tag = OverrideResourceAction.getValueTag(editor, file);
        if (tag == null) {
            return;
        }
        OverrideResourceAction.forkResourceValue(project, tag, file, facet, dir, open);
    }

    @Nullable
    private static PsiDirectory findRes(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/actions/OverrideResourceAction", "findRes"));
        }
        PsiDirectory resourceFolder = file.getParent();
        return resourceFolder == null ? null : resourceFolder.getParent();
    }

    public static void forkResourceValue(@NotNull Project project, @NotNull XmlTag tag, @NotNull PsiFile file, @NotNull AndroidFacet facet, @Nullable PsiDirectory dir, boolean open) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/actions/OverrideResourceAction", "forkResourceValue"));
        }
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/android/tools/idea/actions/OverrideResourceAction", "forkResourceValue"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/actions/OverrideResourceAction", "forkResourceValue"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/actions/OverrideResourceAction", "forkResourceValue"));
        }
        PsiDirectory resFolder = OverrideResourceAction.findRes(file);
        if (resFolder == null) {
            return;
        }
        String name = tag.getAttributeValue("name");
        ResourceType type = AndroidResourceUtil.getResourceForResourceTag(tag);
        if (name == null || type == null) {
            return;
        }
        if (dir == null) {
            dir = OverrideResourceAction.selectFolderDir(project, resFolder.getVirtualFile(), ResourceFolderType.VALUES);
        }
        if (dir != null) {
            String value = PsiResourceItem.getTextContent(tag).trim();
            OverrideResourceAction.createValueResource(file, facet, dir, name, value, type, tag.getText(), open);
        }
    }

    @Nullable
    private static XmlTag getEditorTag(Editor editor, PsiFile file) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement psiElement = file.findElementAt(offset);
        if (psiElement != null) {
            return (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlTag.class, (boolean)false);
        }
        return null;
    }

    @Nullable
    private static XmlTag getValueTag(Editor editor, PsiFile file) {
        return OverrideResourceAction.getValueTag(OverrideResourceAction.getEditorTag(editor, file));
    }

    @Nullable
    public static XmlTag getValueTag(@Nullable XmlTag tag) {
        XmlTag current = null;
        if (tag != null) {
            XmlTag parentParent;
            current = tag;
            XmlTag parent = current.getParentTag();
            while (parent != null && (parentParent = parent.getParentTag()) != null) {
                current = parent;
                parent = parentParent;
            }
        }
        return current;
    }

    private static void createValueResource(@NotNull PsiFile file, @NotNull AndroidFacet facet, @NotNull PsiDirectory dir, final @NotNull String resName, final @NotNull String value, final @NotNull ResourceType type, final @NotNull String oldTagText, boolean open) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/actions/OverrideResourceAction", "createValueResource"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/actions/OverrideResourceAction", "createValueResource"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/android/tools/idea/actions/OverrideResourceAction", "createValueResource"));
        }
        if (resName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resName", "com/android/tools/idea/actions/OverrideResourceAction", "createValueResource"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/actions/OverrideResourceAction", "createValueResource"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/actions/OverrideResourceAction", "createValueResource"));
        }
        if (oldTagText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldTagText", "com/android/tools/idea/actions/OverrideResourceAction", "createValueResource"));
        }
        final String filename = file.getName();
        final List<String> dirNames = Collections.singletonList(dir.getName());
        final Module module = facet.getModule();
        final AtomicReference openAfter = new AtomicReference();
        WriteCommandAction<Void> action = new WriteCommandAction<Void>(facet.getModule().getProject(), "Override Resource " + resName, new PsiFile[]{file}){

            protected void run(@NotNull Result<Void> result) {
                XmlTag tag;
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/actions/OverrideResourceAction$1", "run"));
                }
                ArrayList elements = Lists.newArrayListWithExpectedSize((int)1);
                AndroidResourceUtil.createValueResource(module, resName, type, filename, dirNames, value, elements);
                if (elements.size() == 1 && (tag = ((ResourceElement)elements.get(0)).getXmlTag()) != null && tag.isValid()) {
                    try {
                        XmlTag tagFromText = XmlElementFactory.getInstance((Project)tag.getProject()).createTagFromText((CharSequence)oldTagText);
                        PsiElement replaced = tag.replace((PsiElement)tagFromText);
                        openAfter.set(replaced);
                    }
                    catch (IncorrectOperationException e) {
                        openAfter.set(tag);
                    }
                }
            }
        };
        action.execute();
        PsiElement tag = (PsiElement)openAfter.get();
        if (open && tag != null) {
            NavigationUtil.openFileWithPsiElement((PsiElement)tag, (boolean)true, (boolean)true);
        }
    }

    public static void forkResourceFile(@NotNull RenderContext context, @Nullable String newFolder, boolean open) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/actions/OverrideResourceAction", "forkResourceFile"));
        }
        VirtualFile file = context.getVirtualFile();
        if (file == null) {
            assert (false);
            return;
        }
        Module module = context.getModule();
        if (module == null) {
            assert (false);
            return;
        }
        XmlFile xmlFile = context.getXmlFile();
        Configuration configuration = context.getConfiguration();
        OverrideResourceAction.forkResourceFile(module, ResourceFolderType.LAYOUT, file, xmlFile, newFolder, configuration, open);
    }

    public static void forkResourceFile(@NotNull XmlFile xmlFile, @Nullable String myNewFolder, boolean open) {
        AndroidFacet facet;
        if (xmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "com/android/tools/idea/actions/OverrideResourceAction", "forkResourceFile"));
        }
        VirtualFile file = xmlFile.getVirtualFile();
        if (file == null) {
            return;
        }
        Module module = AndroidPsiUtils.getModuleSafely((PsiElement)xmlFile);
        if (module == null) {
            return;
        }
        ResourceFolderType folderType = ResourceHelper.getFolderType((PsiFile)xmlFile);
        if (folderType == null || folderType == ResourceFolderType.VALUES) {
            return;
        }
        Configuration configuration = null;
        if (folderType == ResourceFolderType.LAYOUT && (facet = AndroidFacet.getInstance(module)) != null) {
            configuration = facet.getConfigurationManager().getConfiguration(file);
        }
        OverrideResourceAction.forkResourceFile(module, folderType, file, xmlFile, myNewFolder, configuration, open);
    }

    private static void forkResourceFile(@NotNull Module module, final @NotNull ResourceFolderType folderType, final @NotNull VirtualFile file, final @Nullable XmlFile xmlFile, @Nullable String myNewFolder, @Nullable Configuration configuration, boolean open) {
        FolderConfiguration folderConfig;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/actions/OverrideResourceAction", "forkResourceFile"));
        }
        if (folderType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folderType", "com/android/tools/idea/actions/OverrideResourceAction", "forkResourceFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/actions/OverrideResourceAction", "forkResourceFile"));
        }
        Project project = module.getProject();
        if (myNewFolder == null) {
            VirtualFile parentFolder = file.getParent();
            assert (parentFolder != null);
            VirtualFile res = parentFolder.getParent();
            folderConfig = OverrideResourceAction.selectFolderConfig(project, res, folderType);
        } else {
            folderConfig = FolderConfiguration.getConfigForFolder((String)myNewFolder);
        }
        if (folderConfig == null) {
            return;
        }
        Computable<Pair<String, VirtualFile>> computable = new Computable<Pair<String, VirtualFile>>(){

            public Pair<String, VirtualFile> compute() {
                String folderName = folderConfig.getFolderName(folderType);
                try {
                    VirtualFile parentFolder = file.getParent();
                    assert (parentFolder != null);
                    VirtualFile res = parentFolder.getParent();
                    VirtualFile newParentFolder = res.findChild(folderName);
                    if (newParentFolder == null && (newParentFolder = res.createChildDirectory((Object)this, folderName)) == null) {
                        String message = String.format("Could not create folder %1$s in %2$s", folderName, res.getPath());
                        return Pair.of((Object)message, null);
                    }
                    VirtualFile existing = newParentFolder.findChild(file.getName());
                    if (existing != null && existing.exists()) {
                        String message = String.format("File 'res/%1$s/%2$s' already exists!", folderName, file.getName());
                        return Pair.of((Object)message, null);
                    }
                    String text = xmlFile != null ? xmlFile.getText() : StreamUtil.readText((InputStream)file.getInputStream(), (String)"UTF-8");
                    VirtualFile newFile = newParentFolder.createChildData((Object)this, file.getName());
                    VfsUtil.saveText((VirtualFile)newFile, (String)text);
                    return Pair.of(null, (Object)newFile);
                }
                catch (IOException e2) {
                    String message = String.format("Failed to create File 'res/%1$s/%2$s' : %3$s", folderName, file.getName(), e2.getMessage());
                    return Pair.of((Object)message, null);
                }
            }
        };
        WriteCommandAction<Pair<String, VirtualFile>> action = new WriteCommandAction<Pair<String, VirtualFile>>(project, "Add Resource", new PsiFile[0], (Computable)computable){
            final /* synthetic */ Computable val$computable;
            {
                this.val$computable = computable;
                super(arg0, arg1, arg2);
            }

            protected void run(@NotNull Result<Pair<String, VirtualFile>> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/actions/OverrideResourceAction$3", "run"));
                }
                result.setResult(this.val$computable.compute());
            }
        };
        Pair result = (Pair)action.execute().getResultObject();
        String error = (String)result.getFirst();
        VirtualFile newFile = (VirtualFile)result.getSecond();
        if (error != null) {
            Messages.showErrorDialog((Project)project, (String)error, (String)"Create Resource");
        } else {
            if (configuration != null) {
                ConfigurationManager configurationManager = configuration.getConfigurationManager();
                configurationManager.createSimilar(newFile, file);
            }
            if (open) {
                OpenFileDescriptor descriptor = new OpenFileDescriptor(project, newFile, -1);
                FileEditorManager.getInstance((Project)project).openEditor(descriptor, true);
            }
        }
    }

    @Nullable
    public static PsiDirectory selectFolderDir(final Project project, VirtualFile res, ResourceFolderType folderType) {
        PsiElement[] createdElements;
        final PsiDirectory directory = PsiManager.getInstance((Project)project).findDirectory(res);
        if (directory == null) {
            return null;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && ourTargetFolderName != null) {
            PsiDirectory subDirectory = directory.findSubdirectory(ourTargetFolderName);
            if (subDirectory != null) {
                return subDirectory;
            }
            return directory.createSubdirectory(ourTargetFolderName);
        }
        CreateResourceDirectoryDialog dialog = new CreateResourceDirectoryDialog(project, folderType, directory, null){

            @Override
            protected InputValidator createValidator() {
                return new ResourceDirectorySelector(project, directory);
            }
        };
        dialog.setTitle("Select Resource Directory");
        dialog.show();
        InputValidator validator = dialog.getValidator();
        if (validator != null && (createdElements = ((ResourceDirectorySelector)validator).getCreatedElements()) != null && createdElements.length > 0) {
            return (PsiDirectory)createdElements[0];
        }
        return null;
    }

    @Nullable
    public static FolderConfiguration selectFolderConfig(Project project, VirtualFile res, ResourceFolderType folderType) {
        PsiDirectory dir = OverrideResourceAction.selectFolderDir(project, res, folderType);
        if (dir != null) {
            return FolderConfiguration.getConfigForFolder((String)dir.getName());
        }
        return null;
    }

    public static AndroidLintQuickFix createFix(@Nullable String folder) {
        return new OverrideElementFix(folder);
    }

    private static class OverrideElementFix
    implements AndroidLintQuickFix {
        private final String myFolder;

        private OverrideElementFix(@Nullable String folder) {
            this.myFolder = folder;
        }

        @Override
        public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
            ResourceFolderType folderType;
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/actions/OverrideResourceAction$OverrideElementFix", "apply"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/android/tools/idea/actions/OverrideResourceAction$OverrideElementFix", "apply"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/actions/OverrideResourceAction$OverrideElementFix", "apply"));
            }
            PsiFile file = startElement.getContainingFile();
            if (file instanceof XmlFile && (folderType = ResourceHelper.getFolderType(file)) != null) {
                if (folderType != ResourceFolderType.VALUES) {
                    OverrideResourceAction.forkResourceFile((XmlFile)file, this.myFolder, true);
                } else {
                    AndroidFacet facet;
                    XmlTag tag = OverrideResourceAction.getValueTag((XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false));
                    if (tag != null && (facet = AndroidFacet.getInstance(startElement)) != null) {
                        PsiDirectory resFolder;
                        PsiDirectory dir = null;
                        if (this.myFolder != null && (resFolder = OverrideResourceAction.findRes(file)) != null && (dir = resFolder.findSubdirectory(this.myFolder)) == null) {
                            dir = resFolder.createSubdirectory(this.myFolder);
                        }
                        OverrideResourceAction.forkResourceValue(startElement.getProject(), tag, file, facet, dir, true);
                    }
                }
            }
        }

        @Override
        public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/actions/OverrideResourceAction$OverrideElementFix", "isApplicable"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/android/tools/idea/actions/OverrideResourceAction$OverrideElementFix", "isApplicable"));
            }
            if (contextType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextType", "com/android/tools/idea/actions/OverrideResourceAction$OverrideElementFix", "isApplicable"));
            }
            return true;
        }

        @Override
        @NotNull
        public String getName() {
            String string = OverrideResourceAction.getActionName(this.myFolder);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/actions/OverrideResourceAction$OverrideElementFix", "getName"));
            }
            return string;
        }
    }

    private static class ResourceDirectorySelector
    extends ElementCreator
    implements InputValidator {
        private final PsiDirectory myDirectory;
        private PsiElement[] myCreatedElements = PsiElement.EMPTY_ARRAY;

        public ResourceDirectorySelector(Project project, PsiDirectory directory) {
            super(project, "Select Resource Directory");
            this.myDirectory = directory;
        }

        public boolean checkInput(String inputString) {
            return ResourceFolderType.getFolderType((String)inputString) != null && FolderConfiguration.getConfigForFolder((String)inputString) != null;
        }

        public PsiElement[] create(String newName) throws Exception {
            PsiDirectory subdirectory = this.myDirectory.findSubdirectory(newName);
            if (subdirectory == null) {
                subdirectory = this.myDirectory.createSubdirectory(newName);
            }
            return new PsiElement[]{subdirectory};
        }

        public String getActionName(String newName) {
            return "Select Resource Directory";
        }

        public boolean canClose(String inputString) {
            PsiDirectory subdirectory = this.myDirectory.findSubdirectory(inputString);
            if (subdirectory != null) {
                this.myCreatedElements = new PsiDirectory[]{subdirectory};
                return true;
            }
            this.myCreatedElements = this.tryCreate(inputString);
            return this.myCreatedElements.length > 0;
        }

        public final PsiElement[] getCreatedElements() {
            return this.myCreatedElements;
        }
    }
}

