/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.synthetic;

import com.intellij.lang.Language;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.light.LightClassReference;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.AnnotationArgConverter;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightClassReferenceElement;

public class GrLightAnnotation
extends LightElement
implements GrAnnotation {
    private final GrLightAnnotationArgumentList myAnnotationArgList;
    private final String myQualifiedName;
    private final PsiAnnotationOwner myOwner;
    private final GrLightClassReferenceElement myRef;

    public GrLightAnnotation(@NotNull PsiManager manager, @NotNull Language language, @NotNull String qualifiedName, @NotNull PsiAnnotationOwner owner) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightAnnotation", "<init>"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightAnnotation", "<init>"));
        }
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightAnnotation", "<init>"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightAnnotation", "<init>"));
        }
        super(manager, language);
        this.myQualifiedName = qualifiedName;
        this.myOwner = owner;
        this.myAnnotationArgList = new GrLightAnnotationArgumentList(manager, language);
        this.myRef = new GrLightClassReferenceElement(qualifiedName, qualifiedName, this);
    }

    @Override
    @NotNull
    public GrCodeReferenceElement getClassReference() {
        GrLightClassReferenceElement grLightClassReferenceElement = this.myRef;
        if (grLightClassReferenceElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightAnnotation", "getClassReference"));
        }
        return grLightClassReferenceElement;
    }

    @Override
    @NotNull
    public String getShortName() {
        String string = StringUtil.getShortName((String)this.myQualifiedName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightAnnotation", "getShortName"));
        }
        return string;
    }

    @Override
    @NotNull
    public GrAnnotationArgumentList getParameterList() {
        GrLightAnnotationArgumentList grLightAnnotationArgumentList = this.myAnnotationArgList;
        if (grLightAnnotationArgumentList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightAnnotation", "getParameterList"));
        }
        return grLightAnnotationArgumentList;
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitAnnotation(this);
    }

    @Override
    public void acceptChildren(GroovyElementVisitor visitor) {
    }

    public String toString() {
        return "light groovy annotation";
    }

    public String getText() {
        return "@" + this.myQualifiedName + this.myAnnotationArgList.getText();
    }

    public String getQualifiedName() {
        return this.myQualifiedName;
    }

    public PsiJavaCodeReferenceElement getNameReferenceElement() {
        GroovyResolveResult resolveResult = this.myRef.advancedResolve();
        PsiElement resolved = resolveResult.getElement();
        if (resolved instanceof PsiClass) {
            return new LightClassReference(this.getManager(), this.getClassReference().getText(), (PsiClass)resolved, resolveResult.getSubstitutor());
        }
        return null;
    }

    public PsiAnnotationMemberValue findAttributeValue(@NonNls String attributeName) {
        return PsiImplUtil.findAttributeValue((PsiAnnotation)this, (String)attributeName);
    }

    public PsiAnnotationMemberValue findDeclaredAttributeValue(@NonNls String attributeName) {
        return PsiImplUtil.findDeclaredAttributeValue((PsiAnnotation)this, (String)attributeName);
    }

    public <T extends PsiAnnotationMemberValue> T setDeclaredAttributeValue(@NonNls String attributeName, @Nullable T value) {
        throw new UnsupportedOperationException("light annotation does not support changes");
    }

    public PsiAnnotationOwner getOwner() {
        return this.myOwner;
    }

    public PsiMetaData getMetaData() {
        return null;
    }

    public void addAttribute(PsiNameValuePair pair) {
        if (pair instanceof GrAnnotationNameValuePair) {
            this.myAnnotationArgList.addAttribute((GrAnnotationNameValuePair)pair);
        } else {
            GrAnnotationMemberValue newValue = new AnnotationArgConverter().convert(pair.getValue());
            if (newValue == null) {
                return;
            }
            String name = pair.getName();
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(pair.getProject());
            String annotationText = name != null ? "@A(" + name + "=" + newValue.getText() + ")" : "@A(" + newValue.getText() + ")";
            GrAnnotation annotation = factory.createAnnotationFromText(annotationText);
            this.myAnnotationArgList.addAttribute(annotation.getParameterList().getAttributes()[0]);
        }
    }

    private class GrLightAnnotationArgumentList
    extends LightElement
    implements GrAnnotationArgumentList {
        private List<GrAnnotationNameValuePair> myAttributes;
        private GrAnnotationNameValuePair[] myCachedAttributes;

        public PsiElement getContext() {
            return GrLightAnnotation.this;
        }

        private GrLightAnnotationArgumentList(@NotNull PsiManager manager, Language language) {
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightAnnotation$GrLightAnnotationArgumentList", "<init>"));
            }
            if (language == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightAnnotation$GrLightAnnotationArgumentList", "<init>"));
            }
            super(manager, language);
            this.myAttributes = null;
            this.myCachedAttributes = GrAnnotationNameValuePair.EMPTY_ARRAY;
        }

        @Override
        @NotNull
        public GrAnnotationNameValuePair[] getAttributes() {
            if (this.myCachedAttributes == null) {
                assert (this.myAttributes != null);
                this.myCachedAttributes = this.myAttributes.toArray(new GrAnnotationNameValuePair[this.myAttributes.size()]);
            }
            if (this.myCachedAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightAnnotation$GrLightAnnotationArgumentList", "getAttributes"));
            }
            return this.myCachedAttributes;
        }

        public void addAttribute(@NotNull GrAnnotationNameValuePair attribute) {
            if (attribute == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightAnnotation$GrLightAnnotationArgumentList", "addAttribute"));
            }
            if (this.myAttributes == null) {
                this.myAttributes = ContainerUtilRt.newArrayList();
            }
            this.myAttributes.add(attribute);
            this.myCachedAttributes = null;
        }

        @Override
        public void accept(GroovyElementVisitor visitor) {
            visitor.visitAnnotationArgumentList(this);
        }

        @Override
        public void acceptChildren(GroovyElementVisitor visitor) {
            if (this.myAttributes != null) {
                for (GrAnnotationNameValuePair attribute : this.myAttributes) {
                    attribute.accept(visitor);
                }
            }
        }

        public String toString() {
            return "light annotation argument list";
        }

        public String getText() {
            if (this.myAttributes == null || this.myAttributes.isEmpty()) {
                return "";
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append('(');
            for (GrAnnotationNameValuePair attribute : this.myAttributes) {
                buffer.append(attribute.getText());
                buffer.append(',');
            }
            if (!this.myAttributes.isEmpty()) {
                buffer.deleteCharAt(buffer.length() - 1);
            }
            buffer.append(')');
            return buffer.toString();
        }
    }
}

