/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor.selection;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public class GroovyLiteralSelectioner
extends ExtendWordSelectionHandlerBase {
    public boolean canSelect(PsiElement e) {
        PsiElement parent = e.getParent();
        return GroovyLiteralSelectioner.isLiteral(e) || GroovyLiteralSelectioner.isLiteral(parent);
    }

    private static boolean isLiteral(PsiElement element) {
        return element instanceof GrListOrMap || element instanceof GrArgumentLabel || element instanceof GrLiteralImpl && ((GrLiteralImpl)element).isStringLiteral();
    }

    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        List result = super.select(e, editorText, cursorOffset, editor);
        if (e instanceof GrListOrMap) {
            return result;
        }
        int startOffset = -1;
        int endOffset = -1;
        String text = e.getText();
        int stringOffset = e.getTextOffset();
        IElementType elementType = e.getNode().getElementType();
        if (elementType == GroovyTokenTypes.mGSTRING_CONTENT || elementType == GroovyTokenTypes.mREGEX_CONTENT || elementType == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_CONTENT) {
            int cur;
            int index = -1;
            while ((cur = text.indexOf(10, index + 1)) >= 0 && cur + stringOffset <= cursorOffset) {
                index = cur;
            }
            if (index >= 0) {
                startOffset = stringOffset + index + 1;
            }
            if ((index = text.indexOf(10, cursorOffset - stringOffset)) >= 0) {
                endOffset = stringOffset + index + 1;
            }
        }
        if (startOffset >= 0 && endOffset >= 0) {
            result.add(new TextRange(startOffset, endOffset));
        }
        String content = GrStringUtil.removeQuotes(text);
        int offset = stringOffset + text.indexOf(content);
        result.add(new TextRange(offset, offset + content.length()));
        return result;
    }
}

