/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.embedder;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MavenExecutionResult {
    private final MavenProject myMavenProject;
    private final List<Exception> myExceptions;
    private final DependencyResolutionResult myDependencyResolutionResult;

    public MavenExecutionResult(@Nullable MavenProject mavenProject, List<Exception> exceptions) {
        this(mavenProject, null, exceptions);
    }

    public MavenExecutionResult(@Nullable MavenProject mavenProject, @Nullable DependencyResolutionResult dependencyResolutionResult, List<Exception> exceptions) {
        this.myMavenProject = mavenProject;
        this.myExceptions = exceptions == null ? new ArrayList() : exceptions;
        this.myDependencyResolutionResult = dependencyResolutionResult;
        if (this.myDependencyResolutionResult != null && this.myDependencyResolutionResult.getCollectionErrors() != null) {
            this.myExceptions.addAll(this.myDependencyResolutionResult.getCollectionErrors());
        }
    }

    @Nullable
    public MavenProject getMavenProject() {
        return this.myMavenProject;
    }

    @Nullable
    public DependencyResolutionResult getDependencyResolutionResult() {
        return this.myDependencyResolutionResult;
    }

    @NotNull
    public List<Exception> getExceptions() {
        List<Exception> list = this.myExceptions;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/embedder/MavenExecutionResult", "getExceptions"));
        }
        return list;
    }

    public boolean hasExceptions() {
        return !this.myExceptions.isEmpty();
    }
}

