/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.diagnostics.AbstractDiagnostic;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactoryWithPsiElement;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.highlighter.KotlinPsiChecker;
import org.jetbrains.kotlin.idea.quickfix.CleanupFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.ReplaceObsoleteLabelSyntaxFix;
import org.jetbrains.kotlin.idea.quickfix.replaceWith.DeprecatedSymbolUsageFix;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\"#B\u0005\u00a2\u0006\u0002\u0010\u0003J/\u0010\n\u001a\f\u0012\u0006\b\u0001\u0012\u00020\f\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J6\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\r\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u001c\u001a\u00020\u0017H\u0016J\f\u0010\u001d\u001a\u00020\u0012*\u00020\u001eH\u0002J\f\u0010\u001f\u001a\u00020\u0012*\u00020\u001eH\u0002J\u0012\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019*\u00020\u001eH\u0002J*\u0010!\u001a\u00020\f*\u00020\u001e2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\r\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u009f\u0001\u0010\u0004\u001a\u0092\u0001\u0012\u008d\u0001\u0012\u008a\u0001\u0012\u000e\b\u0001\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012.\b\u0001\u0012*\u0012\u000e\b\u0001\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0014\u0012\u000e\b\u0001\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\t0\t \b*D\u0012\u000e\b\u0001\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012.\b\u0001\u0012*\u0012\u000e\b\u0001\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0014\u0012\u000e\b\u0001\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\t0\t\u0018\u00010\u00060\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/KotlinCleanupInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "()V", "cleanupDiagnosticsFactories", "", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactoryWithPsiElement;", "Lcom/intellij/psi/PsiElement;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/diagnostics/AbstractDiagnostic;", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "createProblemDescriptor", "element", "message", "", "fixes", "", "Lorg/jetbrains/kotlin/idea/quickfix/CleanupFix;", "Lorg/jetbrains/kotlin/psi/KtFile;", "getDisplayName", "isCleanup", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "isObsoleteLabel", "toCleanupFixes", "toProblemDescriptor", "RemoveImportFix", "Wrapper", "idea"})
public final class KotlinCleanupInspection
extends LocalInspectionTool
implements CleanupLocalInspectionTool {
    private final Set<DiagnosticFactoryWithPsiElement<? extends PsiElement, ? extends AbstractDiagnostic<? extends PsiElement>>> cleanupDiagnosticsFactories = SetsKt.setOf((Object[])new DiagnosticFactoryWithPsiElement[]{Errors.MISSING_CONSTRUCTOR_KEYWORD, Errors.UNNECESSARY_NOT_NULL_ASSERTION, Errors.UNNECESSARY_SAFE_CALL, Errors.USELESS_CAST, Errors.USELESS_ELVIS, ErrorsJvm.POSITIONED_VALUE_ARGUMENT_FOR_JAVA_ANNOTATION, Errors.DEPRECATION, Errors.DEPRECATION_ERROR, Errors.NON_CONST_VAL_USED_IN_CONSTANT_EXPRESSION, Errors.OPERATOR_MODIFIER_REQUIRED, Errors.DEPRECATED_UNARY_PLUS_MINUS, Errors.DELEGATE_RESOLVED_TO_DEPRECATED_CONVENTION, Errors.INFIX_MODIFIER_REQUIRED, Errors.CALLABLE_REFERENCE_TO_MEMBER_OR_EXTENSION_WITH_EMPTY_LHS, Errors.DEPRECATED_TYPE_PARAMETER_SYNTAX, Errors.MISPLACED_TYPE_PARAMETER_CONSTRAINTS, Errors.COMMA_IN_WHEN_CONDITION_WITHOUT_ARGUMENT, Errors.UNSUPPORTED});

    @NotNull
    public String getDisplayName() {
        return "Usage of redundant or deprecated syntax or deprecated symbols";
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        void action$iv;
        void $receiver$iv$iv;
        RemoveImportFix removeImportFix;
        Object object;
        void destination$iv$iv;
        Function1 $receiver$iv$iv2;
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        if (isOnTheFly || !(file instanceof KtFile) || !ProjectRootsUtil.isInProjectSource((PsiElement)file)) {
            return null;
        }
        AnalysisResult analysisResult = ResolutionUtils.analyzeFullyAndGetResult((KtElement)file, new KtFile[0]);
        if (analysisResult.isError()) {
            throw (Throwable)new ProcessCanceledException(analysisResult.getError());
        }
        Diagnostics diagnostics = analysisResult.getBindingContext().getDiagnostics();
        ArrayList problemDescriptors = CollectionsKt.arrayListOf((Object[])new ProblemDescriptor[0]);
        Iterable iterable = ((KtFile)file).getImportDirectives();
        void var9_8 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            KtImportDirective it;
            KtImportDirective ktImportDirective = it = (KtImportDirective)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktImportDirective, (String)"it");
            if (!DeprecatedSymbolUsageFix.Companion.isImportToBeRemoved(ktImportDirective)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List importsToRemove = (List)destination$iv$iv;
        $receiver$iv$iv2 = importsToRemove.iterator();
        while ($receiver$iv$iv2.hasNext()) {
            Object object2 = object = (KtImportDirective)$receiver$iv$iv2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"import");
            removeImportFix = new RemoveImportFix((KtImportDirective)object2);
            Object object3 = object;
            Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"import");
            ProblemDescriptor problemDescriptor = this.createProblemDescriptor((PsiElement)object3, removeImportFix.getText(), CollectionsKt.listOf((Object)removeImportFix), (KtFile)file, manager);
            problemDescriptors.add(problemDescriptor);
        }
        object = (PsiElement)file;
        $receiver$iv$iv2 = (Function1)new Function1<PsiElement, Unit>(this, diagnostics, problemDescriptors, file, manager){
            final /* synthetic */ KotlinCleanupInspection this$0;
            final /* synthetic */ Diagnostics $diagnostics;
            final /* synthetic */ ArrayList $problemDescriptors;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ InspectionManager $manager;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull PsiElement element2) {
                Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
                for (Diagnostic diagnostic : this.$diagnostics.forElement(element2)) {
                    void $receiver$iv;
                    Collection fixes2;
                    if (!KotlinCleanupInspection.access$isCleanup(this.this$0, diagnostic)) continue;
                    Collection collection = fixes2 = KotlinCleanupInspection.access$toCleanupFixes(this.this$0, diagnostic);
                    if (!(!$receiver$iv.isEmpty())) continue;
                    this.$problemDescriptors.add(KotlinCleanupInspection.access$toProblemDescriptor(this.this$0, diagnostic, fixes2, (KtFile)this.$file, this.$manager));
                }
            }
            {
                this.this$0 = kotlinCleanupInspection;
                this.$diagnostics = diagnostics;
                this.$problemDescriptors = arrayList;
                this.$file = psiFile;
                this.$manager = inspectionManager;
                super(1);
            }
        };
        removeImportFix = $receiver$iv;
        $receiver$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor((Function1)action$iv){
            final /* synthetic */ Function1 $action;

            public void visitElement(PsiElement element2) {
                PsiElement it = element2;
                if (true) {
                    super.visitElement(element2);
                }
                if (element2 instanceof PsiElement) {
                    this.$action.invoke((Object)element2);
                }
            }
            {
                this.$action = function1;
            }
        });
        $receiver$iv = problemDescriptors;
        Collection collection2 = $receiver$iv;
        if (collection2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection2;
        ProblemDescriptor[] problemDescriptorArray = thisCollection$iv.toArray(new ProblemDescriptor[thisCollection$iv.size()]);
        if (problemDescriptorArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return (ProblemDescriptor[])((Object[])problemDescriptorArray);
    }

    private final boolean isCleanup(Diagnostic $receiver) {
        return CollectionsKt.contains((Iterable)this.cleanupDiagnosticsFactories, $receiver.getFactory()) || this.isObsoleteLabel($receiver);
    }

    private final boolean isObsoleteLabel(Diagnostic $receiver) {
        PsiElement $receiver$iv = $receiver.getPsiElement();
        KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtAnnotationEntry.class, (boolean)false);
        if (ktAnnotationEntry == null) {
            return false;
        }
        KtAnnotationEntry annotationEntry = ktAnnotationEntry;
        return ReplaceObsoleteLabelSyntaxFix.Companion.looksLikeObsoleteLabel(annotationEntry);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<CleanupFix> toCleanupFixes(Diagnostic $receiver) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv = KotlinPsiChecker.Companion.createQuickFixes($receiver);
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof CleanupFix)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final ProblemDescriptor toProblemDescriptor(Diagnostic $receiver, Collection<? extends CleanupFix> fixes2, KtFile file, InspectionManager manager) {
        PsiElement psiElement = $receiver.getPsiElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"psiElement");
        String string = DefaultErrorMessages.render($receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DefaultErrorMessages.render(this)");
        return this.createProblemDescriptor(psiElement, string, fixes2, file, manager);
    }

    /*
     * WARNING - void declaration
     */
    private final ProblemDescriptor createProblemDescriptor(PsiElement element2, String message2, Collection<? extends CleanupFix> fixes2, KtFile file, InspectionManager manager) {
        Object[] objectArray;
        void destination$iv$iv;
        void $receiver$iv$iv;
        Collection $receiver$iv;
        Iterable iterable = fixes2;
        boolean bl = false;
        String string = message2;
        PsiElement psiElement = element2;
        InspectionManager inspectionManager = manager;
        void var7_11 = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            CleanupFix cleanupFix = (CleanupFix)item$iv$iv;
            objectArray = destination$iv$iv;
            Wrapper wrapper = new Wrapper((IntentionAction)it, file);
            objectArray.add(wrapper);
        }
        objectArray = (Object[])destination$iv$iv;
        $receiver$iv = (Collection)objectArray;
        Collection thisCollection$iv = $receiver$iv;
        Wrapper[] wrapperArray = thisCollection$iv.toArray(new Wrapper[thisCollection$iv.size()]);
        if (wrapperArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        objectArray = (Object[])wrapperArray;
        ProblemDescriptor problemDescriptor = inspectionManager.createProblemDescriptor(psiElement, string, bl, (LocalQuickFix[])objectArray, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        Intrinsics.checkExpressionValueIsNotNull((Object)problemDescriptor, (String)"manager.createProblemDes\u2026GENERIC_ERROR_OR_WARNING)");
        return problemDescriptor;
    }

    public static final /* synthetic */ boolean access$isCleanup(KotlinCleanupInspection $this, Diagnostic $receiver) {
        return $this.isCleanup($receiver);
    }

    @NotNull
    public static final /* synthetic */ Collection access$toCleanupFixes(KotlinCleanupInspection $this, Diagnostic $receiver) {
        return $this.toCleanupFixes($receiver);
    }

    @NotNull
    public static final /* synthetic */ ProblemDescriptor access$toProblemDescriptor(KotlinCleanupInspection $this, Diagnostic $receiver, @NotNull Collection fixes2, @NotNull KtFile file, @NotNull InspectionManager manager) {
        return $this.toProblemDescriptor($receiver, fixes2, file, manager);
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J%\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0004\u001a\u0004\u0018\u00010\u000fH\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/KotlinCleanupInspection$Wrapper;", "Lcom/intellij/codeInspection/IntentionWrapper;", "intention", "Lcom/intellij/codeInsight/intention/IntentionAction;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lcom/intellij/codeInsight/intention/IntentionAction;Lorg/jetbrains/kotlin/psi/KtFile;)V", "getIntention", "()Lcom/intellij/codeInsight/intention/IntentionAction;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "Lcom/intellij/psi/PsiFile;", "idea"})
    private static final class Wrapper
    extends IntentionWrapper {
        @NotNull
        private final IntentionAction intention;

        public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            if (this.intention.isAvailable(project, editor, file)) {
                super.invoke(project, editor, file);
            }
        }

        @NotNull
        public final IntentionAction getIntention() {
            return this.intention;
        }

        public Wrapper(@NotNull IntentionAction intention, @NotNull KtFile file) {
            Intrinsics.checkParameterIsNotNull((Object)intention, (String)"intention");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            super(intention, (PsiFile)file);
            this.intention = intention;
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/KotlinCleanupInspection$RemoveImportFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "Lorg/jetbrains/kotlin/idea/quickfix/CleanupFix;", "import", "(Lorg/jetbrains/kotlin/psi/KtImportDirective;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "idea"})
    private static final class RemoveImportFix
    extends KotlinQuickFixAction<KtImportDirective>
    implements CleanupFix {
        @NotNull
        public String getFamilyName() {
            return "Remove deprecated symbol import";
        }

        @NotNull
        public String getText() {
            return this.getFamilyName();
        }

        @Override
        protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            ((KtImportDirective)this.getElement()).delete();
        }

        public RemoveImportFix(@NotNull KtImportDirective ktImportDirective) {
            Intrinsics.checkParameterIsNotNull((Object)ktImportDirective, (String)"import");
            super((PsiElement)ktImportDirective);
        }
    }
}

