/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.maddyhome.idea.copyright.CopyrightManager;
import com.maddyhome.idea.copyright.actions.UpdateCopyrightProcessor;
import com.maddyhome.idea.copyright.ui.CopyrightProjectConfigurable;
import com.maddyhome.idea.copyright.util.FileTypeUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class GenerateCopyrightAction
extends AnAction {
    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        DataContext context = event.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        PsiFile file = GenerateCopyrightAction.getFile(context, project);
        if (file == null || !FileTypeUtil.isSupportedFile(file)) {
            presentation.setEnabled(false);
        }
    }

    @Nullable
    private static PsiFile getFile(DataContext context, Project project) {
        Editor editor;
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        if (file == null && (editor = (Editor)CommonDataKeys.EDITOR.getData(context)) != null) {
            file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        }
        return file;
    }

    public void actionPerformed(AnActionEvent event) {
        DataContext context = event.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        assert (project != null);
        Module module = (Module)LangDataKeys.MODULE.getData(context);
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiFile file = GenerateCopyrightAction.getFile(context, project);
        assert (file != null);
        if (CopyrightManager.getInstance(project).getCopyrightOptions(file) == null) {
            if (Messages.showOkCancelDialog((Project)project, (String)"No copyright configured for current file. Would you like to edit copyright settings?", (String)"No Copyright Available", (Icon)Messages.getQuestionIcon()) == 0) {
                ShowSettingsUtil.getInstance().showSettingsDialog(project, new CopyrightProjectConfigurable(project).getDisplayName());
            } else {
                return;
            }
        }
        new UpdateCopyrightProcessor(project, module, file).run();
    }
}

