#!/bin/sh
export PATH='/usr/obj/ports/hs-hedis-0.9.1/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: hedis
version: 0.9.1
id: hedis-0.9.1-501271c7260c14a48011f07391af2747
key: hedis_Ki9Pz2faEmoLaNKhcSFVp0
license: BSD3
copyright: Copyright (c) 2011 Falko Peters
maintainer: Kostiantyn Rybnikov <k-bx@k-bx.com>
homepage: https://github.com/informatikr/hedis
synopsis: Client library for the Redis datastore: supports full command set,
          pipelining.
description:
    Redis is an open source, advanced key-value store. It is often referred to
    as a data structure server since keys can contain strings, hashes, lists,
    sets and sorted sets. This library is a Haskell client for the Redis
    datastore. Compared to other Haskell client libraries it has some
    advantages:
    .
    [Complete Redis 2.6 command set:] All Redis commands
    (<http://redis.io/commands>) are available as haskell functions, except
    for the MONITOR and SYNC commands. Additionally, a low-level API is
    exposed that  makes it easy for the library user to implement further
    commands, such as new commands from an experimental Redis version.
    .
    [Automatic Optimal Pipelining:] Commands are pipelined
    (<http://redis.io/topics/pipelining>) as much as possible without any
    work by the user. See
    <http://informatikr.com/2012/redis-pipelining.html> for a
    technical explanation of automatic optimal pipelining.
    .
    [Enforced Pub\/Sub semantics:] When subscribed to the Redis Pub\/Sub server
    (<http://redis.io/topics/pubsub>), clients are not allowed to issue
    commands other than subscribing to or unsubscribing from channels. This
    library uses the type system to enforce the correct behavior.
    .
    [Connect via TCP or Unix Domain Socket:] TCP sockets are the default way to
    connect to a Redis server. For connections to a server on the same
    machine, Unix domain sockets offer higher performance than the standard
    TCP connection.
    .
    For detailed documentation, see the "Database.Redis" module.
    .
category: Database
author: Falko Peters <falko.peters@gmail.com>
exposed: True
exposed-modules:
    Database.Redis
hidden-modules: Database.Redis.Core
                Database.Redis.ProtocolPipelining Database.Redis.Protocol
                Database.Redis.PubSub Database.Redis.Transactions
                Database.Redis.Types Database.Redis.Commands
                Database.Redis.ManualCommands
trusted: False
import-dirs: /usr/local/lib/ghc/hedis-0.9.1
library-dirs: /usr/local/lib/ghc/hedis-0.9.1
data-dir: /usr/local/share/hs-hedis-0.9.1
hs-libraries: HShedis-0.9.1-Ki9Pz2faEmoLaNKhcSFVp0
depends:
    base-4.8.2.0-8dd7859ce039df9f3d3f4ff9dbf4bb93
    bytestring-0.10.6.0-8a126a308e25adafa4b7221965acccd5
    bytestring-lexing-0.5.0.2-1a082d9189bb22d9dd6e34cd0d63457e
    deepseq-1.4.1.1-614b63b36dd6e29d2b35afff57c25311
    mtl-2.2.1-3af90341e75ee52dfc4e3143b4e5d219
    network-2.6.2.1-7074df06df1d0866c49f7a1ab750c7fa
    resource-pool-0.2.1.1-93f9274f40110d42692a3fd91f19d9f7
    scanner-0.2-5184f1ca588424021f1df0296a259979
    text-1.2.1.3-d050b6e0fc32994b2ea423ca0ac22057
    time-1.5.0.1-1b9a502bb07a3e6f4d6935fbf9db7181
    vector-0.11.0.0-299aefb173ce5a731565d31f609a0cfd
haddock-interfaces: /usr/local/share/doc/hs-hedis-0.9.1/html/hedis.haddock
haddock-html: /usr/local/share/doc/hs-hedis-0.9.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
