/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class DefaultTreeCellEditor
implements ActionListener,
TreeCellEditor,
TreeSelectionListener {
    private EventListenerList listenerList = new EventListenerList();
    protected TreeCellEditor realEditor;
    protected DefaultTreeCellRenderer renderer;
    protected Container editingContainer;
    protected transient Component editingComponent;
    protected boolean canEdit;
    protected transient int offset;
    protected transient JTree tree;
    protected transient TreePath lastPath;
    protected transient Timer timer;
    protected transient int lastRow;
    protected Color borderSelectionColor;
    protected transient Icon editingIcon;
    protected Font font;

    public DefaultTreeCellEditor(JTree tree, DefaultTreeCellRenderer renderer) {
        this(tree, renderer, null);
    }

    public DefaultTreeCellEditor(JTree tree, DefaultTreeCellRenderer renderer, TreeCellEditor editor) {
        this.renderer = renderer;
        this.realEditor = editor;
        if (this.realEditor == null) {
            this.realEditor = this.createTreeCellEditor();
        }
        this.editingContainer = this.createContainer();
        this.setTree(tree);
        Color c = UIManager.getColor("Tree.editorBorderSelectionColor");
        this.setBorderSelectionColor(c);
    }

    private void writeObject(ObjectOutputStream value0) throws IOException {
    }

    private void readObject(ObjectInputStream value0) throws IOException, ClassNotFoundException {
    }

    public void setBorderSelectionColor(Color newColor) {
        this.borderSelectionColor = newColor;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    public void setFont(Font font) {
        this.font = font != null ? font : this.renderer.getFont();
    }

    public Font getFont() {
        return this.font;
    }

    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        this.setTree(tree);
        this.lastRow = row;
        this.determineOffset(tree, value, isSelected, expanded, leaf, row);
        if (this.editingComponent != null) {
            this.editingContainer.remove(this.editingComponent);
        }
        this.editingComponent = this.realEditor.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
        Font f = this.getFont();
        if (f == null) {
            if (this.renderer != null) {
                f = this.renderer.getFont();
            }
            if (f == null) {
                f = tree.getFont();
            }
        }
        this.editingContainer.setFont(f);
        this.prepareForEditing();
        return this.editingContainer;
    }

    public Object getCellEditorValue() {
        return this.realEditor.getCellEditorValue();
    }

    public boolean isCellEditable(EventObject event) {
        boolean ret = false;
        boolean ed = false;
        if (event != null && event.getSource() instanceof JTree) {
            this.setTree((JTree)event.getSource());
            if (event instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)event;
                TreePath path = this.tree.getPathForLocation(me.getX(), me.getY());
                boolean bl = ed = this.lastPath != null && path != null && this.lastPath.equals(path);
                if (path != null) {
                    this.lastRow = this.tree.getRowForPath(path);
                    Object val = path.getLastPathComponent();
                    boolean isSelected = this.tree.isRowSelected(this.lastRow);
                    boolean isExpanded = this.tree.isExpanded(path);
                    TreeModel m = this.tree.getModel();
                    boolean isLeaf = m.isLeaf(val);
                    this.determineOffset(this.tree, val, isSelected, isExpanded, isLeaf, this.lastRow);
                }
            }
        }
        if (!this.realEditor.isCellEditable(event)) {
            ret = false;
        } else if (this.canEditImmediately(event)) {
            ret = true;
        } else if (ed && this.shouldStartEditingTimer(event)) {
            this.startEditingTimer();
        } else if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
        if (ret) {
            this.prepareForEditing();
        }
        return ret;
    }

    public boolean shouldSelectCell(EventObject event) {
        return true;
    }

    public boolean stopCellEditing() {
        boolean ret = false;
        if (this.realEditor.stopCellEditing()) {
            this.finish();
            ret = true;
        }
        return ret;
    }

    public void cancelCellEditing() {
        this.realEditor.cancelCellEditing();
        this.finish();
    }

    private void finish() {
        if (this.editingComponent != null) {
            this.editingContainer.remove(this.editingComponent);
        }
        this.editingComponent = null;
    }

    public void addCellEditorListener(CellEditorListener listener) {
        this.realEditor.addCellEditorListener(listener);
    }

    public void removeCellEditorListener(CellEditorListener listener) {
        this.realEditor.removeCellEditorListener(listener);
    }

    public CellEditorListener[] getCellEditorListeners() {
        return (CellEditorListener[])this.listenerList.getListeners(CellEditorListener.class);
    }

    public void valueChanged(TreeSelectionEvent e) {
        if (this.tree != null) {
            this.lastPath = this.tree.getSelectionCount() == 1 ? this.tree.getSelectionPath() : null;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.tree != null && this.lastPath != null) {
            this.tree.startEditingAtPath(this.lastPath);
        }
    }

    protected void setTree(JTree newTree) {
        if (this.tree != newTree) {
            if (this.tree != null) {
                this.tree.removeTreeSelectionListener(this);
            }
            this.tree = newTree;
            if (this.tree != null) {
                this.tree.addTreeSelectionListener(this);
            }
            if (this.timer != null) {
                this.timer.stop();
            }
        }
    }

    protected boolean shouldStartEditingTimer(EventObject event) {
        boolean ret = false;
        if (event instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)event;
            ret = SwingUtilities.isLeftMouseButton(me) && me.getClickCount() == 1 && this.inHitRegion(me.getX(), me.getY());
        }
        return ret;
    }

    protected void startEditingTimer() {
        if (this.timer == null) {
            this.timer = new Timer(1200, this);
            this.timer.setRepeats(false);
        }
        this.timer.start();
    }

    protected boolean canEditImmediately(EventObject event) {
        return event == null || !(event instanceof MouseEvent) || ((MouseEvent)event).getClickCount() > 2 && this.inHitRegion(((MouseEvent)event).getX(), ((MouseEvent)event).getY());
    }

    protected boolean inHitRegion(int x, int y) {
        Rectangle bounds = this.tree.getPathBounds(this.lastPath);
        return bounds.contains(x, y);
    }

    protected void determineOffset(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        if (this.renderer != null) {
            this.editingIcon = leaf ? this.renderer.getLeafIcon() : (expanded ? this.renderer.getOpenIcon() : this.renderer.getClosedIcon());
            this.offset = this.editingIcon != null ? this.renderer.getIconTextGap() + this.editingIcon.getIconWidth() : this.renderer.getIconTextGap();
        } else {
            this.editingIcon = null;
            this.offset = 0;
        }
    }

    protected void prepareForEditing() {
        if (this.editingComponent != null) {
            this.editingContainer.add(this.editingComponent);
        }
    }

    protected Container createContainer() {
        return new EditorContainer();
    }

    protected TreeCellEditor createTreeCellEditor() {
        Border border = UIManager.getBorder("Tree.editorBorder");
        DefaultTextField tf = new DefaultTextField(border);
        DefaultCellEditor editor = new DefaultCellEditor(tf);
        editor.setClickCountToStart(1);
        this.realEditor = editor;
        return editor;
    }

    public class DefaultTextField
    extends JTextField {
        static final long serialVersionUID = -6629304544265300143L;
        protected Border border;

        public DefaultTextField(Border aBorder) {
            this.border = aBorder;
        }

        public Font getFont() {
            Font font = super.getFont();
            if (font == null) {
                Container parent = this.getParent();
                if (parent != null) {
                    return parent.getFont();
                }
                return null;
            }
            return font;
        }

        public Border getBorder() {
            return this.border;
        }

        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            if (DefaultTreeCellEditor.this.renderer != null && DefaultTreeCellEditor.this.getFont() == null) {
                size.height = DefaultTreeCellEditor.this.renderer.getPreferredSize().height;
            }
            return DefaultTreeCellEditor.this.renderer.getPreferredSize();
        }
    }

    public class EditorContainer
    extends Container {
        static final long serialVersionUID = 6470339600449699810L;

        public EditorContainer() {
            this.setLayout(null);
        }

        public void EditorContainer() {
        }

        public void paint(Graphics g) {
            Color c;
            if (DefaultTreeCellEditor.this.editingIcon != null) {
                int y = Math.max(0, (this.getHeight() - DefaultTreeCellEditor.this.editingIcon.getIconHeight()) / 2);
                DefaultTreeCellEditor.this.editingIcon.paintIcon(this, g, 0, y);
            }
            if ((c = DefaultTreeCellEditor.this.getBorderSelectionColor()) != null) {
                g.setColor(c);
                g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
            super.paint(g);
        }

        public void doLayout() {
            if (DefaultTreeCellEditor.this.editingComponent != null) {
                DefaultTreeCellEditor.this.editingComponent.getPreferredSize();
                DefaultTreeCellEditor.this.editingComponent.setBounds(DefaultTreeCellEditor.this.offset, 0, this.getWidth() - DefaultTreeCellEditor.this.offset, this.getHeight());
            }
        }

        public Dimension getPreferredSize() {
            Dimension dim;
            if (DefaultTreeCellEditor.this.editingComponent != null) {
                dim = DefaultTreeCellEditor.this.editingComponent.getPreferredSize();
                dim.width += DefaultTreeCellEditor.this.offset + 5;
                if (DefaultTreeCellEditor.this.renderer != null) {
                    Dimension r = DefaultTreeCellEditor.this.renderer.getPreferredSize();
                    dim.height = Math.max(dim.height, r.height);
                }
                if (DefaultTreeCellEditor.this.editingIcon != null) {
                    dim.height = Math.max(dim.height, DefaultTreeCellEditor.this.editingIcon.getIconHeight());
                }
                dim.width = Math.max(100, dim.width);
            } else {
                dim = new Dimension(0, 0);
            }
            return dim;
        }
    }
}

