/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ImagingOpException;
import java.awt.image.Kernel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;

public class ConvolveOp
implements BufferedImageOp,
RasterOp {
    public static final int EDGE_ZERO_FILL = 0;
    public static final int EDGE_NO_OP = 1;
    private Kernel kernel;
    private int edge;
    private RenderingHints hints;

    public ConvolveOp(Kernel kernel, int edgeCondition, RenderingHints hints) {
        this.kernel = kernel;
        this.edge = edgeCondition;
        this.hints = hints;
    }

    public ConvolveOp(Kernel kernel) {
        this.kernel = kernel;
        this.edge = 0;
        this.hints = null;
    }

    public final BufferedImage filter(BufferedImage src, BufferedImage dst) {
        if (src == dst) {
            throw new IllegalArgumentException("Source and destination images cannot be the same.");
        }
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, src.getColorModel());
        }
        BufferedImage src1 = src;
        BufferedImage dst1 = dst;
        if (src1.getColorModel().getColorSpace().getType() != dst.getColorModel().getColorSpace().getType()) {
            dst1 = this.createCompatibleDestImage(src, src.getColorModel());
        }
        this.filter(src1.getRaster(), dst1.getRaster());
        if (dst1 != dst) {
            new ColorConvertOp(this.hints).filter(dst1, dst);
        }
        return dst;
    }

    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel dstCM) {
        if (dstCM != null) {
            return new BufferedImage(dstCM, src.getRaster().createCompatibleWritableRaster(), src.isAlphaPremultiplied(), null);
        }
        return new BufferedImage(src.getWidth(), src.getHeight(), src.getType());
    }

    public final RenderingHints getRenderingHints() {
        return this.hints;
    }

    public int getEdgeCondition() {
        return this.edge;
    }

    public final Kernel getKernel() {
        return (Kernel)this.kernel.clone();
    }

    public final WritableRaster filter(Raster src, WritableRaster dest) {
        if (src == dest) {
            throw new IllegalArgumentException("src == dest is not allowed.");
        }
        if (this.kernel.getWidth() > src.getWidth() || this.kernel.getHeight() > src.getHeight()) {
            throw new ImagingOpException("The kernel is too large.");
        }
        if (dest == null) {
            dest = this.createCompatibleDestRaster(src);
        } else if (src.getNumBands() != dest.getNumBands()) {
            throw new ImagingOpException("src and dest have different band counts.");
        }
        int kWidth = this.kernel.getWidth();
        int kHeight = this.kernel.getHeight();
        int left = this.kernel.getXOrigin();
        int right = Math.max(kWidth - left - 1, 0);
        int top = this.kernel.getYOrigin();
        int bottom = Math.max(kHeight - top - 1, 0);
        int[] maxValue = src.getSampleModel().getSampleSize();
        int i = 0;
        while (i < maxValue.length) {
            maxValue[i] = (int)Math.pow(2.0, maxValue[i]) - 1;
            ++i;
        }
        int regionW = src.width - left - right;
        int regionH = src.height - top - bottom;
        float[] kvals = this.kernel.getKernelData(null);
        float[] tmp = new float[kWidth * kHeight];
        int x = 0;
        while (x < regionW) {
            int y = 0;
            while (y < regionH) {
                int b = 0;
                while (b < src.getNumBands()) {
                    float v = 0.0f;
                    src.getSamples(x, y, kWidth, kHeight, b, tmp);
                    int i2 = 0;
                    while (i2 < tmp.length) {
                        v += tmp[tmp.length - i2 - 1] * kvals[i2];
                        ++i2;
                    }
                    if (v > (float)maxValue[b]) {
                        v = maxValue[b];
                    } else if (v < 0.0f) {
                        v = 0.0f;
                    }
                    dest.setSample(x + this.kernel.getXOrigin(), y + this.kernel.getYOrigin(), b, v);
                    ++b;
                }
                ++y;
            }
            ++x;
        }
        this.fillEdge(src, dest, 0, 0, src.width, top, this.edge);
        this.fillEdge(src, dest, 0, src.height - bottom, src.width, bottom, this.edge);
        this.fillEdge(src, dest, 0, top, left, regionH, this.edge);
        this.fillEdge(src, dest, src.width - right, top, right, regionH, this.edge);
        return dest;
    }

    private void fillEdge(Raster src, WritableRaster dest, int x, int y, int w, int h, int edgeOp) {
        if (w <= 0) {
            return;
        }
        if (h <= 0) {
            return;
        }
        if (edgeOp == 0) {
            float[] zeros = new float[src.getNumBands() * w * h];
            dest.setPixels(x, y, w, h, zeros);
        } else {
            float[] pixels = new float[src.getNumBands() * w * h];
            src.getPixels(x, y, w, h, pixels);
            dest.setPixels(x, y, w, h, pixels);
        }
    }

    public WritableRaster createCompatibleDestRaster(Raster src) {
        return src.createCompatibleWritableRaster();
    }

    public final Rectangle2D getBounds2D(BufferedImage src) {
        return src.getRaster().getBounds();
    }

    public final Rectangle2D getBounds2D(Raster src) {
        return src.getBounds();
    }

    public final Point2D getPoint2D(Point2D src, Point2D dst) {
        if (dst == null) {
            return (Point2D)src.clone();
        }
        dst.setLocation(src);
        return dst;
    }
}

