/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.xpath;

import gnu.java.lang.CPStringBuilder;
import gnu.xml.xpath.Expr;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ConcatFunction
extends Expr {
    final List<Expr> args;

    ConcatFunction(List<Expr> args) {
        this.args = args;
    }

    @Override
    public Object evaluate(Node context, int pos, int len) {
        CPStringBuilder buf = new CPStringBuilder();
        for (Expr arg : this.args) {
            Object val = arg.evaluate(context, pos, len);
            buf.append(ConcatFunction._string(context, val));
        }
        return buf.toString();
    }

    @Override
    public Expr clone(Object context) {
        int len = this.args.size();
        ArrayList<Expr> args2 = new ArrayList<Expr>(len);
        int i = 0;
        while (i < len) {
            args2.add(this.args.get(i).clone(context));
            ++i;
        }
        return new ConcatFunction(args2);
    }

    @Override
    public boolean references(QName var) {
        Iterator<Expr> i = this.args.iterator();
        while (i.hasNext()) {
            if (!i.next().references(var)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        CPStringBuilder buf = new CPStringBuilder("concat(");
        int len = this.args.size();
        int i = 0;
        while (i < len) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(this.args.get(i));
            ++i;
        }
        buf.append(')');
        return buf.toString();
    }
}

