/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.io.gml2;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.util.Assert;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class GMLWriter {
    private final String INDENT = "  ";
    private int startingIndentIndex = 0;
    private int maxCoordinatesPerLine = 10;
    private boolean emitNamespace = false;
    private boolean isRootTag = false;
    private String prefix = "gml";
    private String namespace = "http://www.opengis.net/gml";
    private String srsName = null;
    private String[] customElements = null;
    private static final String coordinateSeparator = ",";
    private static final String tupleSeparator = " ";

    public GMLWriter() {
    }

    public GMLWriter(boolean emitNamespace) {
        this.setNamespace(emitNamespace);
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setSrsName(String srsName) {
        this.srsName = srsName;
    }

    public void setNamespace(boolean emitNamespace) {
        this.emitNamespace = emitNamespace;
    }

    public void setCustomElements(String[] customElements) {
        this.customElements = customElements;
    }

    public void setStartingIndentIndex(int indent) {
        if (indent < 0) {
            indent = 0;
        }
        this.startingIndentIndex = indent;
    }

    public void setMaxCoordinatesPerLine(int num) {
        if (num < 1) {
            throw new IndexOutOfBoundsException("Invalid coordinate count per line, must be > 0");
        }
        this.maxCoordinatesPerLine = num;
    }

    public String write(Geometry geom) {
        StringWriter writer = new StringWriter();
        try {
            this.write(geom, writer);
        }
        catch (IOException ex) {
            Assert.shouldNeverReachHere();
        }
        return writer.toString();
    }

    public void write(Geometry geom, Writer writer) throws IOException {
        this.write(geom, writer, this.startingIndentIndex);
    }

    private void write(Geometry geom, Writer writer, int level) throws IOException {
        this.isRootTag = true;
        if (geom instanceof Point) {
            this.writePoint((Point)geom, writer, level);
        } else if (geom instanceof LineString) {
            this.writeLineString((LineString)geom, writer, level);
        } else if (geom instanceof Polygon) {
            this.writePolygon((Polygon)geom, writer, level);
        } else if (geom instanceof MultiPoint) {
            this.writeMultiPoint((MultiPoint)geom, writer, level);
        } else if (geom instanceof MultiLineString) {
            this.writeMultiLineString((MultiLineString)geom, writer, level);
        } else if (geom instanceof MultiPolygon) {
            this.writeMultiPolygon((MultiPolygon)geom, writer, level);
        } else if (geom instanceof GeometryCollection) {
            this.writeGeometryCollection((GeometryCollection)geom, writer, this.startingIndentIndex);
        } else {
            throw new IllegalArgumentException("Unhandled geometry type: " + geom.getGeometryType());
        }
        writer.flush();
    }

    private void writePoint(Point p, Writer writer, int level) throws IOException {
        this.startLine(level, writer);
        this.startGeomTag("Point", p, writer);
        this.write(new Coordinate[]{p.getCoordinate()}, writer, level + 1);
        this.startLine(level, writer);
        this.endGeomTag("Point", writer);
    }

    private void writeLineString(LineString ls, Writer writer, int level) throws IOException {
        this.startLine(level, writer);
        this.startGeomTag("LineString", ls, writer);
        this.write(ls.getCoordinates(), writer, level + 1);
        this.startLine(level, writer);
        this.endGeomTag("LineString", writer);
    }

    private void writeLinearRing(LinearRing lr, Writer writer, int level) throws IOException {
        this.startLine(level, writer);
        this.startGeomTag("LinearRing", lr, writer);
        this.write(lr.getCoordinates(), writer, level + 1);
        this.startLine(level, writer);
        this.endGeomTag("LinearRing", writer);
    }

    private void writePolygon(Polygon p, Writer writer, int level) throws IOException {
        this.startLine(level, writer);
        this.startGeomTag("Polygon", p, writer);
        this.startLine(level + 1, writer);
        this.startGeomTag("outerBoundaryIs", null, writer);
        this.writeLinearRing((LinearRing)p.getExteriorRing(), writer, level + 2);
        this.startLine(level + 1, writer);
        this.endGeomTag("outerBoundaryIs", writer);
        for (int t = 0; t < p.getNumInteriorRing(); ++t) {
            this.startLine(level + 1, writer);
            this.startGeomTag("innerBoundaryIs", null, writer);
            this.writeLinearRing((LinearRing)p.getInteriorRingN(t), writer, level + 2);
            this.startLine(level + 1, writer);
            this.endGeomTag("innerBoundaryIs", writer);
        }
        this.startLine(level, writer);
        this.endGeomTag("Polygon", writer);
    }

    private void writeMultiPoint(MultiPoint mp, Writer writer, int level) throws IOException {
        this.startLine(level, writer);
        this.startGeomTag("MultiPoint", mp, writer);
        for (int t = 0; t < mp.getNumGeometries(); ++t) {
            this.startLine(level + 1, writer);
            this.startGeomTag("pointMember", null, writer);
            this.writePoint((Point)mp.getGeometryN(t), writer, level + 2);
            this.startLine(level + 1, writer);
            this.endGeomTag("pointMember", writer);
        }
        this.startLine(level, writer);
        this.endGeomTag("MultiPoint", writer);
    }

    private void writeMultiLineString(MultiLineString mls, Writer writer, int level) throws IOException {
        this.startLine(level, writer);
        this.startGeomTag("MultiLineString", mls, writer);
        for (int t = 0; t < mls.getNumGeometries(); ++t) {
            this.startLine(level + 1, writer);
            this.startGeomTag("lineStringMember", null, writer);
            this.writeLineString((LineString)mls.getGeometryN(t), writer, level + 2);
            this.startLine(level + 1, writer);
            this.endGeomTag("lineStringMember", writer);
        }
        this.startLine(level, writer);
        this.endGeomTag("MultiLineString", writer);
    }

    private void writeMultiPolygon(MultiPolygon mp, Writer writer, int level) throws IOException {
        this.startLine(level, writer);
        this.startGeomTag("MultiPolygon", mp, writer);
        for (int t = 0; t < mp.getNumGeometries(); ++t) {
            this.startLine(level + 1, writer);
            this.startGeomTag("polygonMember", null, writer);
            this.writePolygon((Polygon)mp.getGeometryN(t), writer, level + 2);
            this.startLine(level + 1, writer);
            this.endGeomTag("polygonMember", writer);
        }
        this.startLine(level, writer);
        this.endGeomTag("MultiPolygon", writer);
    }

    private void writeGeometryCollection(GeometryCollection gc, Writer writer, int level) throws IOException {
        this.startLine(level, writer);
        this.startGeomTag("MultiGeometry", gc, writer);
        for (int t = 0; t < gc.getNumGeometries(); ++t) {
            this.startLine(level + 1, writer);
            this.startGeomTag("geometryMember", null, writer);
            this.write(gc.getGeometryN(t), writer, level + 2);
            this.startLine(level + 1, writer);
            this.endGeomTag("geometryMember", writer);
        }
        this.startLine(level, writer);
        this.endGeomTag("MultiGeometry", writer);
    }

    private void write(Coordinate[] coords, Writer writer, int level) throws IOException {
        this.startLine(level, writer);
        this.startGeomTag("coordinates", null, writer);
        int dim = 2;
        if (coords.length > 0 && !Double.isNaN(coords[0].z)) {
            dim = 3;
        }
        boolean isNewLine = true;
        for (int i = 0; i < coords.length; ++i) {
            if (isNewLine) {
                this.startLine(level + 1, writer);
                isNewLine = false;
            }
            if (dim == 2) {
                writer.write("" + coords[i].x);
                writer.write(coordinateSeparator);
                writer.write("" + coords[i].y);
            } else if (dim == 3) {
                writer.write("" + coords[i].x);
                writer.write(coordinateSeparator);
                writer.write("" + coords[i].y);
                writer.write(coordinateSeparator);
                writer.write("" + coords[i].z);
            }
            writer.write(tupleSeparator);
            if ((i + 1) % this.maxCoordinatesPerLine != 0 || i >= coords.length - 1) continue;
            writer.write("\n");
            isNewLine = true;
        }
        if (!isNewLine) {
            writer.write("\n");
        }
        this.startLine(level, writer);
        this.endGeomTag("coordinates", writer);
    }

    private void startLine(int level, Writer writer) throws IOException {
        for (int i = 0; i < level; ++i) {
            writer.write("  ");
        }
    }

    private void startGeomTag(String geometryName, Geometry g, Writer writer) throws IOException {
        writer.write("<" + (this.prefix == null || "".equals(this.prefix) ? "" : this.prefix + ":"));
        writer.write(geometryName);
        this.writeAttributes(g, writer);
        writer.write(">\n");
        this.writeCustomElements(g, writer);
        this.isRootTag = false;
    }

    private void writeAttributes(Geometry geom, Writer writer) throws IOException {
        if (geom == null) {
            return;
        }
        if (!this.isRootTag) {
            return;
        }
        if (this.emitNamespace) {
            writer.write(" xmlns" + (this.prefix == null || "".equals(this.prefix) ? "" : ":" + this.prefix) + "='" + this.namespace + "'");
        }
        if (this.srsName != null && this.srsName.length() > 0) {
            writer.write(" srsName='" + this.srsName + "'");
        }
    }

    private void writeCustomElements(Geometry geom, Writer writer) throws IOException {
        if (geom == null) {
            return;
        }
        if (!this.isRootTag) {
            return;
        }
        if (this.customElements == null) {
            return;
        }
        for (int i = 0; i < this.customElements.length; ++i) {
            writer.write(this.customElements[i]);
            writer.write("\n");
        }
    }

    private void endGeomTag(String geometryName, Writer writer) throws IOException {
        writer.write("</" + this.prefix());
        writer.write(geometryName);
        writer.write(">\n");
    }

    private String prefix() {
        if (this.prefix == null || this.prefix.length() == 0) {
            return "";
        }
        return this.prefix + ":";
    }
}

