/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rolling;

import java.io.File;
import java.util.Date;
import org.apache.log4j.Appender;
import org.apache.log4j.pattern.PatternConverter;
import org.apache.log4j.rolling.RollingPolicyBase;
import org.apache.log4j.rolling.RolloverDescription;
import org.apache.log4j.rolling.RolloverDescriptionImpl;
import org.apache.log4j.rolling.TriggeringPolicy;
import org.apache.log4j.rolling.helper.ActionBase;
import org.apache.log4j.rolling.helper.FileRenameAction;
import org.apache.log4j.rolling.helper.GZCompressAction;
import org.apache.log4j.rolling.helper.ZipCompressAction;
import org.apache.log4j.spi.LoggingEvent;

public final class TimeBasedRollingPolicy
extends RollingPolicyBase
implements TriggeringPolicy {
    private long nextCheck = 0L;
    private String lastFileName = null;
    private int suffixLength = 0;

    public void activateOptions() {
        super.activateOptions();
        PatternConverter dtc = this.getDatePatternConverter();
        if (dtc == null) {
            throw new IllegalStateException("FileNamePattern [" + this.getFileNamePattern() + "] does not contain a valid date format specifier");
        }
        long n = System.currentTimeMillis();
        StringBuffer buf = new StringBuffer();
        this.formatFileName(new Date(n), buf);
        this.lastFileName = buf.toString();
        this.suffixLength = 0;
        if (this.lastFileName.endsWith(".gz")) {
            this.suffixLength = 3;
        } else if (this.lastFileName.endsWith(".zip")) {
            this.suffixLength = 4;
        }
    }

    public RolloverDescription initialize(String currentActiveFile, boolean append) {
        long n = System.currentTimeMillis();
        this.nextCheck = (n / 1000L + 1L) * 1000L;
        StringBuffer buf = new StringBuffer();
        this.formatFileName(new Date(n), buf);
        this.lastFileName = buf.toString();
        if (this.activeFileName != null) {
            return new RolloverDescriptionImpl(this.activeFileName, append, null, null);
        }
        if (currentActiveFile != null) {
            return new RolloverDescriptionImpl(currentActiveFile, append, null, null);
        }
        return new RolloverDescriptionImpl(this.lastFileName.substring(0, this.lastFileName.length() - this.suffixLength), append, null, null);
    }

    public RolloverDescription rollover(String currentActiveFile) {
        long n = System.currentTimeMillis();
        this.nextCheck = (n / 1000L + 1L) * 1000L;
        StringBuffer buf = new StringBuffer();
        this.formatFileName(new Date(n), buf);
        String newFileName = buf.toString();
        if (newFileName.equals(this.lastFileName)) {
            return null;
        }
        FileRenameAction renameAction = null;
        ActionBase compressAction = null;
        String lastBaseName = this.lastFileName.substring(0, this.lastFileName.length() - this.suffixLength);
        String nextActiveFile = newFileName.substring(0, newFileName.length() - this.suffixLength);
        if (!currentActiveFile.equals(lastBaseName)) {
            renameAction = new FileRenameAction(new File(currentActiveFile), new File(lastBaseName), true);
            nextActiveFile = currentActiveFile;
        }
        if (this.suffixLength == 3) {
            compressAction = new GZCompressAction(new File(lastBaseName), new File(this.lastFileName), true);
        }
        if (this.suffixLength == 4) {
            compressAction = new ZipCompressAction(new File(lastBaseName), new File(this.lastFileName), true);
        }
        this.lastFileName = newFileName;
        return new RolloverDescriptionImpl(nextActiveFile, false, renameAction, compressAction);
    }

    public boolean isTriggeringEvent(Appender appender, LoggingEvent event, String filename, long fileLength) {
        return System.currentTimeMillis() >= this.nextCheck;
    }
}

