/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject.assistedinject;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.inject.ConfigurationException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.inject.Key;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.inject.TypeLiteral;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.inject.assistedinject.AssistedConstructor;
import org.elasticsearch.common.inject.assistedinject.AssistedInject;
import org.elasticsearch.common.inject.assistedinject.FactoryProvider2;
import org.elasticsearch.common.inject.assistedinject.Parameter;
import org.elasticsearch.common.inject.assistedinject.ParameterListKey;
import org.elasticsearch.common.inject.internal.Errors;
import org.elasticsearch.common.inject.spi.Dependency;
import org.elasticsearch.common.inject.spi.HasDependencies;
import org.elasticsearch.common.inject.spi.Message;

public class FactoryProvider<F>
implements Provider<F>,
HasDependencies {
    private Injector injector;
    private final TypeLiteral<F> factoryType;
    private final Map<Method, AssistedConstructor<?>> factoryMethodToConstructor;

    public static <F> Provider<F> newFactory(Class<F> factoryType, Class<?> implementationType) {
        return FactoryProvider.newFactory(TypeLiteral.get(factoryType), TypeLiteral.get(implementationType));
    }

    public static <F> Provider<F> newFactory(TypeLiteral<F> factoryType, TypeLiteral<?> implementationType) {
        Map<Method, AssistedConstructor<?>> factoryMethodToConstructor = FactoryProvider.createMethodMapping(factoryType, implementationType);
        if (!factoryMethodToConstructor.isEmpty()) {
            return new FactoryProvider<F>(factoryType, factoryMethodToConstructor);
        }
        return new FactoryProvider2<F>(factoryType, Key.get(implementationType));
    }

    private FactoryProvider(TypeLiteral<F> factoryType, Map<Method, AssistedConstructor<?>> factoryMethodToConstructor) {
        this.factoryType = factoryType;
        this.factoryMethodToConstructor = factoryMethodToConstructor;
        this.checkDeclaredExceptionsMatch();
    }

    @Inject
    void setInjectorAndCheckUnboundParametersAreInjectable(Injector injector) {
        this.injector = injector;
        for (AssistedConstructor<?> c : this.factoryMethodToConstructor.values()) {
            for (Parameter p : c.getAllParameters()) {
                if (p.isProvidedByFactory() || this.paramCanBeInjected(p, injector)) continue;
                throw FactoryProvider.newConfigurationException("Parameter of type '%s' is not injectable or annotated with @Assisted for Constructor '%s'", p, c);
            }
        }
    }

    private void checkDeclaredExceptionsMatch() {
        for (Map.Entry<Method, AssistedConstructor<?>> entry : this.factoryMethodToConstructor.entrySet()) {
            for (Class<?> constructorException : entry.getValue().getDeclaredExceptions()) {
                if (this.isConstructorExceptionCompatibleWithFactoryExeception(constructorException, entry.getKey().getExceptionTypes())) continue;
                throw FactoryProvider.newConfigurationException("Constructor %s declares an exception, but no compatible exception is thrown by the factory method %s", entry.getValue(), entry.getKey());
            }
        }
    }

    private boolean isConstructorExceptionCompatibleWithFactoryExeception(Class<?> constructorException, Class<?>[] factoryExceptions) {
        for (Class<?> factoryException : factoryExceptions) {
            if (!factoryException.isAssignableFrom(constructorException)) continue;
            return true;
        }
        return false;
    }

    private boolean paramCanBeInjected(Parameter parameter, Injector injector) {
        return parameter.isBound(injector);
    }

    private static Map<Method, AssistedConstructor<?>> createMethodMapping(TypeLiteral<?> factoryType, TypeLiteral<?> implementationType) {
        ArrayList constructors = new ArrayList();
        for (Constructor<?> constructor : implementationType.getRawType().getDeclaredConstructors()) {
            if (constructor.getAnnotation(AssistedInject.class) == null) continue;
            AssistedConstructor assistedConstructor = new AssistedConstructor(constructor, implementationType.getParameterTypes(constructor));
            constructors.add(assistedConstructor);
        }
        if (constructors.isEmpty()) {
            return ImmutableMap.of();
        }
        Method[] factoryMethods = factoryType.getRawType().getMethods();
        if (constructors.size() != factoryMethods.length) {
            throw FactoryProvider.newConfigurationException("Constructor mismatch: %s has %s @AssistedInject constructors, factory %s has %s creation methods", implementationType, constructors.size(), factoryType, factoryMethods.length);
        }
        HashMap paramsToConstructor = Maps.newHashMap();
        for (AssistedConstructor assistedConstructor : constructors) {
            if (paramsToConstructor.containsKey(assistedConstructor.getAssistedParameters())) {
                throw new RuntimeException("Duplicate constructor, " + assistedConstructor);
            }
            paramsToConstructor.put(assistedConstructor.getAssistedParameters(), assistedConstructor);
        }
        HashMap result = Maps.newHashMap();
        for (Method method : factoryMethods) {
            if (!method.getReturnType().isAssignableFrom(implementationType.getRawType())) {
                throw FactoryProvider.newConfigurationException("Return type of method %s is not assignable from %s", method, implementationType);
            }
            ArrayList<Type> parameterTypes = new ArrayList<Type>();
            for (TypeLiteral<?> typeLiteral : factoryType.getParameterTypes(method)) {
                parameterTypes.add(typeLiteral.getType());
            }
            ParameterListKey methodParams = new ParameterListKey(parameterTypes);
            if (!paramsToConstructor.containsKey(methodParams)) {
                throw FactoryProvider.newConfigurationException("%s has no @AssistInject constructor that takes the @Assisted parameters %s in that order. @AssistInject constructors are %s", implementationType, methodParams, paramsToConstructor.values());
            }
            method.getParameterAnnotations();
            Annotation[][] annotationArray = method.getParameterAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                Annotation[] parameterAnnotations;
                for (Annotation parameterAnnotation : parameterAnnotations = annotationArray[i]) {
                    if (parameterAnnotation.annotationType() != Assisted.class) continue;
                    throw FactoryProvider.newConfigurationException("Factory method %s has an @Assisted parameter, which is incompatible with the deprecated @AssistedInject annotation. Please replace @AssistedInject with @Inject on the %s constructor.", method, implementationType);
                }
            }
            AssistedConstructor assistedConstructor = (AssistedConstructor)paramsToConstructor.remove(methodParams);
            result.put(method, assistedConstructor);
        }
        return result;
    }

    @Override
    public Set<Dependency<?>> getDependencies() {
        ArrayList dependencies = new ArrayList();
        for (AssistedConstructor<?> constructor : this.factoryMethodToConstructor.values()) {
            for (Parameter parameter : constructor.getAllParameters()) {
                if (parameter.isProvidedByFactory()) continue;
                dependencies.add(Dependency.get(parameter.getPrimaryBindingKey()));
            }
        }
        return ImmutableSet.copyOf(dependencies);
    }

    @Override
    public F get() {
        InvocationHandler invocationHandler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] creationArgs) throws Throwable {
                if (method.getDeclaringClass().equals(Object.class)) {
                    return method.invoke((Object)this, creationArgs);
                }
                AssistedConstructor constructor = (AssistedConstructor)FactoryProvider.this.factoryMethodToConstructor.get(method);
                Object[] constructorArgs = this.gatherArgsForConstructor(constructor, creationArgs);
                Object objectToReturn = constructor.newInstance(constructorArgs);
                FactoryProvider.this.injector.injectMembers(objectToReturn);
                return objectToReturn;
            }

            public Object[] gatherArgsForConstructor(AssistedConstructor<?> constructor, Object[] factoryArgs) {
                int numParams = constructor.getAllParameters().size();
                int argPosition = 0;
                Object[] result = new Object[numParams];
                for (int i = 0; i < numParams; ++i) {
                    Parameter parameter = constructor.getAllParameters().get(i);
                    if (parameter.isProvidedByFactory()) {
                        result[i] = factoryArgs[argPosition];
                        ++argPosition;
                        continue;
                    }
                    result[i] = parameter.getValue(FactoryProvider.this.injector);
                }
                return result;
            }
        };
        Class<F> factoryRawType = this.factoryType.getRawType();
        return factoryRawType.cast(Proxy.newProxyInstance(factoryRawType.getClassLoader(), new Class[]{factoryRawType}, invocationHandler));
    }

    private static ConfigurationException newConfigurationException(String format, Object ... args) {
        return new ConfigurationException((Iterable<Message>)ImmutableSet.of((Object)new Message(Errors.format(format, args))));
    }
}

