<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Guide de la mise en cache - Serveur Apache HTTP Version 2.4</title>
<link href="./style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="./style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="./style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="./style/css/prettify.css" />
<script src="./style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="./images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="./mod/">Modules</a> | <a href="./mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="./glossary.html">Glossaire</a> | <a href="./sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="./images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="./images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="./">Version 2.4</a></div><div id="page-content"><div id="preamble"><h1>Guide de la mise en cache</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="./en/caching.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./fr/caching.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./tr/caching.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div>

    <p>Ce document complte la documentation de rfrence des modules
    <code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code>, <code class="module"><a href="./mod/mod_cache_disk.html">mod_cache_disk</a></code>,
    <code class="module"><a href="./mod/mod_file_cache.html">mod_file_cache</a></code> et du programme <a href="programs/htcacheclean.html">htcacheclean</a>.
    Il dcrit l'utilisation des fonctionnalits de mise en
    cache du serveur HTTP Apache
    pour acclrer les services web et proxy, tout en vitant les problmes
    courants et les erreurs de configuration.</p>
  </div>
<div id="quickview"><ul id="toc"><li><img alt="" src="./images/down.gif" /> <a href="#introduction">Introduction</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#http-caching">Mise en cache HTTP  trois tats RFC2616</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#socache-caching">Mise en cache d'objets partags  deux tats de forme
    cl/valeur</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#file-caching">Mise en cache  base de fichiers spcialiss</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#security">Considrations sur la scurit</a></li>
</ul><h3>Voir aussi</h3><ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="introduction" id="introduction">Introduction</a></h2>
    

    <p>Le serveur HTTP Apache offre tout un ensemble de fonctionnalits
    de mise en cache qui ont t conues pour amliorer les performances
    du serveur de diffrentes manires.</p>

    <dl>
        <dt>Mise en cache HTTP  trois tats RFC2616</dt>
        <dd><code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code> et son module de fournisseur
	<code class="module"><a href="./mod/mod_cache_disk.html">mod_cache_disk</a></code> proposent une mise en cache
	intelligente de niveau HTTP. Le contenu proprement dit est
	stock dans le cache, et mod_cache vise  respecter tous les
	en-ttes HTTP, ainsi que les options qui contrlent la mise en
	cache du contenu comme dcrit dans la <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec13.html">Section
	13 de la RFC2616</a>. <code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code> peut grer des
	configurations de mise en cache simples, mais aussi complexes
	comme dans les cas o vous avez  faire  des contenus mandats,
	 des contenus locaux dynamiques, ou lorsque vous avez besoin
	d'acclrer l'accs aux fichiers locaux situs sur disque
	suppos lent.
        </dd>

        <dt>Mise en cache d'objets partags de forme cl/valeur  deux
	tats</dt>
        <dd>
            L'<a href="socache.html">API du cache d'objets partags</a> (socache)
	    et ses modules de fournisseurs
	    proposent une mise en cache d'objets partags  base de
	    couples cl/valeur de niveau serveur. Ces modules sont
	    conus pour la mise en cache de donnes de bas niveau comme
	    les sessions SSL et les donnes d'authentification. les
	    serveurs d'arrire-plan permettent le stockage des donnes
	    au niveau serveur en mmoire partage, ou au niveau
	    datacenter dans un cache comme memcache ou distcache.
        </dd>

        <dt>Mise en cache de fichiers spcialise</dt>
        <dd>
            <code class="module"><a href="./mod/mod_file_cache.html">mod_file_cache</a></code> offre la possibilit de
	    prcharger des fichiers en mmoire au dmarrage du serveur,
	    et peut amliorer les temps d'accs et sauvegarder les
	    gestionnaires de fichiers pour les fichiers qui font l'objet
	    d'accs frquents, vitant ainsi d'avoir  accder au disque
	     chaque requte.
        </dd>
    </dl>

    <p>Pour tirer parti efficacement de ce document, les bases de HTTP doivent
    vous tre familires, et vous devez avoir lu les sections
    <a href="urlmapping.html">Mise en correspondance des
    URLs avec le systme de fichiers</a> et
    <a href="content-negotiation.html">Ngociation sur le contenu</a>
    du guide de l'utilisateur.</p>

  </div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="http-caching" id="http-caching">Mise en cache HTTP  trois tats RFC2616</a></h2>

    

    <table class="related"><tr><th>Modules Apparents</th><th>Directives Apparentes</th></tr><tr><td><ul><li><code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code></li><li><code class="module"><a href="./mod/mod_cache_disk.html">mod_cache_disk</a></code></li></ul></td><td><ul><li><code class="directive"><a href="./mod/mod_cache.html#cacheenable">CacheEnable</a></code></li><li><code class="directive"><a href="./mod/mod_cache.html#cachedisable">CacheDisable</a></code></li><li><code class="directive"><a href="./mod/core.html#usecanonicalname">UseCanonicalName</a></code></li><li><code class="directive"><a href="./mod/mod_negotiation.html#cachenegotiateddocs">CacheNegotiatedDocs</a></code></li></ul></td></tr></table>

    <p>Le module <code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code> permet de tirer avantage du
    mcanisme de mise en cache en ligne faisant partie
    intgrante du protocole HTTP, et dcrit dans la <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec13.html">section
    13 de la RFC2616</a>.</p>

    <p>A la diffrence d'un cache simple cl/valeur  deux tats o le
    contenu est supprim lorsqu'il est prim, un cache HTTP comporte un
    mcanisme permettant de conserver temporairement un contenu prim,
    de demander au serveur original si ce contenu prim a t modifi,
    et dans le cas contraire de le rendre  nouveau valide.</p>

    <p>Une entre d'un cache HTTP peut se prsenter sous un de ces trois
    tats :</p>

    <dl>
    <dt>Frais</dt>
    <dd>
        Si un contenu est suffisamment rcent (plus jeune que sa
	<strong>dure de fracheur</strong>), il est considr comme
	<strong>frais</strong>. Un cache HTTP peut servir un contenu
	frais sans avoir  demander quoi que ce soit au serveur
	d'origine.
    </dd>
    <dt>Prim</dt>
    <dd>
        <p>Si le contenu est trop ancien (plus vieux que sa
	<strong>dure de fracheur</strong>), il est considr comme
	<strong>prim</strong>. Un cache HTTP doit contacter le serveur
	original pour vrifier si le contenu, mme s'il est prim, est
	encore  jour avant de le servir au client. Soit le serveur
	original va rpondre en envoyant un contenu de remplacement si
	le contenu prim n'est plus  jour, soit dans le cas idal il
	renverra un code pour signaler au cache que le contenu est
	encore  jour, et qu'il est inutile de le gnrer ou de
	l'envoyer  nouveau. Le contenu repasse  l'tat "frais" et le
	cycle continue.</p>

        <p>Le protocole HTTP permet au cache de servir des donnes
	primes dans certaines circonstances, comme lorsqu'une
	tentative de rafrachir une entre depuis un serveur original
	se solde par un chec avec un code d'erreur 5xx, ou lorsqu'une
	autre requte est dj en train d'essayer de rafrachir la mme
	entre. Dans ces cas, un en-tte <code>Warning</code> est ajout
	 la rponse.</p>
    </dd>
    <dt>Non Existent</dt>
    <dd>
        Si le cache est plein, il se rserve la possibilit de supprimer
	des entres pour faire de la place. Une entre peut tre
	supprime  tout moment, qu'elle soit frache ou prime.
	L'outil <a href="programs/htcacheclean.html">htcacheclean</a>
	peut tre utilis  la demande, ou lanc en tant que dmon afin
	de conserver la taille du cache ou le nombre d'inodes en de de
	valeurs spcifies. Cet outil essaie cependant de
	supprimer les entres primes avant les entres fraches.
    </dd>
    </dl>

    <p>Le fonctionnement dtaill d'un cache HTTP est dcrit dans la <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec13.html">Section
    13 de la RFC2616</a>.</p>

    <h3>Interaction avec le serveur</h3>
      

      <p>Le module <code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code> interagit avec le serveur
       deux niveaux possibles en fonction de la directive <code class="directive"><a href="./mod/mod_cache.html#cachequickhandler">CacheQuickHandler</a></code> :
      </p>

      <dl>
        <dt>Phase de gestion rapide</dt>
        <dd>
          <p>Cette phase se droule trs tt au cours du traitement de
	  la requte, juste aprs l'interprtation de cette dernire. Si
	  le contenu se trouve dans le cache, il est servi immdiatement
	  et pratiquement tout le reste du traitement de la requte est
	  court-circuit.</p>

              <p>Dans ce scnario, le cache se comporte comme s'il avait
	      t "boulonn"  l'entre du serveur.</p>
              
              <p>Ce mode possde les meilleures performances car la
	      majorit des traitements au niveau du serveur sont
	      court-circuits. Cependant, il court-circuite aussi les
	      phases d'authentification et d'autorisation du traitement
	      au niveau du serveur, et il doit donc tre utilis avec
	      prudence lorsque que ces phases sont importantes.</p>

	      <p>Les requtes comportant un en-tte "Authorization"
	      (comme par exemple l'authentification HTTP basique) ne
	      peuvent tre ni mises en cache, ni servies depuis ce
	      dernier lorsque <code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code> s'excute dans
	      cette phase.</p>
          </dd>
          <dt>Phase de gestion normale</dt>
          <dd>
              <p>Cette phase se droule trs tard au cours du traitement
	      de la requte, en fait aprs toutes les phases de ce
	      traitement.</p>

              <p>Dans ce scnario, le cache se comporte comme s'il avait
	      t "boulonn"  la sortie du serveur.</p>

              <p>Ce mode offre la plus grande souplesse, car il permet
	      de faire intervenir la mise en cache en un point
	      prcisment spcifi de la chane de filtrage, et le
	      contenu issu du cache peut tre filtr ou personnalis
	      avant d'tre servi au client.</p>
          </dd>
        </dl>

        <p>Si l'URL ne se trouve pas dans le cache,
	<code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code> ajoutera un <a href="filter.html">filtre</a>  la chane de filtrage afin
	d'enregistrer la rponse dans le cache, puis passera la main
	pour permettre le droulement normal de la suite du traitement
	de la requte. Si la mise en cache du contenu est autorise, il
	sera enregistr dans le cache pour pouvoir tre servi  nouveau
	; dans le cas contraire, le contenu sera ignor.</p>

        <p>Si le contenu trouv dans le cache est prim, le module
	<code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code> convertit la requte en
	<strong>requte conditionnelle</strong>. Si le serveur original
	renvoie une rponse normale, elle est enregistre dans le cache
	en lieu et place du contenu prim. Si le serveur original
	renvoie une rponse "304 Not Modified", le contenu repasse 
	l'tat "frais" et est servi par le filtre au lieu d'tre
	sauvegard.</p>
    

    <h3>Amlioration du taux de prsence dans le cache</h3>
      

      <p>Lorsqu'un serveur virtuel est connu sous la forme d'un des
      nombreux alias du serveur, la dfinition de la directive
      <code class="directive"><a href="./mod/core.html#usecanonicalname">UseCanonicalName</a></code> 
      <code>On</code> peut augmenter de manire significative le nombre
      de correspondances positives dans le cache. Ceci est du au fait
      que la cl du cache contient le nom d'hte du serveur virtuel.     
      Avec <code class="directive"><a href="./mod/core.html#usecanonicalname">UseCanonicalName</a></code> positionne
       <code>On</code>,
      les htes virtuels possdant plusieurs noms de serveur ou alias ne
      gnreront pas d'entits de cache diffrentes, et le contenu sera mis en
      cache en faisant rfrence au nom d'hte canonique.</p>

    

    <h3>Dure de fracheur</h3>
      

       <p>Un contenu bien form destin  tre mis en cache doit dclarer
       explicitement une dure de fracheur via les champs
       <code>max-age</code> ou <code>s-maxage</code> de l'en-tte
       <code>Cache-Control</code>, ou en incluant un en-tte
       <code>Expires</code>.</p>
      
      <p>De plus, un client peut passer outre la dure de fracheur
      dfinie pour le serveur original en ajoutant son propre en-tte
      <code>Cache-Control</code>  la requte. Dans ce cas, c'est la
      dure de fracheur la plus basse entre la requte et la rponse
      qui l'emporte.</p>

      <p>Lorsque cette dure de fracheur est absente de la requte ou
      de la rponse, une dure de fracheur par dfaut s'applique. La
      dure de fracheur par dfaut des entres du cache est d'une heure
      ; elle peut cependant tre facilement modifie  l'aide de
      la directive <code class="directive"><a href="./mod/mod_cache.html#cachedefaultexpire">CacheDefaultExpire</a></code>.</p>

      <p>Si une rponse ne contient pas d'en-tte <code>Expires</code> mais
      inclut un en-tte <code>Last-Modified</code>, <code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code>
      peut dduire une dure de fracheur en se basant sur une
      heuristique, qui peut tre contrle via la directive <code class="directive"><a href="./mod/mod_cache.html#cachelastmodifiedfactor">CacheLastModifiedFactor</a></code>.</p>

      <p>Pour les contenus locaux, ou les contenus distants qui ne
      spcifient pas leur propre en-tte <code>Expires</code>,
      <code class="module"><a href="./mod/mod_expires.html">mod_expires</a></code> permet de rgler finement la dure de
      fracheur via les paramtres <code>max-age</code> et
      <code>Expires</code>.</p>

      <p>On peut aussi contrler la dure de fracheur maximale en utilisant
      la directive <code class="directive"><a href="./mod/mod_cache.html#cachemaxexpire">CacheMaxExpire</a></code>.</p>

    

    <h3>Guide succinct des requtes conditionnelles</h3>
      

     <p>Lorsqu'un contenu du cache est prim, httpd modifie la requte
     pour en faire une requte conditionnelle</p>

      <p>Lorsque la rponse originale du cache contient un en-tte
      <code>ETag</code>, <code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code> ajoute un en-tte
      <code>If-None-Match</code>  la requte envoye au serveur
      d'origine. Lorsque la rponse originale du cache contient un en-tte
      <code>Last-Modified</code>, <code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code> ajoute un en-tte
      <code>If-Modified-Since</code>  la requte envoye au serveur
      d'origine. Dans ces deux cas, la requte devient une requte
      <strong>conditionnelle</strong>.</p>

      <p>Lorsqu'un serveur d'origine reoit une requte conditionnelle,
      il vrifie si le paramtre Etag ou Last-Modified a t modifi en
      fonction des paramtres de la requte. Si ce n'est pas le cas, il
      rpondra avec le message lapidaire "304 Not Modified". Ceci
      informe le cache que le contenu est prim mais encore  jour, et
      peut tre utilis tel quel pour les prochaines requtes jusqu' ce
      qu'il atteigne  nouveau sa date de premption.</p>

      <p>Si le contenu a t modifi, il est servi comme s'il s'agissait
      d'une requte normale et non conditionnelle.</p>

      <p>Les requtes conditionnelles offrent deux avantages. D'une
      part, il est facile de dterminer si le contenu du serveur
      d'origine correspond  celui situ
      dans le cache, et ainsi d'conomiser la consommation de ressources
      ncessaire au transfert du contenu dans son ensemble.</p>

      <p>D'autre part, un serveur d'origine bien conu sera configur de
      telle manire que les requtes conditionnelles ncessitent pour
      leur production bien moins de ressources qu'une rponse complte.
      Dans le cas des fichiers statiques, il suffit en gnral d'un
      appel systme de type <code>stat()</code> ou similaire pour
      dterminer si la taille ou la date de modification du fichier a
      t modifie. Ainsi, mme un contenu local pourra tre servi plus
      rapidement depuis le cache s'il n'a pas t modifi.</p>
      
      <p>Il serait souhaitable que tous les serveurs d'origine
      supportent les requtes conditionnelles, car dans le cas
      contraire, ils rpondent comme s'il s'agissait d'une requte
      normale, et le cache rpond comme si le contenu avait t
      modifi et enregistre ce dernier. Le cache se comporte alors
      comme un simple cache  deux tat, o le contenu est servi s'il
      est  jour, ou supprim dans le cas contraire.</p>
    

    <h3>Que peut-on mettre en cache ?</h3>
      

      <p>La liste complte des conditions ncessaires pour qu'une
      rponse puisse tre enregistre dans un cache HTTP est fournie
      dans la <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec13.html#sec13.4">section
      13.4 Response Cacheability de la RFC2616</a>, et peut se rsumer
      ainsi :</p>

      <ol>
        <li>La mise en cache doit tre active pour cette URL. Voir les
	directives <code class="directive"><a href="./mod/mod_cache.html#cacheenable">CacheEnable</a></code> et <code class="directive"><a href="./mod/mod_cache.html#cachedisable">CacheDisable</a></code>.</li>

        <li>La reponse doit avoir un code de statut HTTP de 200, 203, 300, 301
	ou 410.</li>

        <li>La requte doit tre de type HTTP GET.</li>

        <li>Si la rponse contient un en-tte "Authorization:", elle doit aussi
	contenir une option "s-maxage", "must-revalidate" ou "public"
	dans l'en-tte "Cache-Control:".</li>

        <li>Si l'URL contient une chane de requte
	(provenant par exemple d'une mthode GET de formulaire HTML), elle ne
	sera pas mise en cache,  moins que la rponse ne
	spcifie explicitement un dlai d'expiration via un
	en-tte "Expires:" ou une directive max-age ou s-maxage de
	l'en-tte "Cache-Control:" comme indiqu dans les
	sections 13.2.1. et 13.9 de la RFC2616.</li>

        <li>Si la rponse a un statut de 200 (OK), elle doit aussi contenir
	au moins un des en-ttes "Etag", "Last-Modified" ou
        "Expires", ou une directive max-age ou s-maxage de
	l'en-tte "Cache-Control:",  moins que la directive
        <code class="directive"><a href="./mod/mod_cache.html#cacheignorenolastmod">CacheIgnoreNoLastMod</a></code>
        ne prcise d'autres contraintes.</li>

        <li>Si la rponse contient l'option "private" dans un en-tte
	"Cache-Control:", elle ne sera pas mise en cache  moins que la
	directive
        <code class="directive"><a href="./mod/mod_cache.html#cachestoreprivate">CacheStorePrivate</a></code>
	ne prcise d'autres contraintes.</li>

        <li>De mme, si la rponse contient l'option "no-store" dans un en-tte
        "Cache-Control:", elle ne sera pas mise en cache  moins que la
	directive
        <code class="directive"><a href="./mod/mod_cache.html#cachestorenostore">CacheStoreNoStore</a></code>
	n'ait t utilise.</li>

        <li>Une rponse ne sera pas mise en cache si elle comporte un en-tte
	"Vary:" contenant le caractre "*" qui correspond  toute
	chane de caractres.</li>
      </ol>
    

    <h3>Qu'est ce qui ne doit pas tre mis en cache ?</h3>
      

      <p>Le client qui cre la requte ou le serveur d'origine qui
      gnre la rponse doit tre  mme de dterminer si le contenu
      doit pouvoir tre mis en cache ou non en dfinissant correctement
      l'en-tte <code>Cache-Control</code>, et
      <code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code> sera alors en mesure de satisfaire les
      souhaits du client ou du serveur de manire approprie.
      </p>

      <p>Les contenus qui varient au cours du temps, ou en fonction de
      particularits de la requte non prises en compte par la
      ngociation HTTP ne doivent pas tre mis en cache. Ce type de
      contenu doit se dclarer lui-mme " ne pas mettre en cache" via
      l'en-tte <code>Cache-Control</code>.</p>
      
      <p>Si le contenu change souvent, suite par exemple  une dure de
      fracheur de l'ordre de la minute ou de la seconde, il peut tout
      de mme tre mis en cache, mais il est alors fortement souhaitable
      que le serveur d'origine supporte correctement les
      <strong>requtes conditionnelles</strong> afin que des rponses
      compltes ne soient pas systmatiquement gnres.</p>

      <p>Un contenu qui varie en fonction d'en-ttes de requte fournis
      par le client peut tre mis en cache, sous rserve d'une
      utilisation approprie de l'en-tte de rponse <code>Vary</code>.</p>
    

    <h3>Contenu variable et/ou ngoci</h3>
      

      <p>Lorsque le serveur d'origine est configur pour servir des
      contenus diffrents en fonction de la valeur de certains en-ttes
      de la requte, par exemple pour servir une ressource en plusieurs
      langages  partir d'une seule URL, le mcanisme de mise en cache
      d'HTTP permet de mettre en cache plusieurs variantes de la mme
      page  partir d'une seule URL.</p>
      
      <p>Pour y parvenir, le serveur d'origine ajoute un en-tte
      <code>Vary</code> pour indiquer quels en-ttes doivent tre pris
      en compte par un cache pour dterminer si deux variantes sont
      diffrentes l'une de l'autre.</p>

      <p>Si par exemple, une rponse est reue avec l'en-tte Vary suivant,</p>

      <div class="example"><p><code>
Vary: negotiate,accept-language,accept-charset
      </code></p></div>

      <p><code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code> ne servira aux demandeurs que le contenu
      mis en cache qui correspond au contenu des en-ttes accept-language et
      accept-charset de la requte originale.</p>

      <p>Plusieurs variantes d'un contenu peuvent tre mises en cache
      simultanment ; <code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code> utilise l'en-tte
      <code>Vary</code> et les valeurs correspondantes des en-ttes de
      la requte spcifis dans ce dernier pour
      dterminer quelle variante doit tre servie au client.</p>
          
    

    <h3><a name="disk" id="disk">Mise en cache sur disque</a></h3>
      

      <p>Le module <code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code> s'appuie sur des
      implmentations de stockage en arrire-plan spcifiques pour grer
      le cache ;  ce titre, <code class="module"><a href="./mod/mod_cache_disk.html">mod_cache_disk</a></code> fournit le
      support de la mise en cache sur disque.</p>

      <p>En gnral, le module se configure comme suit :</p>

      <pre class="prettyprint lang-config">CacheRoot   "/var/cache/apache/"
CacheEnable disk /
CacheDirLevels 2
CacheDirLength 1</pre>


    <p>Il est important de savoir que, les fichiers mis en cache tant stocks
    localement, la mise en cache par l'intermdiaire du systme d'exploitation
    sera en gnral aussi applique  leurs accs. Si bien que mme si les
    fichiers sont stocks sur disque, s'il font l'objet d'accs frquents,
    il est probable que le systme d'exploitation s'appliquera  ce qu'ils
    soient servis  partir de la mmoire.</p>

    

    <h3>Comprendre le stockage dans le cache</h3>
      

      <p>Pour stocker des entits dans le cache,
      le module <code class="module"><a href="./mod/mod_cache_disk.html">mod_cache_disk</a></code> cre une empreinte (hash) de 22
      caractres de l'URL qui a fait l'objet d'une requte. Cette empreinte
      comprend le nom d'hte, le protocole, le port, le chemin et tout argument
      de type CGI associ  l'URL, ainsi que les lments
      spcifis dans l'en-tte Vary afin d'tre sur que plusieurs URLs
      n'interfrent pas entre elles.</p>

      <p>Chaque position de l'empreinte peut contenir un caractre
      choisi parmi 64 caractres diffrents, il y a donc
      64^22 possibilits pour une empreinte. Par exemple, une URL peut possder
      l'empreinte <code>xyTGxSMO2b68mBCykqkp1w</code>. Cette empreinte est
      utilise pour prfixer les noms de fichiers spcifiques  cette URL 
      l'intrieur du cache; cependant, elle est tout d'abord place dans les
      rpertoires du cache selon les directives
      <code class="directive"><a href="./mod/mod_cache_disk.html#cachedirlevels">CacheDirLevels</a></code> et
      <code class="directive"><a href="./mod/mod_cache_disk.html#cachedirlength">CacheDirLength</a></code>.</p>

      <p>La directive
      <code class="directive"><a href="./mod/mod_cache_disk.html#cachedirlevels">CacheDirLevels</a></code>
      dfinit le nombre de niveaux de sous-rpertoires, et
      <code class="directive"><a href="./mod/mod_cache_disk.html#cachedirlength">CacheDirLength</a></code>
      le nombre de caractres composant le nom des sous-rpertoires. Dans
      l'exemple donn plus haut, l'empreinte se trouvera  :
      <code>/var/cache/apache/x/y/TGxSMO2b68mBCykqkp1w</code>.</p>

      <p>Cette technique a pour but principal de rduire le nombre de
      sous-rpertoires ou de fichiers contenus dans un rpertoire particulier,
      car le fonctionnement de la plupart des systmes de fichiers est ralenti
      quand ce nombre augmente. Avec la valeur "1" pour la directive
      <code class="directive"><a href="./mod/mod_cache_disk.html#cachedirlength">CacheDirLength</a></code>,
      il peut y avoir au plus 64 sous-rpertoires  un niveau quelconque.
      Avec la valeur "2", il peut y en avoir 64 * 64, etc...
      A moins d'avoir une bonne raison pour ne pas le faire, l'utilisation de
      la valeur "1" pour la directive
      <code class="directive"><a href="./mod/mod_cache_disk.html#cachedirlength">CacheDirLength</a></code>
      est recommande.</p>

      <p>Le paramtrage de la directive
      <code class="directive"><a href="./mod/mod_cache_disk.html#cachedirlevels">CacheDirLevels</a></code>
      dpend du nombre de fichiers que vous pensez stocker dans le cache.
      Avec une valeur de "2" comme dans l'exemple donn plus haut,
      4096 sous-rpertoires peuvent tre crs au total. Avec 1 million de
      fichiers dans le cache, cela quivaut  environ 245 URLs mises en cache
      dans chaque rpertoire.</p>

      <p>Chaque URL ncessite au moins deux fichiers dans le cache. Ce sont en
      gnral un fichier ".header", qui contient des meta-informations  propos
      de l'URL, comme la date de son arrive  expiration,
      et un fichier ".data" qui est la copie exacte du contenu  servir.</p>

      <p>Dans le cas d'un contenu ngoci via l'en-tte "Vary", un rpertoire
      ".vary" sera cr pour l'URL en question. Ce rpertoire contiendra de
      multiples fichiers ".data" correspondant aux diffrents contenus
      ngocis.</p>
    

    <h3>Maintenance du cache sur disque</h3>
      

      <p>Le module <code class="module"><a href="./mod/mod_cache_disk.html">mod_cache_disk</a></code> n'effectue aucune
      rgulation de l'espace disque utilis par le cache, mais s'il
      s'arrte en douceur en cas d'erreur disque et se comporte alors
      comme si le cache n'avait jamais exist.</p>

      <p>Par contre l'utilitaire
      <a href="programs/htcacheclean.html">htcacheclean</a> fourni avec
      httpd
      vous permet de nettoyer le cache priodiquement.
      Dterminer la frquence  laquelle lancer <a href="programs/htcacheclean.html">htcacheclean</a> et la taille souhaite
      pour le cache est une tche relativement complexe et il vous faudra de
      nombreux essais et erreurs pour arriver  slectionner des valeurs
      optimales.</p>

      <p><a href="programs/htcacheclean.html">htcacheclean</a> opre selon deux
      modes. Il peut s'excuter comme dmon rsident, ou tre lanc
      priodiquement par cron. <a href="programs/htcacheclean.html">htcacheclean</a> peut mettre une heure
      ou plus pour traiter de trs grands caches (plusieurs dizaines de
      Gigaoctets) et si vous l'excutez  partir de cron, il vous est
      conseill de dterminer la dure typique d'un traitement, afin d'viter
      d'excuter plusieurs instances  la fois.</p>

      <p>Il est aussi conseill d'attribuer un niveau de priorit "nice"
      appropri  htcacheclean de faon  ce qu'il n'effectue pas trop
      d'accs disque pendant le fonctionnement du serveur.</p>

      <p class="figure">
      <img src="images/caching_fig1.gif" alt="" width="600" height="406" /><br />
      <a id="figure1" name="figure1"><dfn>Figure 1</dfn></a>: Croissance
      typique du cache / squence de nettoyage.</p>

      <p>Comme <code class="module"><a href="./mod/mod_cache_disk.html">mod_cache_disk</a></code> ne tient pas compte de l'espace
      utilis dans le cache, vous devez vous assurer que
      <a href="programs/htcacheclean.html">htcacheclean</a> est configur de
      faon  laisser suffisamment d'"espace de croissance"
       la suite d'un nettoyage.</p>
    

  </div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="socache-caching" id="socache-caching">Mise en cache d'objets partags  deux tats de forme
    cl/valeur</a></h2>

    

    <table class="related"><tr><th>Modules Apparents</th><th>Directives Apparentes</th></tr><tr><td><ul><li><code class="module"><a href="./mod/mod_authn_socache.html">mod_authn_socache</a></code></li><li><code class="module"><a href="./mod/mod_socache_dbm.html">mod_socache_dbm</a></code></li><li><code class="module"><a href="./mod/mod_socache_dc.html">mod_socache_dc</a></code></li><li><code class="module"><a href="./mod/mod_socache_memcache.html">mod_socache_memcache</a></code></li><li><code class="module"><a href="./mod/mod_socache_shmcb.html">mod_socache_shmcb</a></code></li><li><code class="module"><a href="./mod/mod_ssl.html">mod_ssl</a></code></li></ul></td><td><ul><li><code class="directive"><a href="./mod/mod_authn_socache.html#authncachesocache">AuthnCacheSOCache</a></code></li><li><code class="directive"><a href="./mod/mod_ssl.html#sslsessioncache">SSLSessionCache</a></code></li><li><code class="directive"><a href="./mod/mod_ssl.html#sslstaplingcache">SSLStaplingCache</a></code></li></ul></td></tr></table>
    
    <p>Le serveur HTTP Apache fournit un cache d'objets partags de bas
    niveau pour la mise en cache d'informations comme les sessions SSL
    ou les donnes d'authentification dans l'interface <a href="socache.html">socache</a>.</p>

    <p>Pour chaque implmentation un module supplmentaire est fourni
    qui offre les services d'arrire-plan suivants :</p>

    <dl>
    <dt><code class="module"><a href="./mod/mod_socache_dbm.html">mod_socache_dbm</a></code></dt>
    <dd>Cache d'objets partags bas sur DBM.</dd>
    <dt><code class="module"><a href="./mod/mod_socache_dc.html">mod_socache_dc</a></code></dt>
    <dd>Cache d'objets partags bas sur Distcache.</dd>
    <dt><code class="module"><a href="./mod/mod_socache_memcache.html">mod_socache_memcache</a></code></dt>
    <dd>Cache d'objets partags bas sur Memcache.</dd>
    <dt><code class="module"><a href="./mod/mod_socache_shmcb.html">mod_socache_shmcb</a></code></dt>
    <dd>Cache d'objets partags bas sur la mmoire partage.</dd>
    </dl>

    <h3><a name="mod_authn_socache-caching" id="mod_authn_socache-caching">Mise en cache des donnes d'authentification</a></h3>
      

      <table class="related"><tr><th>Modules Apparents</th><th>Directives Apparentes</th></tr><tr><td><ul><li><code class="module"><a href="./mod/mod_authn_socache.html">mod_authn_socache</a></code></li></ul></td><td><ul><li><code class="directive"><a href="./mod/mod_authn_socache.html#authncachesocache">AuthnCacheSOCache</a></code></li></ul></td></tr></table>

      <p>Le module <code class="module"><a href="./mod/mod_authn_socache.html">mod_authn_socache</a></code> permet la mise en
      cache des donnes issues d'une authentification, diminuant ainsi
      la charge des serveurs d'authentification en arrire-plan.</p>

    

    <h3><a name="mod_ssl-caching" id="mod_ssl-caching">Mise en cache des sessions SSL</a></h3>
      

      <table class="related"><tr><th>Modules Apparents</th><th>Directives Apparentes</th></tr><tr><td><ul><li><code class="module"><a href="./mod/mod_ssl.html">mod_ssl</a></code></li></ul></td><td><ul><li><code class="directive"><a href="./mod/mod_ssl.html#sslsessioncache">SSLSessionCache</a></code></li><li><code class="directive"><a href="./mod/mod_ssl.html#sslstaplingcache">SSLStaplingCache</a></code></li></ul></td></tr></table>

      <p>Le module <code class="module"><a href="./mod/mod_ssl.html">mod_ssl</a></code> utilise l'interface
      <code>socache</code> pour fournir un cache de session et un cache
      de base.</p>

    

  </div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="file-caching" id="file-caching">Mise en cache  base de fichiers spcialiss</a></h2>

    

    <table class="related"><tr><th>Modules Apparents</th><th>Directives Apparentes</th></tr><tr><td><ul><li><code class="module"><a href="./mod/mod_file_cache.html">mod_file_cache</a></code></li></ul></td><td><ul><li><code class="directive"><a href="./mod/mod_file_cache.html#cachefile">CacheFile</a></code></li><li><code class="directive"><a href="./mod/mod_file_cache.html#mmapfile">MMapFile</a></code></li></ul></td></tr></table>

    <p>Sur les plateformes o le systme de fichiers peut tre lent, ou
    lorsque les descripteurs de fichiers sont gourmands en ressources,
    il est possible de prcharger des fichiers en mmoire au dmarrage
    du serveur.</p>

    <p>Sur les systmes o l'ouverture des fichiers est lente, il est
    possible d'ouvrir le fichier au dmarrage du serveur et de mettre en
    cache le descripteur de fichier. Ces options peuvent vous aider sur
    les systmes o l'accs aux fichiers statiques est lent.</p>

    <h3><a name="filehandle" id="filehandle">Mise en cache des descripteurs de fichier</a></h3>
      

      <p>Le processus d'ouverture d'un fichier peut tre en soi une
      source de ralentissement, en particulier sur les systmes de
      fichiers sur le rseau. httpd permet d'viter ce ralentissement en
      maintenant un cache des descripteurs de fichiers ouverts pour les
      fichiers souvent servis. Actuellement, httpd fournit une seule
      implmentation de mise en cache des descripteurs de fichiers.</p>

      <h4>CacheFile</h4>
        

        <p>La forme la plus basique de mise en cache que propose httpd
	est la mise en cache des descripteurs de fichiers fournie par le
	module <code class="module"><a href="./mod/mod_file_cache.html">mod_file_cache</a></code>. Plutt que de mettre en
	cache le contenu des fichiers, ce cache maintient une table des
	descripteurs de fichiers ouverts. Les fichiers devant faire
	l'objet d'une mise en cache de ce type sont spcifis dans le
	fichier de configuration via la directive <code class="directive"><a href="./mod/mod_file_cache.html#cachefile">CacheFile</a></code>.</p>

        <p>La directive <code class="directive"><a href="./mod/mod_file_cache.html#cachefile">CacheFile</a></code> informe httpd
	qu'il doit ouvrir le fichier lors de son dmarrage et qu'il doit
	rutiliser le descripteur de fichier mis en cache pour tous les
	accs futurs  ce fichier.</p>

        <pre class="prettyprint lang-config">CacheFile /usr/local/apache2/htdocs/index.html</pre>


        <p>Si vous dsirez mettre en cache un grand nombre de fichiers
	de cette manire, vous devez vous assurer que le nombre maximal
	de fichiers ouverts pour votre systme d'exploitation est dfini
	 une valeur suffisante.</p>

        <p>Bien que l'utilisation de la directive <code class="directive"><a href="./mod/mod_file_cache.html#cachefile">CacheFile</a></code> n'entrane pas de
	mise en cache du contenu du fichier proprement dit, elle
	implique que si le fichier est modifi pendant l'excution du
	serveur, ces modifications ne seront pas prises en compte. Le
	fichier sera toujours servi dans l'tat o il se trouvait au
	moment du dmarrage du serveur.</p>

        <p>Si le fichier est supprim pendant l'excution du serveur, ce
	dernier conservera le descripteur de fichier ouvert associ et
	servira le fichier dans l'tat o il se trouvait au
	moment du dmarrage du serveur. Cela signifie aussi que mme si
	le fichier a t supprim, et n'apparat donc plus dans le
	systme de fichiers, l'espace disque libr ne sera disponible
	qu'une fois le serveur httpd arrt et donc le descripteur de
	fichier ferm.</p>
      

    

    <h3><a name="inmemory" id="inmemory">In-Memory Caching</a></h3>
      

    <p>Servir un contenu directement depuis la mmoire systme est
    universellement reconnu comme la mthode la plus rapide. Lire des fichiers
    depuis un contrleur de disque ou pire, depuis un rseau distant est plus
    lent de plusieurs ordres de grandeur. Les contrleurs de disque ralisent
    en gnral des oprations mcaniques, et l'accs au rseau est limit par la
    bande passante dont vous disposez. Par contre, les temps d'accs  la
    mmoire sont de l'ordre de la nano-seconde.</p>

    <p>Cependant la mmoire systme n'est pas bon march;  capacit gale,
    c'est de loin le type de stockage le plus coteux et il est important de
    s'assurer qu'elle est utilise efficacement. Le fait de mettre en cache
    des fichiers en mmoire diminue d'autant la quantit de mmoire systme
    disponible. Comme nous le verrons plus loin, ce n'est pas un problme en
    soi dans le cas de la mise en cache par l'intermdiaire du systme
    d'exploitation, mais si l'on utilise la mise en cache en mmoire propre 
    httpd, il faut prendre garde  ne pas allouer trop de mmoire au cache.
    Sinon le systme sera contraint d'utiliser le swap, ce qui dgradera
    sensiblement les performances.</p>

      <h4>Mise en cache par l'intermdiaire du systme d'exploitation</h4>
      

      <p>Dans la plupart des systmes d'exploitation modernes, c'est le noyau
      qui gre directement la mise en cache en mmoire des donnes relatives
      aux fichiers. C'est une fonctionnalit puissante, et les systmes
      d'exploitation s'en acquittent fort bien pour la plus grande partie.
      Considrons par exemple, dans le cas de Linux, la diffrence entre le
      temps ncessaire  la premire lecture d'un fichier et le temps
      ncessaire  sa deuxime lecture;</p>

        <div class="example"><pre>colm@coroebus:~$ time cat testfile &gt; /dev/null
real    0m0.065s
user    0m0.000s
sys     0m0.001s
colm@coroebus:~$ time cat testfile &gt; /dev/null
real    0m0.003s
user    0m0.003s
sys     0m0.000s</pre></div>

      <p>Mme pour ce petit fichier, il y a une grande diffrence entre les
      temps ncessaires pour lire le fichier. Ceci est du au fait que le
      noyau a mis en cache le contenu du fichier en mmoire.</p>

      <p>Du fait de toujours pouvoir disposer de mmoire systme, vous pouvez
      tre assur qu'il y aura de plus en plus de contenus de fichiers stocks
      dans ce cache. Ceci peut s'avrer une mthode de mise en cache en mmoire
      trs efficace, et ne ncessite aucune configuration supplmentaire
      de httpd.</p>

      <p>De plus, comme le systme d'exploitation sait si des fichiers
      ont t
      supprims ou modifis, il peut effacer automatiquement des contenus de
      fichiers du cache lorsque cela s'avre ncessaire. Ceci constitue un gros
      avantage par rapport  la mise en cache en mmoire
      de httpd qui n'a
      aucune possibilit de savoir si un fichier a t modifi.</p>
      

    <p>En dpit des performances et des avantages de la mise en cache
    automatique par le systme d'exploitation, la mise en cache en mmoire
    peut tre effectue plus efficacement par httpd dans certaines
    circonstances.</p>

    <h4>Mise en cache  l'aide de la directive MMapFile</h4>
      

      <p>La directive <code class="directive"><a href="./mod/mod_file_cache.html#mmapfile">MMapFile</a></code>
      fournie par le module <code class="module"><a href="./mod/mod_file_cache.html">mod_file_cache</a></code> vous permet de
      demander  httpd de charger un contenu de fichier statique en mmoire
      lors de son dmarrage ( l'aide de l'appel
      systme mmap). httpd
      utilisera le contenu charg en mmoire pour satisfaire ultrieurement
      toutes les demandes d'accs  ce fichier.</p>

        <pre class="prettyprint lang-config">MMapFile /usr/local/apache2/htdocs/index.html</pre>


      <p>Comme dans le cas de la directive
      <code class="directive"><a href="./mod/mod_file_cache.html#cachefile">CacheFile</a></code>, toute
      modification du fichier ne sera plus prise en compte par httpd une fois
      ce dernier dmarr.</p>

      <p> La directive
      <code class="directive"><a href="./mod/mod_file_cache.html#mmapfile">MMapFile</a></code> ne gardant
      pas la trace de la quantit de mmoire qu'elle alloue, vous devez prendre
      garde de ne pas en abuser. Chaque processus enfant de httpd utilisant
      sa propre rplique de la mmoire alloue, il est donc d'une importance
      critique de s'assurer que les fichiers chargs ne sont pas d'une taille
      trop importante afin d'pargner au systme l'utilisation du swap.</p>
      
    

  </div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="security" id="security">Considrations sur la scurit</a></h2>
    

    <h3>Autorisation et contrle d'accs</h3>
      

      <p>Utiliser <code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code> revient sensiblement  la mme
      chose qu'avoir un mandataire inverse intgr (reverse-proxy). Les requtes
      seront servies par le module de mise en cache sauf si ce dernier
      dtermine qu'un processus d'arrire-plan doit tre appel. La mise en
      cache de ressources locales modifie considrablement le modle de
      scurit de httpd.</p>

      <p>Comme le parcours de la hirarchie d'un systme de fichiers pour
      examiner le contenu d'ventuels fichiers
      <code>.htaccess</code> serait une opration trs coteuse en ressources,
      annulant partiellement de ce fait l'intrt de la mise en cache
      (acclrer le traitement des requtes),
      <code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code> ne se proccupe pas de savoir s'il a
      l'autorisation de servir une entit mise en cache. En d'autres termes,
      si <code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code> a mis en cache un certain contenu, ce
      dernier sera servi  partir du cache tant qu'il ne sera pas arriv 
      expiration.</p>

      <p>Si par exemple, votre configuration autorise l'accs  une ressource
      en fonction de l'adresse IP, vous devez vous assurer que ce contenu n'est
      pas mis en cache. Ceci est possible en utilisant la directive
      <code class="directive"><a href="./mod/mod_cache.html#cachedisable">CacheDisable</a></code>, ou le module
      <code class="module"><a href="./mod/mod_expires.html">mod_expires</a></code>. Livr  lui-mme,
      <code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code> - pratiquement comme un mandataire inverse -
      mettrait en cache le contenu lors de son service, et le servirait ensuite
       tout client, vers n'importe quelle adresse IP.</p>

      <p>Lorsque la directive <code class="directive"><a href="./mod/mod_cache.html#cachequickhandler">CacheQuickHandler</a></code> est dfinie 
      <code>Off</code>, toutes les phases du traitement de la requte
      sont excutes et le modle de scurit reste le mme.</p>

    

    <h3>Piratages locaux</h3>
      

      <p>Etant donn que les requtes des utilisateurs finaux peuvent tre
      servies depuis le cache, ce dernier est une cible potentielle pour ceux
      qui veulent dfigurer un contenu ou interfrer avec lui. Il est important
      de garder  l'esprit que l'utilisateur sous lequel tourne
      httpd doit
      toujours avoir l'accs en criture dans le cache. Ceci est en contraste
      total avec la recommandation usuelle d'interdire  l'utilisateur sous
      lequel tourne Apache
      l'accs en criture  tout contenu.</p>

      <p>Si l'utilisateur sous lequel tourne Apache est compromis,
      par exemple  cause d'une
      faille de scurit dans un processus CGI, il est possible que le cache
      fasse l'objet d'une attaque. Il est relativement ais d'insrer ou de
      modifier une entit dans le cache en utilisant le module
      <code class="module"><a href="./mod/mod_cache_disk.html">mod_cache_disk</a></code>.</p>

      <p>Cela reprsente un risque relativement lv par rapport aux autres
      types d'attaques qu'il est possible de mener sous l'utilisateur apache.
      Si vous utilisez <code class="module"><a href="./mod/mod_cache_disk.html">mod_cache_disk</a></code>, vous devez garder ceci
       l'esprit : effectuez toujours les mises  jour de
      httpdquand des
      correctifs de scurit sont annoncs et excutez les processus CGI sous
      un utilisateur autre qu'apache en utilisant
      <a href="suexec.html">suEXEC</a> dans la mesure du possible.</p>

    

    <h3>Empoisonnement du cache (Cache Poisoning)</h3>
      

      <p>Si vous utilisez httpd comme serveur mandataire avec mise en cache,
      vous vous exposez aussi  un ventuel "Empoisonnement du
      cache" (Cache poisoning). L'empoisonnement du cache est un terme gnral
      pour dsigner les attaques au cours desquelles l'attaquant fait en sorte
      que le serveur mandataire renvoie  un contenu incorrect (et souvent
      indsirable) suite  en provenance du serveur d'arrire-plan.
      </p>

      <p>Par exemple, si les serveur DNS qu'utilise votre systme o tourne
      httpd sont vulnrables  l'empoisonnement du cache des DNS, un attaquant
      pourra contrler vers o httpd se connecte lorsqu'il demande un contenu
      depuis le serveur d'origine.
      Un autre exemple est constitu par les attaques ainsi nommes
      "Dissimulation de requtes HTTP" (HTTP request-smuggling).</p>

      <p>Ce document n'est pas le bon endroit pour une discussion approfondie
       propos de la Dissimulation de requtes HTTP (utilisez plutt votre
      moteur de recherche favori); il est cependant important de savoir qu'il
      est possible d'laborer une srie de requtes, et d'exploiter une
      vulnrabilit d'un serveur web d'origine de telle faon que l'attaquant
      puisse contrler entirement le contenu renvoy par le mandataire.</p>
    

    <h3>Dni de Service / Cachebusting</h3>
      

      <p>Le mcanisme utilis via l'en-tte Vary permet de mettre en
      cache simultanment plusieurs variantes d'une ressource avec la
      mme URL. Le cache slectionne la variante correcte  envoyer au
      client en fonction des valeurs d'en-tte fournies par ce dernier.
      Ce mcanisme peut devenir un problme lorsqu'on tente d'appliquer
      le mcanisme des variantes  un en-tte connu pour pouvoir
      possder un grand nombre de valeurs
      possibles en utilisation normal, comme par exemple l'en-tte
      <code>User-Agent</code>. En fonction de la popularit du site web,
      des milliers ou mme des millions d'entres de cache dupliques
      peuvent tre cres pour la mme URL, submergeant les autres
      entres du cache.</p>
      
      <p>Dans d'autres cas, il peut tre ncessaire de modifier l'URL
      d'une ressource particulire  chaque requte, en gnral en lui
      ajoutant une chane "cachebuster". Si ce contenu est dclar comme
      pouvant tre mis en cache par un serveur avec une dure de
      fracheur significative, ces entres peuvent submerger les entres
      lgitimes du cache. Alors que <code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code> fournit
      une directive <code class="directive"><a href="./mod/mod_cache.html#cacheignoreurlsessionidentifiers">CacheIgnoreURLSessionIdentifiers</a></code>,
      cette dernire doit tre utilise avec prudence pour s'assurer que
      les caches du navigateur ou du mandataire le plus proche
      (downstream proxy) ne sont pas victimes du mme problme de Dni de
      service.</p>
    
  </div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="./en/caching.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./fr/caching.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./tr/caching.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="./images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/caching.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2016 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="./mod/">Modules</a> | <a href="./mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="./glossary.html">Glossaire</a> | <a href="./sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>