/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.util.HashMap;
import java.util.Map;
import org.armedbear.lisp.Bignum;
import org.armedbear.lisp.DoubleFloat;
import org.armedbear.lisp.Environment;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Function;
import org.armedbear.lisp.JavaClassLoader;
import org.armedbear.lisp.JavaObject;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispCharacter;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispInteger;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SingleFloat;
import org.armedbear.lisp.WrongNumberOfArgumentsException;

public class RuntimeClass {
    static Map<String, RuntimeClass> classes = new HashMap<String, RuntimeClass>();
    private Map<String, Function> methods = new HashMap<String, Function>();
    private static final Primitive _JNEW_RUNTIME_CLASS = new Primitive("%jnew-runtime-class", Lisp.PACKAGE_JAVA, false, "class-name &rest method-names-and-defs"){

        public LispObject execute(LispObject[] args) {
            int length = args.length;
            if (length < 3 || length % 2 != 1) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            RuntimeClass rc = new RuntimeClass();
            String className = args[0].getStringValue();
            for (int i = 1; i < length; i += 2) {
                String methodName = args[i].getStringValue();
                rc.addLispMethod(methodName, (Function)args[i + 1]);
            }
            classes.put(className, rc);
            return Lisp.T;
        }
    };
    private static final Primitive _JREDEFINE_METHOD = new Primitive("%jredefine-method", Lisp.PACKAGE_JAVA, false, "class-name method-name method-def"){

        public LispObject execute(LispObject className, LispObject methodName, LispObject methodDef) {
            String cn = className.getStringValue();
            String mn = methodName.getStringValue();
            Function def = (Function)methodDef;
            RuntimeClass rc = null;
            if (classes.containsKey(cn)) {
                rc = classes.get(cn);
                rc.addLispMethod(mn, def);
                return Lisp.T;
            }
            Lisp.error(new LispError("undefined Java class: " + cn));
            return Lisp.NIL;
        }
    };
    private static final Primitive _LOAD_JAVA_CLASS_FROM_BYTE_ARRAY = new Primitive("%load-java-class-from-byte-array", Lisp.PACKAGE_JAVA, false, "classname bytearray"){

        public LispObject execute(LispObject className, LispObject classBytes) {
            String cn = className.getStringValue();
            String pn = cn.substring(0, cn.lastIndexOf(46));
            byte[] cb = (byte[])classBytes.javaInstance();
            try {
                JavaClassLoader loader = JavaClassLoader.getPersistentInstance(pn);
                Class<?> c = loader.loadClassFromByteArray(cn, cb);
                if (c != null) {
                    return Lisp.T;
                }
            }
            catch (VerifyError e) {
                return Lisp.error(new LispError("class verification failed: " + e.getMessage()));
            }
            catch (LinkageError e) {
                return Lisp.error(new LispError("class could not be linked: " + e.getMessage()));
            }
            return Lisp.error(new LispError("unable to load ".concat(cn)));
        }
    };

    public static final LispObject evalC(LispObject function, LispObject args, Environment env, LispThread thread) {
        return Lisp.evalCall(function, args, env, thread);
    }

    public static RuntimeClass getRuntimeClass(String className) {
        return classes.get(className);
    }

    public Function getLispMethod(String methodName) {
        return this.methods.get(methodName);
    }

    void addLispMethod(String methodName, Function def) {
        this.methods.put(methodName, def);
    }

    public static final LispObject makeLispObject(Object obj) {
        return new JavaObject(obj);
    }

    public static final Fixnum makeLispObject(byte i) {
        return Fixnum.getInstance(i);
    }

    public static final Fixnum makeLispObject(short i) {
        return Fixnum.getInstance(i);
    }

    public static final Fixnum makeLispObject(int i) {
        return Fixnum.getInstance(i);
    }

    public static final LispInteger makeLispObject(long i) {
        return Bignum.getInstance(i);
    }

    public static final SingleFloat makeLispObject(float i) {
        return new SingleFloat(i);
    }

    public static final DoubleFloat makeLispObject(double i) {
        return new DoubleFloat(i);
    }

    public static final LispCharacter makeLispObject(char i) {
        return LispCharacter.getInstance(i);
    }

    public static final LispObject makeLispObject(boolean i) {
        return i ? Lisp.T : Lisp.NIL;
    }
}

