/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.math.BigInteger;
import org.armedbear.lisp.ArithmeticError;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Complex;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.DivisionByZero;
import org.armedbear.lisp.DoubleFloat;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispClass;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispInteger;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Ratio;
import org.armedbear.lisp.SingleFloat;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

public final class Bignum
extends LispInteger {
    public final BigInteger value;
    private static BigInteger MOST_NEGATIVE_FIXNUM = BigInteger.valueOf(Integer.MIN_VALUE);
    private static BigInteger MOST_POSITIVE_FIXNUM = BigInteger.valueOf(Integer.MAX_VALUE);

    public static LispInteger getInstance(long l) {
        if (Integer.MIN_VALUE <= l && l <= Integer.MAX_VALUE) {
            return Fixnum.getInstance(l);
        }
        return new Bignum(l);
    }

    public static LispInteger getInstance(BigInteger n) {
        if (MOST_NEGATIVE_FIXNUM.compareTo(n) < 0 || MOST_POSITIVE_FIXNUM.compareTo(n) > 0) {
            return new Bignum(n);
        }
        return Fixnum.getInstance(n.intValue());
    }

    public static LispInteger getInstance(String s, int radix) {
        BigInteger value = new BigInteger(s, radix);
        return Bignum.getInstance(value);
    }

    private Bignum(long l) {
        this.value = BigInteger.valueOf(l);
    }

    private Bignum(BigInteger n) {
        this.value = n;
    }

    public Object javaInstance() {
        return this.value;
    }

    public Object javaInstance(Class c) {
        String cn = c.getName();
        if (cn.equals("java.lang.Byte") || cn.equals("byte")) {
            return (byte)this.value.intValue();
        }
        if (cn.equals("java.lang.Short") || cn.equals("short")) {
            return (short)this.value.intValue();
        }
        if (cn.equals("java.lang.Integer") || cn.equals("int")) {
            return this.value.intValue();
        }
        if (cn.equals("java.lang.Long") || cn.equals("long")) {
            return this.value.longValue();
        }
        return this.javaInstance();
    }

    public LispObject typeOf() {
        if (this.value.signum() > 0) {
            return Lisp.list(Symbol.INTEGER, new Bignum(0x80000000L));
        }
        return Symbol.BIGNUM;
    }

    public LispObject classOf() {
        return BuiltInClass.BIGNUM;
    }

    public LispObject typep(LispObject type) {
        if (type instanceof Symbol) {
            if (type == Symbol.BIGNUM) {
                return Lisp.T;
            }
            if (type == Symbol.INTEGER) {
                return Lisp.T;
            }
            if (type == Symbol.RATIONAL) {
                return Lisp.T;
            }
            if (type == Symbol.REAL) {
                return Lisp.T;
            }
            if (type == Symbol.NUMBER) {
                return Lisp.T;
            }
            if (type == Symbol.SIGNED_BYTE) {
                return Lisp.T;
            }
            if (type == Symbol.UNSIGNED_BYTE) {
                return this.value.signum() >= 0 ? Lisp.T : Lisp.NIL;
            }
        } else if (type instanceof LispClass) {
            if (type == BuiltInClass.BIGNUM) {
                return Lisp.T;
            }
            if (type == BuiltInClass.INTEGER) {
                return Lisp.T;
            }
            if (type == BuiltInClass.RATIONAL) {
                return Lisp.T;
            }
            if (type == BuiltInClass.REAL) {
                return Lisp.T;
            }
            if (type == BuiltInClass.NUMBER) {
                return Lisp.T;
            }
        } else if (type instanceof Cons) {
            if (type.equal(Lisp.UNSIGNED_BYTE_8)) {
                return Lisp.NIL;
            }
            if (type.equal(Lisp.UNSIGNED_BYTE_32)) {
                if (this.minusp()) {
                    return Lisp.NIL;
                }
                return this.isLessThan(Lisp.UNSIGNED_BYTE_32_MAX_VALUE) ? Lisp.T : Lisp.NIL;
            }
        }
        return super.typep(type);
    }

    public boolean numberp() {
        return true;
    }

    public boolean integerp() {
        return true;
    }

    public boolean rationalp() {
        return true;
    }

    public boolean realp() {
        return true;
    }

    public boolean eql(LispObject obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof Bignum && this.value.equals(((Bignum)obj).value);
    }

    public boolean equal(LispObject obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof Bignum && this.value.equals(((Bignum)obj).value);
    }

    public boolean equalp(LispObject obj) {
        if (obj != null && obj.numberp()) {
            return this.isEqualTo(obj);
        }
        return false;
    }

    public LispObject ABS() {
        if (this.value.signum() >= 0) {
            return this;
        }
        return new Bignum(this.value.negate());
    }

    public LispObject NUMERATOR() {
        return this;
    }

    public LispObject DENOMINATOR() {
        return Fixnum.ONE;
    }

    public boolean evenp() {
        return !this.value.testBit(0);
    }

    public boolean oddp() {
        return this.value.testBit(0);
    }

    public boolean plusp() {
        return this.value.signum() > 0;
    }

    public boolean minusp() {
        return this.value.signum() < 0;
    }

    public boolean zerop() {
        return false;
    }

    public int intValue() {
        return this.value.intValue();
    }

    public long longValue() {
        return this.value.longValue();
    }

    public float floatValue() {
        float f = this.value.floatValue();
        if (Float.isInfinite(f)) {
            Lisp.error(new TypeError("The value " + this.princToString() + " is too large to be converted to a single float."));
        }
        return f;
    }

    public double doubleValue() {
        double d = this.value.doubleValue();
        if (Double.isInfinite(d)) {
            Lisp.error(new TypeError("The value " + this.princToString() + " is too large to be converted to a double float."));
        }
        return d;
    }

    public static BigInteger getValue(LispObject obj) {
        if (obj instanceof Bignum) {
            return ((Bignum)obj).value;
        }
        Lisp.type_error(obj, Symbol.BIGNUM);
        return null;
    }

    public final LispObject incr() {
        return Lisp.number(this.value.add(BigInteger.ONE));
    }

    public final LispObject decr() {
        return Lisp.number(this.value.subtract(BigInteger.ONE));
    }

    public LispObject add(int n) {
        return Lisp.number(this.value.add(BigInteger.valueOf(n)));
    }

    public LispObject add(LispObject obj) {
        if (obj instanceof Fixnum) {
            return Lisp.number(this.value.add(Fixnum.getBigInteger(obj)));
        }
        if (obj instanceof Bignum) {
            return Lisp.number(this.value.add(((Bignum)obj).value));
        }
        if (obj instanceof Ratio) {
            BigInteger numerator = ((Ratio)obj).numerator();
            BigInteger denominator = ((Ratio)obj).denominator();
            return Lisp.number(this.value.multiply(denominator).add(numerator), denominator);
        }
        if (obj instanceof SingleFloat) {
            return new SingleFloat(this.floatValue() + ((SingleFloat)obj).value);
        }
        if (obj instanceof DoubleFloat) {
            return new DoubleFloat(this.doubleValue() + ((DoubleFloat)obj).value);
        }
        if (obj instanceof Complex) {
            Complex c = (Complex)obj;
            return Complex.getInstance(this.add(c.getRealPart()), c.getImaginaryPart());
        }
        return Lisp.type_error(obj, Symbol.NUMBER);
    }

    public LispObject subtract(LispObject obj) {
        if (obj instanceof Fixnum) {
            return Lisp.number(this.value.subtract(Fixnum.getBigInteger(obj)));
        }
        if (obj instanceof Bignum) {
            return Lisp.number(this.value.subtract(((Bignum)obj).value));
        }
        if (obj instanceof Ratio) {
            BigInteger numerator = ((Ratio)obj).numerator();
            BigInteger denominator = ((Ratio)obj).denominator();
            return Lisp.number(this.value.multiply(denominator).subtract(numerator), denominator);
        }
        if (obj instanceof SingleFloat) {
            return new SingleFloat(this.floatValue() - ((SingleFloat)obj).value);
        }
        if (obj instanceof DoubleFloat) {
            return new DoubleFloat(this.doubleValue() - ((DoubleFloat)obj).value);
        }
        if (obj instanceof Complex) {
            Complex c = (Complex)obj;
            return Complex.getInstance(this.subtract(c.getRealPart()), Fixnum.ZERO.subtract(c.getImaginaryPart()));
        }
        return Lisp.type_error(obj, Symbol.NUMBER);
    }

    public LispObject multiplyBy(int n) {
        if (n == 0) {
            return Fixnum.ZERO;
        }
        if (n == 1) {
            return this;
        }
        return new Bignum(this.value.multiply(BigInteger.valueOf(n)));
    }

    public LispObject multiplyBy(LispObject obj) {
        if (obj instanceof Fixnum) {
            int n = ((Fixnum)obj).value;
            if (n == 0) {
                return Fixnum.ZERO;
            }
            if (n == 1) {
                return this;
            }
            return new Bignum(this.value.multiply(BigInteger.valueOf(n)));
        }
        if (obj instanceof Bignum) {
            return new Bignum(this.value.multiply(((Bignum)obj).value));
        }
        if (obj instanceof Ratio) {
            BigInteger n = ((Ratio)obj).numerator();
            return Lisp.number(n.multiply(this.value), ((Ratio)obj).denominator());
        }
        if (obj instanceof SingleFloat) {
            return new SingleFloat(this.floatValue() * ((SingleFloat)obj).value);
        }
        if (obj instanceof DoubleFloat) {
            return new DoubleFloat(this.doubleValue() * ((DoubleFloat)obj).value);
        }
        if (obj instanceof Complex) {
            Complex c = (Complex)obj;
            return Complex.getInstance(this.multiplyBy(c.getRealPart()), this.multiplyBy(c.getImaginaryPart()));
        }
        return Lisp.type_error(obj, Symbol.NUMBER);
    }

    public LispObject divideBy(LispObject obj) {
        if (obj instanceof Fixnum) {
            return Lisp.number(this.value, Fixnum.getBigInteger(obj));
        }
        if (obj instanceof Bignum) {
            return Lisp.number(this.value, ((Bignum)obj).value);
        }
        if (obj instanceof Ratio) {
            BigInteger d = ((Ratio)obj).denominator();
            return Lisp.number(d.multiply(this.value), ((Ratio)obj).numerator());
        }
        if (obj instanceof SingleFloat) {
            return new SingleFloat(this.floatValue() / ((SingleFloat)obj).value);
        }
        if (obj instanceof DoubleFloat) {
            return new DoubleFloat(this.doubleValue() / ((DoubleFloat)obj).value);
        }
        if (obj instanceof Complex) {
            Complex c = (Complex)obj;
            LispObject realPart = c.getRealPart();
            LispObject imagPart = c.getImaginaryPart();
            LispObject denominator = realPart.multiplyBy(realPart).add(imagPart.multiplyBy(imagPart));
            return Complex.getInstance(this.multiplyBy(realPart).divideBy(denominator), Fixnum.ZERO.subtract(this.multiplyBy(imagPart).divideBy(denominator)));
        }
        return Lisp.type_error(obj, Symbol.NUMBER);
    }

    public boolean isEqualTo(LispObject obj) {
        if (obj instanceof Bignum) {
            return this.value.equals(((Bignum)obj).value);
        }
        if (obj instanceof SingleFloat) {
            return this.isEqualTo(((SingleFloat)obj).rational());
        }
        if (obj instanceof DoubleFloat) {
            return this.isEqualTo(((DoubleFloat)obj).rational());
        }
        if (obj.numberp()) {
            return false;
        }
        Lisp.type_error(obj, Symbol.NUMBER);
        return false;
    }

    public boolean isNotEqualTo(LispObject obj) {
        if (obj instanceof Bignum) {
            return !this.value.equals(((Bignum)obj).value);
        }
        if (obj instanceof SingleFloat) {
            return this.isNotEqualTo(((SingleFloat)obj).rational());
        }
        if (obj instanceof DoubleFloat) {
            return this.isNotEqualTo(((DoubleFloat)obj).rational());
        }
        if (obj.numberp()) {
            return true;
        }
        Lisp.type_error(obj, Symbol.NUMBER);
        return false;
    }

    public boolean isLessThan(LispObject obj) {
        if (obj instanceof Fixnum) {
            return this.value.compareTo(Fixnum.getBigInteger(obj)) < 0;
        }
        if (obj instanceof Bignum) {
            return this.value.compareTo(((Bignum)obj).value) < 0;
        }
        if (obj instanceof Ratio) {
            BigInteger n = this.value.multiply(((Ratio)obj).denominator());
            return n.compareTo(((Ratio)obj).numerator()) < 0;
        }
        if (obj instanceof SingleFloat) {
            return this.isLessThan(((SingleFloat)obj).rational());
        }
        if (obj instanceof DoubleFloat) {
            return this.isLessThan(((DoubleFloat)obj).rational());
        }
        Lisp.type_error(obj, Symbol.REAL);
        return false;
    }

    public boolean isGreaterThan(LispObject obj) {
        if (obj instanceof Fixnum) {
            return this.value.compareTo(Fixnum.getBigInteger(obj)) > 0;
        }
        if (obj instanceof Bignum) {
            return this.value.compareTo(((Bignum)obj).value) > 0;
        }
        if (obj instanceof Ratio) {
            BigInteger n = this.value.multiply(((Ratio)obj).denominator());
            return n.compareTo(((Ratio)obj).numerator()) > 0;
        }
        if (obj instanceof SingleFloat) {
            return this.isGreaterThan(((SingleFloat)obj).rational());
        }
        if (obj instanceof DoubleFloat) {
            return this.isGreaterThan(((DoubleFloat)obj).rational());
        }
        Lisp.type_error(obj, Symbol.REAL);
        return false;
    }

    public boolean isLessThanOrEqualTo(LispObject obj) {
        if (obj instanceof Fixnum) {
            return this.value.compareTo(Fixnum.getBigInteger(obj)) <= 0;
        }
        if (obj instanceof Bignum) {
            return this.value.compareTo(((Bignum)obj).value) <= 0;
        }
        if (obj instanceof Ratio) {
            BigInteger n = this.value.multiply(((Ratio)obj).denominator());
            return n.compareTo(((Ratio)obj).numerator()) <= 0;
        }
        if (obj instanceof SingleFloat) {
            return this.isLessThanOrEqualTo(((SingleFloat)obj).rational());
        }
        if (obj instanceof DoubleFloat) {
            return this.isLessThanOrEqualTo(((DoubleFloat)obj).rational());
        }
        Lisp.type_error(obj, Symbol.REAL);
        return false;
    }

    public boolean isGreaterThanOrEqualTo(LispObject obj) {
        if (obj instanceof Fixnum) {
            return this.value.compareTo(Fixnum.getBigInteger(obj)) >= 0;
        }
        if (obj instanceof Bignum) {
            return this.value.compareTo(((Bignum)obj).value) >= 0;
        }
        if (obj instanceof Ratio) {
            BigInteger n = this.value.multiply(((Ratio)obj).denominator());
            return n.compareTo(((Ratio)obj).numerator()) >= 0;
        }
        if (obj instanceof SingleFloat) {
            return this.isGreaterThanOrEqualTo(((SingleFloat)obj).rational());
        }
        if (obj instanceof DoubleFloat) {
            return this.isGreaterThanOrEqualTo(((DoubleFloat)obj).rational());
        }
        Lisp.type_error(obj, Symbol.REAL);
        return false;
    }

    public LispObject truncate(LispObject obj) {
        LispObject value2;
        LispObject value1;
        LispThread thread;
        block8: {
            thread = LispThread.currentThread();
            try {
                if (obj instanceof Fixnum) {
                    BigInteger divisor = ((Fixnum)obj).getBigInteger();
                    BigInteger[] results = this.value.divideAndRemainder(divisor);
                    BigInteger quotient = results[0];
                    BigInteger remainder = results[1];
                    value1 = Lisp.number(quotient);
                    value2 = remainder.signum() == 0 ? Fixnum.ZERO : Lisp.number(remainder);
                    break block8;
                }
                if (obj instanceof Bignum) {
                    BigInteger divisor = ((Bignum)obj).value;
                    BigInteger[] results = this.value.divideAndRemainder(divisor);
                    BigInteger quotient = results[0];
                    BigInteger remainder = results[1];
                    value1 = Lisp.number(quotient);
                    value2 = remainder.signum() == 0 ? Fixnum.ZERO : Lisp.number(remainder);
                    break block8;
                }
                if (obj instanceof Ratio) {
                    Ratio divisor = (Ratio)obj;
                    LispObject quotient = this.multiplyBy(divisor.DENOMINATOR()).truncate(divisor.NUMERATOR());
                    LispObject remainder = this.subtract(quotient.multiplyBy(divisor));
                    value1 = quotient;
                    value2 = remainder;
                    break block8;
                }
                if (obj instanceof SingleFloat) {
                    return new SingleFloat(this.floatValue()).truncate(obj);
                }
                if (obj instanceof DoubleFloat) {
                    return new DoubleFloat(this.doubleValue()).truncate(obj);
                }
                return Lisp.type_error(obj, Symbol.REAL);
            }
            catch (ArithmeticException e) {
                if (obj.zerop()) {
                    return Lisp.error(new DivisionByZero());
                }
                return Lisp.error(new ArithmeticError(e.getMessage()));
            }
        }
        return thread.setValues(value1, value2);
    }

    public LispObject ash(LispObject obj) {
        BigInteger n = this.value;
        if (obj instanceof Fixnum) {
            int count = ((Fixnum)obj).value;
            if (count == 0) {
                return this;
            }
            if (count == Integer.MIN_VALUE) {
                return n.signum() >= 0 ? Fixnum.ZERO : Fixnum.MINUS_ONE;
            }
            return Lisp.number(n.shiftLeft(count));
        }
        if (obj instanceof Bignum) {
            BigInteger count = ((Bignum)obj).value;
            if (count.signum() > 0) {
                return Lisp.error(new LispError("Can't represent result of left shift."));
            }
            if (count.signum() < 0) {
                return n.signum() >= 0 ? Fixnum.ZERO : Fixnum.MINUS_ONE;
            }
            Debug.bug();
        }
        return Lisp.type_error(obj, Symbol.INTEGER);
    }

    public LispObject LOGNOT() {
        return Lisp.number(this.value.not());
    }

    public LispObject LOGAND(int n) {
        if (n >= 0) {
            return Fixnum.getInstance(this.value.intValue() & n);
        }
        return Lisp.number(this.value.and(BigInteger.valueOf(n)));
    }

    public LispObject LOGAND(LispObject obj) {
        if (obj instanceof Fixnum) {
            int n = ((Fixnum)obj).value;
            if (n >= 0) {
                return Fixnum.getInstance(this.value.intValue() & n);
            }
            return Lisp.number(this.value.and(BigInteger.valueOf(n)));
        }
        if (obj instanceof Bignum) {
            BigInteger n = ((Bignum)obj).value;
            return Lisp.number(this.value.and(n));
        }
        return Lisp.type_error(obj, Symbol.INTEGER);
    }

    public LispObject LOGIOR(int n) {
        return Lisp.number(this.value.or(BigInteger.valueOf(n)));
    }

    public LispObject LOGIOR(LispObject obj) {
        if (obj instanceof Fixnum) {
            BigInteger n = ((Fixnum)obj).getBigInteger();
            return Lisp.number(this.value.or(n));
        }
        if (obj instanceof Bignum) {
            BigInteger n = ((Bignum)obj).value;
            return Lisp.number(this.value.or(n));
        }
        return Lisp.type_error(obj, Symbol.INTEGER);
    }

    public LispObject LOGXOR(int n) {
        return Lisp.number(this.value.xor(BigInteger.valueOf(n)));
    }

    public LispObject LOGXOR(LispObject obj) {
        BigInteger n;
        if (obj instanceof Fixnum) {
            n = ((Fixnum)obj).getBigInteger();
        } else if (obj instanceof Bignum) {
            n = ((Bignum)obj).value;
        } else {
            return Lisp.type_error(obj, Symbol.INTEGER);
        }
        return Lisp.number(this.value.xor(n));
    }

    public LispObject LDB(int size, int position) {
        BigInteger n = this.value.shiftRight(position);
        BigInteger mask = BigInteger.ONE.shiftLeft(size).subtract(BigInteger.ONE);
        return Lisp.number(n.and(mask));
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String printObject() {
        LispThread thread = LispThread.currentThread();
        int base = Fixnum.getValue(Symbol.PRINT_BASE.symbolValue(thread));
        String s = this.value.toString(base).toUpperCase();
        if (Symbol.PRINT_RADIX.symbolValue(thread) != Lisp.NIL) {
            StringBuffer sb = new StringBuffer();
            switch (base) {
                case 2: {
                    sb.append("#b");
                    sb.append(s);
                    break;
                }
                case 8: {
                    sb.append("#o");
                    sb.append(s);
                    break;
                }
                case 10: {
                    sb.append(s);
                    sb.append('.');
                    break;
                }
                case 16: {
                    sb.append("#x");
                    sb.append(s);
                    break;
                }
                default: {
                    sb.append('#');
                    sb.append(String.valueOf(base));
                    sb.append('r');
                    sb.append(s);
                }
            }
            s = sb.toString();
        }
        return s;
    }
}

