/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.rewrite.handler.LegacyRule;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.rewrite.handler.RuleContainer;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;

public class RewriteHandler
extends HandlerWrapper {
    private RuleContainer _rules;
    private EnumSet<DispatcherType> _dispatchTypes = EnumSet.of(DispatcherType.REQUEST);

    public RewriteHandler() {
        this._rules = new RuleContainer();
    }

    @Deprecated
    public void setLegacyRule(LegacyRule legacyRule) {
        this._rules.setLegacyRule(legacyRule);
    }

    public Rule[] getRules() {
        return this._rules.getRules();
    }

    public void setRules(Rule[] rules) {
        this._rules.setRules(rules);
    }

    public void setRules(RuleContainer rules) {
        this._rules = rules;
    }

    public void addRule(Rule rule) {
        this._rules.addRule(rule);
    }

    public boolean isRewriteRequestURI() {
        return this._rules.isRewriteRequestURI();
    }

    public void setRewriteRequestURI(boolean rewriteRequestURI) {
        this._rules.setRewriteRequestURI(rewriteRequestURI);
    }

    public boolean isRewritePathInfo() {
        return this._rules.isRewritePathInfo();
    }

    public void setRewritePathInfo(boolean rewritePathInfo) {
        this._rules.setRewritePathInfo(rewritePathInfo);
    }

    public String getOriginalPathAttribute() {
        return this._rules.getOriginalPathAttribute();
    }

    public void setOriginalPathAttribute(String originalPathAttribute) {
        this._rules.setOriginalPathAttribute(originalPathAttribute);
    }

    public EnumSet<DispatcherType> getDispatcherTypes() {
        return this._dispatchTypes;
    }

    public void setDispatcherTypes(EnumSet<DispatcherType> types) {
        this._dispatchTypes = EnumSet.copyOf(types);
    }

    public void setDispatcherTypes(DispatcherType ... types) {
        this._dispatchTypes = EnumSet.copyOf(Arrays.asList(types));
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.isStarted()) {
            if (this._dispatchTypes.contains(baseRequest.getDispatcherType())) {
                String returned = this._rules.matchAndApply(target, request, response);
                String string = target = returned == null ? target : returned;
            }
            if (!baseRequest.isHandled()) {
                super.handle(target, baseRequest, request, response);
            }
        }
    }
}

