/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.file.AntPathMatcherGenericFileFilter;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileConfiguration;
import org.apache.camel.component.file.GenericFileConsumer;
import org.apache.camel.component.file.GenericFileDefaultSorter;
import org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy;
import org.apache.camel.component.file.GenericFileExist;
import org.apache.camel.component.file.GenericFileFilter;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.component.file.GenericFileProducer;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.apache.camel.processor.idempotent.MemoryIdempotentRepository;
import org.apache.camel.spi.BrowsableEndpoint;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericFileEndpoint<T>
extends ScheduledPollEndpoint
implements BrowsableEndpoint {
    protected static final String DEFAULT_STRATEGYFACTORY_CLASS = "org.apache.camel.component.file.strategy.GenericFileProcessStrategyFactory";
    protected static final int DEFAULT_IDEMPOTENT_CACHE_SIZE = 1000;
    private static final Integer CHMOD_WRITE_MASK = 2;
    private static final Integer CHMOD_READ_MASK = 4;
    private static final Integer CHMOD_EXECUTE_MASK = 1;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @UriParam(label="advanced", defaultValue="true")
    protected boolean autoCreate = true;
    @UriParam(label="advanced", defaultValue="131072")
    protected int bufferSize = 131072;
    @UriParam
    protected String charset;
    @UriParam
    protected Expression fileName;
    @UriParam(label="producer")
    protected boolean flatten;
    @UriParam(label="producer", defaultValue="Override")
    protected GenericFileExist fileExist = GenericFileExist.Override;
    @UriParam(label="producer")
    protected String tempPrefix;
    @UriParam(label="producer")
    protected Expression tempFileName;
    @UriParam(label="producer,advanced", defaultValue="true")
    protected boolean eagerDeleteTargetFile = true;
    @UriParam(label="producer,advanced")
    protected boolean keepLastModified;
    @UriParam(label="producer")
    protected String doneFileName;
    @UriParam(label="producer,advanced")
    protected boolean allowNullBody;
    @UriParam(label="producer,advanced")
    protected String chmod;
    @UriParam
    protected GenericFileConfiguration configuration;
    @UriParam(label="consumer,advanced")
    protected GenericFileProcessStrategy<T> processStrategy;
    @UriParam(label="consumer,advanced")
    protected IdempotentRepository<String> inProgressRepository = new MemoryIdempotentRepository();
    @UriParam(label="consumer,advanced")
    protected String localWorkDirectory;
    @UriParam(label="consumer,advanced")
    protected boolean startingDirectoryMustExist;
    @UriParam(label="consumer,advanced")
    protected boolean directoryMustExist;
    @UriParam(label="consumer")
    protected boolean noop;
    @UriParam(label="consumer")
    protected boolean recursive;
    @UriParam(label="consumer")
    protected boolean delete;
    @UriParam(label="consumer,filter")
    protected int maxMessagesPerPoll;
    @UriParam(label="consumer,filter", defaultValue="true")
    protected boolean eagerMaxMessagesPerPoll = true;
    @UriParam(label="consumer,filter", defaultValue="2147483647")
    protected int maxDepth = Integer.MAX_VALUE;
    @UriParam(label="consumer,filter")
    protected int minDepth;
    @UriParam(label="consumer,filter")
    protected String include;
    @UriParam(label="consumer,filter")
    protected String exclude;
    @UriParam(label="consumer,filter")
    protected Expression move;
    @UriParam(label="consumer")
    protected Expression moveFailed;
    @UriParam(label="consumer")
    protected Expression preMove;
    @UriParam(label="producer")
    protected Expression moveExisting;
    @UriParam(label="consumer,filter", defaultValue="false")
    protected Boolean idempotent;
    @UriParam(label="consumer,filter")
    protected Expression idempotentKey;
    @UriParam(label="consumer,filter")
    protected IdempotentRepository<String> idempotentRepository;
    @UriParam(label="consumer,filter")
    protected GenericFileFilter<T> filter;
    protected volatile AntPathMatcherGenericFileFilter<T> antFilter;
    @UriParam(label="consumer,filter")
    protected String antInclude;
    @UriParam(label="consumer,filter")
    protected String antExclude;
    @UriParam(label="consumer,sort")
    protected Comparator<GenericFile<T>> sorter;
    @UriParam(label="consumer,sort")
    protected Comparator<Exchange> sortBy;
    @UriParam(label="consumer,sort")
    protected boolean shuffle;
    @UriParam(label="consumer,lock", enums="none,markerFile,fileLock,rename,changed,idempotent")
    protected String readLock = "none";
    @UriParam(label="consumer,lock", defaultValue="1000")
    protected long readLockCheckInterval = 1000L;
    @UriParam(label="consumer,lock", defaultValue="10000")
    protected long readLockTimeout = 10000L;
    @UriParam(label="consumer,lock", defaultValue="true")
    protected boolean readLockMarkerFile = true;
    @UriParam(label="consumer,lock", defaultValue="true")
    protected boolean readLockDeleteOrphanLockFiles = true;
    @UriParam(label="consumer,lock", defaultValue="WARN")
    protected LoggingLevel readLockLoggingLevel = LoggingLevel.WARN;
    @UriParam(label="consumer,lock", defaultValue="1")
    protected long readLockMinLength = 1L;
    @UriParam(label="consumer,lock", defaultValue="0")
    protected long readLockMinAge;
    @UriParam(label="consumer,lock", defaultValue="true")
    protected boolean readLockRemoveOnRollback = true;
    @UriParam(label="consumer,lock")
    protected boolean readLockRemoveOnCommit;
    @UriParam(label="consumer,lock")
    protected GenericFileExclusiveReadLockStrategy<T> exclusiveReadLockStrategy;
    @UriParam(label="consumer,advanced")
    protected ExceptionHandler onCompletionExceptionHandler;

    public GenericFileEndpoint() {
    }

    public GenericFileEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public abstract GenericFileConsumer<T> createConsumer(Processor var1) throws Exception;

    @Override
    public abstract GenericFileProducer<T> createProducer() throws Exception;

    public abstract Exchange createExchange(GenericFile<T> var1);

    public abstract String getScheme();

    public abstract char getFileSeparator();

    public abstract boolean isAbsolute(String var1);

    public String getGeneratedFileName(Message message) {
        return StringHelper.sanitize(message.getMessageId());
    }

    public GenericFileProcessStrategy<T> getGenericFileProcessStrategy() {
        if (this.processStrategy == null) {
            this.processStrategy = this.createGenericFileStrategy();
            this.log.debug("Using Generic file process strategy: {}", (Object)this.processStrategy);
        }
        return this.processStrategy;
    }

    @Override
    public List<Exchange> getExchanges() {
        final ArrayList<Exchange> answer = new ArrayList<Exchange>();
        Consumer consumer = null;
        try {
            consumer = this.createConsumer(null);
            ((GenericFileConsumer)consumer).setCustomProcessor(new Processor(){

                @Override
                public void process(Exchange exchange) throws Exception {
                    answer.add(exchange);
                }
            });
            ((ScheduledPollConsumer)consumer).setStartScheduler(false);
            ServiceHelper.startService(consumer);
            ((GenericFileConsumer)consumer).poll();
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
        finally {
            try {
                ServiceHelper.stopService(consumer);
            }
            catch (Exception e) {
                this.log.debug("Error stopping consumer used for browsing exchanges. This exception will be ignored", e);
            }
        }
        return answer;
    }

    protected GenericFileProcessStrategy<T> createGenericFileStrategy() {
        Class<?> factory = null;
        try {
            FactoryFinder finder = this.getCamelContext().getFactoryFinder("META-INF/services/org/apache/camel/component/");
            this.log.trace("Using FactoryFinder: {}", (Object)finder);
            factory = finder.findClass(this.getScheme(), "strategy.factory.", CamelContext.class);
        }
        catch (ClassNotFoundException e) {
            this.log.trace("'strategy.factory.class' not found", e);
        }
        catch (IOException e) {
            this.log.trace("No strategy factory defined in 'META-INF/services/org/apache/camel/component/'", e);
        }
        if (factory == null) {
            block12: {
                try {
                    this.log.trace("Using ClassResolver to resolve class: {}", (Object)DEFAULT_STRATEGYFACTORY_CLASS);
                    factory = this.getCamelContext().getClassResolver().resolveClass(DEFAULT_STRATEGYFACTORY_CLASS);
                }
                catch (Exception e) {
                    this.log.trace("Cannot load class: {}", (Object)DEFAULT_STRATEGYFACTORY_CLASS, (Object)e);
                }
                try {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("Using classloader: {} to resolve class: {}", (Object)this.getClass().getClassLoader(), (Object)DEFAULT_STRATEGYFACTORY_CLASS);
                    }
                    factory = this.getCamelContext().getClassResolver().resolveClass(DEFAULT_STRATEGYFACTORY_CLASS, this.getClass().getClassLoader());
                }
                catch (Exception e) {
                    if (!this.log.isTraceEnabled()) break block12;
                    this.log.trace("Cannot load class: {} using classloader: " + this.getClass().getClassLoader(), (Object)DEFAULT_STRATEGYFACTORY_CLASS, (Object)e);
                }
            }
            if (factory == null) {
                throw new TypeNotPresentException("org.apache.camel.component.file.strategy.GenericFileProcessStrategyFactory class not found", null);
            }
        }
        try {
            Method factoryMethod = factory.getMethod("createGenericFileProcessStrategy", CamelContext.class, Map.class);
            Map<String, Object> params = this.getParamsAsMap();
            this.log.debug("Parameters for Generic file process strategy {}", (Object)params);
            return (GenericFileProcessStrategy)ObjectHelper.invokeMethod(factoryMethod, null, this.getCamelContext(), params);
        }
        catch (NoSuchMethodException e) {
            throw new TypeNotPresentException(factory.getSimpleName() + ".createGenericFileProcessStrategy method not found", e);
        }
    }

    public boolean chmodPermissionsAreValid(String chmod) {
        if (chmod == null || chmod.length() < 3 || chmod.length() > 4) {
            return false;
        }
        String permissionsString = chmod.trim().substring(chmod.length() - 3);
        for (int i = 0; i < permissionsString.length(); ++i) {
            Character c = Character.valueOf(permissionsString.charAt(i));
            if (Character.isDigit(c.charValue()) && Integer.parseInt(c.toString()) <= 7) continue;
            return false;
        }
        return true;
    }

    public Set<PosixFilePermission> getPermissions() {
        HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
        if (ObjectHelper.isEmpty(this.chmod)) {
            return permissions;
        }
        String chmodString = this.chmod.substring(this.chmod.length() - 3);
        Integer ownerValue = Integer.parseInt(chmodString.substring(0, 1));
        Integer groupValue = Integer.parseInt(chmodString.substring(1, 2));
        Integer othersValue = Integer.parseInt(chmodString.substring(2, 3));
        if ((ownerValue & CHMOD_WRITE_MASK) > 0) {
            permissions.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((ownerValue & CHMOD_READ_MASK) > 0) {
            permissions.add(PosixFilePermission.OWNER_READ);
        }
        if ((ownerValue & CHMOD_EXECUTE_MASK) > 0) {
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((groupValue & CHMOD_WRITE_MASK) > 0) {
            permissions.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((groupValue & CHMOD_READ_MASK) > 0) {
            permissions.add(PosixFilePermission.GROUP_READ);
        }
        if ((groupValue & CHMOD_EXECUTE_MASK) > 0) {
            permissions.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((othersValue & CHMOD_WRITE_MASK) > 0) {
            permissions.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((othersValue & CHMOD_READ_MASK) > 0) {
            permissions.add(PosixFilePermission.OTHERS_READ);
        }
        if ((othersValue & CHMOD_EXECUTE_MASK) > 0) {
            permissions.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return permissions;
    }

    public String getChmod() {
        return this.chmod;
    }

    public void setChmod(String chmod) throws Exception {
        if (!ObjectHelper.isNotEmpty(chmod) || !this.chmodPermissionsAreValid(chmod)) {
            throw new IllegalArgumentException("chmod option [" + chmod + "] is not valid");
        }
        this.chmod = chmod.trim();
    }

    public boolean isNoop() {
        return this.noop;
    }

    public void setNoop(boolean noop) {
        this.noop = noop;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public String getInclude() {
        return this.include;
    }

    public void setInclude(String include) {
        this.include = include;
    }

    public String getExclude() {
        return this.exclude;
    }

    public void setExclude(String exclude) {
        this.exclude = exclude;
    }

    public String getAntInclude() {
        return this.antInclude;
    }

    public void setAntInclude(String antInclude) {
        this.antInclude = antInclude;
        if (this.antFilter == null) {
            this.antFilter = new AntPathMatcherGenericFileFilter();
        }
        this.antFilter.setIncludes(antInclude);
    }

    public String getAntExclude() {
        return this.antExclude;
    }

    public void setAntExclude(String antExclude) {
        this.antExclude = antExclude;
        if (this.antFilter == null) {
            this.antFilter = new AntPathMatcherGenericFileFilter();
        }
        this.antFilter.setExcludes(antExclude);
    }

    public void setAntFilterCaseSensitive(boolean antFilterCaseSensitive) {
        if (this.antFilter == null) {
            this.antFilter = new AntPathMatcherGenericFileFilter();
        }
        this.antFilter.setCaseSensitive(antFilterCaseSensitive);
    }

    public GenericFileFilter<T> getAntFilter() {
        return this.antFilter;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public void setDelete(boolean delete2) {
        this.delete = delete2;
    }

    public boolean isFlatten() {
        return this.flatten;
    }

    public void setFlatten(boolean flatten) {
        this.flatten = flatten;
    }

    public Expression getMove() {
        return this.move;
    }

    public void setMove(Expression move) {
        this.move = move;
    }

    public void setMove(String fileLanguageExpression) {
        String expression = this.configureMoveOrPreMoveExpression(fileLanguageExpression);
        this.move = this.createFileLanguageExpression(expression);
    }

    public Expression getMoveFailed() {
        return this.moveFailed;
    }

    public void setMoveFailed(Expression moveFailed) {
        this.moveFailed = moveFailed;
    }

    public void setMoveFailed(String fileLanguageExpression) {
        String expression = this.configureMoveOrPreMoveExpression(fileLanguageExpression);
        this.moveFailed = this.createFileLanguageExpression(expression);
    }

    public Expression getPreMove() {
        return this.preMove;
    }

    public void setPreMove(Expression preMove) {
        this.preMove = preMove;
    }

    public void setPreMove(String fileLanguageExpression) {
        String expression = this.configureMoveOrPreMoveExpression(fileLanguageExpression);
        this.preMove = this.createFileLanguageExpression(expression);
    }

    public Expression getMoveExisting() {
        return this.moveExisting;
    }

    public void setMoveExisting(Expression moveExisting) {
        this.moveExisting = moveExisting;
    }

    public void setMoveExisting(String fileLanguageExpression) {
        String expression = this.configureMoveOrPreMoveExpression(fileLanguageExpression);
        this.moveExisting = this.createFileLanguageExpression(expression);
    }

    public Expression getFileName() {
        return this.fileName;
    }

    public void setFileName(Expression fileName) {
        this.fileName = fileName;
    }

    public void setFileName(String fileLanguageExpression) {
        this.fileName = this.createFileLanguageExpression(fileLanguageExpression);
    }

    public String getDoneFileName() {
        return this.doneFileName;
    }

    public void setDoneFileName(String doneFileName) {
        this.doneFileName = doneFileName;
    }

    public Boolean isIdempotent() {
        return this.idempotent != null ? this.idempotent : false;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        IOHelper.validateCharset(charset);
        this.charset = charset;
    }

    protected boolean isIdempotentSet() {
        return this.idempotent != null;
    }

    public void setIdempotent(Boolean idempotent) {
        this.idempotent = idempotent;
    }

    public Expression getIdempotentKey() {
        return this.idempotentKey;
    }

    public void setIdempotentKey(Expression idempotentKey) {
        this.idempotentKey = idempotentKey;
    }

    public void setIdempotentKey(String expression) {
        this.idempotentKey = this.createFileLanguageExpression(expression);
    }

    public IdempotentRepository<String> getIdempotentRepository() {
        return this.idempotentRepository;
    }

    public void setIdempotentRepository(IdempotentRepository<String> idempotentRepository) {
        this.idempotentRepository = idempotentRepository;
    }

    public GenericFileFilter<T> getFilter() {
        return this.filter;
    }

    public void setFilter(GenericFileFilter<T> filter) {
        this.filter = filter;
    }

    public Comparator<GenericFile<T>> getSorter() {
        return this.sorter;
    }

    public void setSorter(Comparator<GenericFile<T>> sorter) {
        this.sorter = sorter;
    }

    public Comparator<Exchange> getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(Comparator<Exchange> sortBy) {
        this.sortBy = sortBy;
    }

    public void setSortBy(String expression) {
        this.setSortBy(expression, false);
    }

    public void setSortBy(String expression, boolean reverse) {
        this.setSortBy(GenericFileDefaultSorter.sortByFileLanguage(this.getCamelContext(), expression, reverse));
    }

    public boolean isShuffle() {
        return this.shuffle;
    }

    public void setShuffle(boolean shuffle) {
        this.shuffle = shuffle;
    }

    public String getTempPrefix() {
        return this.tempPrefix;
    }

    public void setTempPrefix(String tempPrefix) {
        this.tempPrefix = tempPrefix;
        this.setTempFileName(tempPrefix + "${file:onlyname}");
    }

    public Expression getTempFileName() {
        return this.tempFileName;
    }

    public void setTempFileName(Expression tempFileName) {
        this.tempFileName = tempFileName;
    }

    public void setTempFileName(String tempFileNameExpression) {
        this.tempFileName = this.createFileLanguageExpression(tempFileNameExpression);
    }

    public boolean isEagerDeleteTargetFile() {
        return this.eagerDeleteTargetFile;
    }

    public void setEagerDeleteTargetFile(boolean eagerDeleteTargetFile) {
        this.eagerDeleteTargetFile = eagerDeleteTargetFile;
    }

    public GenericFileConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new GenericFileConfiguration();
        }
        return this.configuration;
    }

    public void setConfiguration(GenericFileConfiguration configuration) {
        this.configuration = configuration;
    }

    public GenericFileExclusiveReadLockStrategy<T> getExclusiveReadLockStrategy() {
        return this.exclusiveReadLockStrategy;
    }

    public void setExclusiveReadLockStrategy(GenericFileExclusiveReadLockStrategy<T> exclusiveReadLockStrategy) {
        this.exclusiveReadLockStrategy = exclusiveReadLockStrategy;
    }

    public String getReadLock() {
        return this.readLock;
    }

    public void setReadLock(String readLock) {
        this.readLock = readLock;
    }

    public long getReadLockCheckInterval() {
        return this.readLockCheckInterval;
    }

    public void setReadLockCheckInterval(long readLockCheckInterval) {
        this.readLockCheckInterval = readLockCheckInterval;
    }

    public long getReadLockTimeout() {
        return this.readLockTimeout;
    }

    public void setReadLockTimeout(long readLockTimeout) {
        this.readLockTimeout = readLockTimeout;
    }

    public boolean isReadLockMarkerFile() {
        return this.readLockMarkerFile;
    }

    public void setReadLockMarkerFile(boolean readLockMarkerFile) {
        this.readLockMarkerFile = readLockMarkerFile;
    }

    public boolean isReadLockDeleteOrphanLockFiles() {
        return this.readLockDeleteOrphanLockFiles;
    }

    public void setReadLockDeleteOrphanLockFiles(boolean readLockDeleteOrphanLockFiles) {
        this.readLockDeleteOrphanLockFiles = readLockDeleteOrphanLockFiles;
    }

    public LoggingLevel getReadLockLoggingLevel() {
        return this.readLockLoggingLevel;
    }

    public void setReadLockLoggingLevel(LoggingLevel readLockLoggingLevel) {
        this.readLockLoggingLevel = readLockLoggingLevel;
    }

    public long getReadLockMinLength() {
        return this.readLockMinLength;
    }

    public void setReadLockMinLength(long readLockMinLength) {
        this.readLockMinLength = readLockMinLength;
    }

    public long getReadLockMinAge() {
        return this.readLockMinAge;
    }

    public void setReadLockMinAge(long readLockMinAge) {
        this.readLockMinAge = readLockMinAge;
    }

    public boolean isReadLockRemoveOnRollback() {
        return this.readLockRemoveOnRollback;
    }

    public void setReadLockRemoveOnRollback(boolean readLockRemoveOnRollback) {
        this.readLockRemoveOnRollback = readLockRemoveOnRollback;
    }

    public boolean isReadLockRemoveOnCommit() {
        return this.readLockRemoveOnCommit;
    }

    public void setReadLockRemoveOnCommit(boolean readLockRemoveOnCommit) {
        this.readLockRemoveOnCommit = readLockRemoveOnCommit;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("BufferSize must be a positive value, was " + bufferSize);
        }
        this.bufferSize = bufferSize;
    }

    public GenericFileExist getFileExist() {
        return this.fileExist;
    }

    public void setFileExist(GenericFileExist fileExist) {
        this.fileExist = fileExist;
    }

    public boolean isAutoCreate() {
        return this.autoCreate;
    }

    public void setAutoCreate(boolean autoCreate) {
        this.autoCreate = autoCreate;
    }

    public boolean isStartingDirectoryMustExist() {
        return this.startingDirectoryMustExist;
    }

    public void setStartingDirectoryMustExist(boolean startingDirectoryMustExist) {
        this.startingDirectoryMustExist = startingDirectoryMustExist;
    }

    public boolean isDirectoryMustExist() {
        return this.directoryMustExist;
    }

    public void setDirectoryMustExist(boolean directoryMustExist) {
        this.directoryMustExist = directoryMustExist;
    }

    public GenericFileProcessStrategy<T> getProcessStrategy() {
        return this.processStrategy;
    }

    public void setProcessStrategy(GenericFileProcessStrategy<T> processStrategy) {
        this.processStrategy = processStrategy;
    }

    public String getLocalWorkDirectory() {
        return this.localWorkDirectory;
    }

    public void setLocalWorkDirectory(String localWorkDirectory) {
        this.localWorkDirectory = localWorkDirectory;
    }

    public int getMaxMessagesPerPoll() {
        return this.maxMessagesPerPoll;
    }

    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }

    public boolean isEagerMaxMessagesPerPoll() {
        return this.eagerMaxMessagesPerPoll;
    }

    public void setEagerMaxMessagesPerPoll(boolean eagerMaxMessagesPerPoll) {
        this.eagerMaxMessagesPerPoll = eagerMaxMessagesPerPoll;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public int getMinDepth() {
        return this.minDepth;
    }

    public void setMinDepth(int minDepth) {
        this.minDepth = minDepth;
    }

    public IdempotentRepository<String> getInProgressRepository() {
        return this.inProgressRepository;
    }

    public void setInProgressRepository(IdempotentRepository<String> inProgressRepository) {
        this.inProgressRepository = inProgressRepository;
    }

    public boolean isKeepLastModified() {
        return this.keepLastModified;
    }

    public void setKeepLastModified(boolean keepLastModified) {
        this.keepLastModified = keepLastModified;
    }

    public boolean isAllowNullBody() {
        return this.allowNullBody;
    }

    public void setAllowNullBody(boolean allowNullBody) {
        this.allowNullBody = allowNullBody;
    }

    public ExceptionHandler getOnCompletionExceptionHandler() {
        return this.onCompletionExceptionHandler;
    }

    public void setOnCompletionExceptionHandler(ExceptionHandler onCompletionExceptionHandler) {
        this.onCompletionExceptionHandler = onCompletionExceptionHandler;
    }

    public void configureMessage(GenericFile<T> file, Message message) {
        message.setBody(file);
        if (this.flatten) {
            message.setHeader("CamelFileName", file.getFileNameOnly());
        } else {
            String name = file.isAbsolute() ? file.getAbsoluteFilePath() : file.getRelativeFilePath();
            String endpointPath = this.getConfiguration().getDirectory() + this.getFileSeparator();
            endpointPath = FileUtil.normalizePath(endpointPath);
            String copyOfName = FileUtil.normalizePath(name);
            if (ObjectHelper.isNotEmpty(endpointPath) && copyOfName.startsWith(endpointPath)) {
                name = name.substring(endpointPath.length());
            }
            message.setHeader("CamelFileName", name);
        }
    }

    public void configureExchange(Exchange exchange) {
        if (this.getCharset() != null) {
            exchange.setProperty("CamelCharsetName", this.getCharset());
        }
    }

    protected String configureMoveOrPreMoveExpression(String expression) {
        if (StringHelper.hasStartToken(expression, "simple")) {
            return expression;
        }
        expression = FileUtil.stripTrailingSeparator(expression);
        StringBuilder sb = new StringBuilder();
        if (!this.isAbsolute(expression)) {
            sb.append("${file:parent}");
            sb.append(this.getFileSeparator());
        }
        sb.append(expression);
        sb.append(this.getFileSeparator());
        sb.append("${file:onlyname}");
        return sb.toString();
    }

    protected Map<String, Object> getParamsAsMap() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.isNoop()) {
            params.put("noop", Boolean.toString(true));
        }
        if (this.isDelete()) {
            params.put("delete", Boolean.toString(true));
        }
        if (this.move != null) {
            params.put("move", this.move);
        }
        if (this.moveFailed != null) {
            params.put("moveFailed", this.moveFailed);
        }
        if (this.preMove != null) {
            params.put("preMove", this.preMove);
        }
        if (this.exclusiveReadLockStrategy != null) {
            params.put("exclusiveReadLockStrategy", this.exclusiveReadLockStrategy);
        }
        if (this.readLock != null) {
            params.put("readLock", this.readLock);
        }
        if ("idempotent".equals(this.readLock)) {
            params.put("readLockIdempotentRepository", this.idempotentRepository);
        }
        if (this.readLockCheckInterval > 0L) {
            params.put("readLockCheckInterval", this.readLockCheckInterval);
        }
        if (this.readLockTimeout > 0L) {
            params.put("readLockTimeout", this.readLockTimeout);
        }
        params.put("readLockMarkerFile", this.readLockMarkerFile);
        params.put("readLockDeleteOrphanLockFiles", this.readLockDeleteOrphanLockFiles);
        params.put("readLockMinLength", this.readLockMinLength);
        params.put("readLockLoggingLevel", (Object)this.readLockLoggingLevel);
        params.put("readLockMinAge", this.readLockMinAge);
        params.put("readLockRemoveOnRollback", this.readLockRemoveOnRollback);
        params.put("readLockRemoveOnCommit", this.readLockRemoveOnCommit);
        return params;
    }

    private Expression createFileLanguageExpression(String expression) {
        Language language = expression.contains("$") ? this.getCamelContext().resolveLanguage("file") : this.getCamelContext().resolveLanguage("constant");
        return language.createExpression(expression);
    }

    protected String createDoneFileName(String fileName) {
        String pattern = this.getDoneFileName();
        ObjectHelper.notEmpty(pattern, "doneFileName", pattern);
        String path = FileUtil.onlyPath(fileName);
        String onlyName = FileUtil.stripPath(fileName);
        pattern = pattern.replaceFirst("\\$\\{file:name\\}", onlyName);
        pattern = pattern.replaceFirst("\\$simple\\{file:name\\}", onlyName);
        pattern = pattern.replaceFirst("\\$\\{file:name.noext\\}", FileUtil.stripExt(onlyName));
        pattern = pattern.replaceFirst("\\$simple\\{file:name.noext\\}", FileUtil.stripExt(onlyName));
        if (StringHelper.hasStartToken(pattern, "simple")) {
            throw new ExpressionIllegalSyntaxException(fileName + ". Cannot resolve reminder: " + pattern);
        }
        String answer = pattern;
        if (ObjectHelper.isNotEmpty(path) && ObjectHelper.isNotEmpty(pattern)) {
            answer = path + this.getFileSeparator() + pattern;
        }
        if (this.getConfiguration().needToNormalize()) {
            answer = FileUtil.normalizePath(answer);
        }
        return answer;
    }

    protected boolean isDoneFile(String fileName) {
        String pattern = this.getDoneFileName();
        ObjectHelper.notEmpty(pattern, "doneFileName", pattern);
        if (!StringHelper.hasStartToken(pattern, "simple")) {
            return pattern.equals(fileName);
        }
        boolean prefix = pattern.indexOf("${") > 0;
        pattern = pattern.replaceFirst("\\$\\{file:name\\}", "");
        pattern = pattern.replaceFirst("\\$simple\\{file:name\\}", "");
        pattern = pattern.replaceFirst("\\$\\{file:name.noext\\}", "");
        if (StringHelper.hasStartToken(pattern = pattern.replaceFirst("\\$simple\\{file:name.noext\\}", ""), "simple")) {
            throw new ExpressionIllegalSyntaxException(fileName + ". Cannot resolve reminder: " + pattern);
        }
        if (prefix) {
            return fileName.startsWith(pattern);
        }
        return fileName.endsWith(pattern);
    }

    @Override
    protected void doStart() throws Exception {
        if (!"none".equals(this.readLock) && !"off".equals(this.readLock)) {
            if (this.readLockTimeout > 0L && this.readLockMinAge > 0L && this.readLockTimeout <= this.readLockCheckInterval + this.readLockMinAge) {
                throw new IllegalArgumentException("The option readLockTimeout must be higher than readLockCheckInterval + readLockMinAge, was readLockTimeout=" + this.readLockTimeout + ", readLockCheckInterval+readLockMinAge=" + (this.readLockCheckInterval + this.readLockMinAge) + ". A good practice is to let the readLockTimeout be at least readLockMinAge + 2 times the readLockCheckInterval" + " to ensure that the read lock procedure has enough time to acquire the lock.");
            }
            if (this.readLockTimeout > 0L && this.readLockTimeout <= this.readLockCheckInterval) {
                throw new IllegalArgumentException("The option readLockTimeout must be higher than readLockCheckInterval, was readLockTimeout=" + this.readLockTimeout + ", readLockCheckInterval=" + this.readLockCheckInterval + ". A good practice is to let the readLockTimeout be at least 3 times higher than the readLockCheckInterval" + " to ensure that the read lock procedure has enough time to acquire the lock.");
            }
        }
        if ("idempotent".equals(this.readLock) && this.idempotentRepository == null) {
            throw new IllegalArgumentException("IdempotentRepository must be configured when using readLock=idempotent");
        }
        if (this.idempotentRepository != null) {
            this.getCamelContext().addService(this.idempotentRepository, true);
        }
        ServiceHelper.startServices(this.inProgressRepository);
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopServices(this.inProgressRepository);
    }
}

