/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc.adapter;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.activemq.store.jdbc.DefaultDatabaseLocker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactDatabaseLocker
extends DefaultDatabaseLocker {
    private static final Logger LOG = LoggerFactory.getLogger(TransactDatabaseLocker.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStart() throws Exception {
        LOG.info("Attempting to acquire the exclusive lock to become the Master broker");
        Statement statement = null;
        while (true) {
            try {
                this.connection = this.dataSource.getConnection();
                this.connection.setAutoCommit(false);
                String sql = this.getStatements().getLockCreateStatement();
                statement = this.connection.prepareStatement(sql);
                if (statement.getMetaData() != null) {
                    ResultSet rs = statement.executeQuery();
                    rs.next();
                    break;
                }
                statement.execute();
                break;
            }
            catch (Exception e) {
                if (this.isStopping()) {
                    throw new Exception("Cannot start broker as being asked to shut down. Interrupted attempt to acquire lock: " + e, e);
                }
                if (this.exceptionHandler != null) {
                    try {
                        this.exceptionHandler.handle(e);
                    }
                    catch (Throwable handlerException) {
                        LOG.error("The exception handler " + this.exceptionHandler.getClass().getCanonicalName() + " threw this exception: " + handlerException + " while trying to handle this excpetion: " + e, handlerException);
                    }
                } else {
                    LOG.error("Failed to acquire lock: " + e, e);
                }
            }
            finally {
                if (null != statement) {
                    try {
                        statement.close();
                    }
                    catch (SQLException e1) {
                        LOG.warn("Caught while closing statement: " + e1, e1);
                    }
                    statement = null;
                }
            }
            LOG.debug("Sleeping for " + this.lockAcquireSleepInterval + " milli(s) before trying again to get the lock...");
            try {
                Thread.sleep(this.lockAcquireSleepInterval);
            }
            catch (InterruptedException ie) {
                LOG.warn("Master lock retry sleep interrupted", ie);
            }
        }
        LOG.info("Becoming the master on dataSource: " + this.dataSource);
    }
}

