require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&U8C)) {
    sub U8C {
	my($v) = @_;
	eval q(($v &U));
    }
}
unless(defined(&U32C)) {
    sub U32C {
	my($v) = @_;
	eval q(($v &U));
    }
}
unless(defined(&U8V)) {
    sub U8V {
	my($v) = @_;
	eval q((( &u8)($v) &  &U8C(0xff)));
    }
}
unless(defined(&U32V)) {
    sub U32V {
	my($v) = @_;
	eval q((( &u32)($v) &  &U32C(0xffffffff)));
    }
}
unless(defined(&ROTL32)) {
    sub ROTL32 {
	my($v, $n) = @_;
	eval q(( &U32V(($v) << ($n)) | (($v) >> (32- ($n)))));
    }
}
unless(defined(&U8TO32_LITTLE)) {
    sub U8TO32_LITTLE {
	my($p) = @_;
	eval q(((( &u32)(($p)[0]) ) | (( &u32)(($p)[1]) << 8) | (( &u32)(($p)[2]) << 16) | (( &u32)(($p)[3]) << 24)));
    }
}
unless(defined(&U32TO8_LITTLE)) {
    sub U32TO8_LITTLE {
	my($p, $v) = @_;
	eval q( &do { ($p)[0] =  &U8V(($v) ); ($p)[1] =  &U8V(($v) >> 8); ($p)[2] =  &U8V(($v) >> 16); ($p)[3] =  &U8V(($v) >> 24); }  &while (0));
    }
}
unless(defined(&ROTATE)) {
    sub ROTATE {
	my($v,$c) = @_;
	eval q(( &ROTL32($v,$c)));
    }
}
unless(defined(&XOR)) {
    sub XOR {
	my($v,$w) = @_;
	eval q((($v) ^ ($w)));
    }
}
unless(defined(&PLUS)) {
    sub PLUS {
	my($v,$w) = @_;
	eval q(( &U32V(($v) + ($w))));
    }
}
unless(defined(&PLUSONE)) {
    sub PLUSONE {
	my($v) = @_;
	eval q(( &PLUS(($v),1)));
    }
}
unless(defined(&QUARTERROUND)) {
    sub QUARTERROUND {
	my($a,$b,$c,$d) = @_;
	eval q($a =  &PLUS($a,$b); $d =  &ROTATE( &XOR($d,$a),16); $c =  &PLUS($c,$d); $b =  &ROTATE( &XOR($b,$c),12); $a =  &PLUS($a,$b); $d =  &ROTATE( &XOR($d,$a), 8); $c =  &PLUS($c,$d); $b =  &ROTATE( &XOR($b,$c), 7););
    }
}
unless(defined(&KEYSTREAM_ONLY)) {
}
unless(defined(&KEYSTREAM_ONLY)) {
}
1;
