/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.detector;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jolokia.backend.executor.MBeanServerExecutor;
import org.jolokia.detector.AbstractServerDetector;
import org.jolokia.detector.ServerHandle;

public class TomcatDetector
extends AbstractServerDetector {
    private static final Pattern SERVER_INFO_PATTERN = Pattern.compile("^\\s*([^/]+)\\s*/\\s*([\\d\\.]+(-RC\\d+)?)", 2);

    public ServerHandle detect(MBeanServerExecutor pMBeanServerExecutor) {
        String serverInfo = this.getSingleStringAttribute(pMBeanServerExecutor, "*:type=Server", "serverInfo");
        if (serverInfo == null) {
            return null;
        }
        Matcher matcher = SERVER_INFO_PATTERN.matcher(serverInfo);
        if (matcher.matches()) {
            String product = matcher.group(1);
            String version = matcher.group(2);
            if (product.toLowerCase().contains("tomcat")) {
                return new ServerHandle("Apache", "tomcat", version, null, null);
            }
        }
        return null;
    }
}

