/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.git;

import io.hawt.git.CommitInfo;
import io.hawt.git.FileContents;
import io.hawt.git.FileInfo;
import io.hawt.git.GitFacade;
import io.hawt.git.GitFacadeMXBean;
import io.hawt.git.RuntimeIOException;
import io.hawt.util.FileFilters;
import io.hawt.util.IOHelper;
import io.hawt.util.MBeanSupport;
import io.hawt.util.Strings;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.gitective.core.BlobUtils;
import org.gitective.core.CommitFinder;
import org.gitective.core.CommitUtils;
import org.gitective.core.PathFilterUtils;
import org.gitective.core.filter.commit.CommitLimitFilter;
import org.gitective.core.filter.commit.CommitListFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GitFacadeSupport
extends MBeanSupport
implements GitFacadeMXBean {
    private static final transient Logger LOG = LoggerFactory.getLogger(GitFacadeSupport.class);
    private int shortCommitIdLength = 6;

    protected String doDiff(Git git, String objectId, String baseObjectId, String path) {
        Repository r = git.getRepository();
        RevCommit commit = Strings.isNotBlank((String)objectId) ? CommitUtils.getCommit((Repository)r, (String)objectId) : CommitUtils.getHead((Repository)r);
        RevCommit baseCommit = null;
        if (Strings.isNotBlank((String)baseObjectId)) {
            baseCommit = CommitUtils.getCommit((Repository)r, (String)baseObjectId);
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        RawTextComparator cmp = RawTextComparator.DEFAULT;
        DiffFormatter formatter = new DiffFormatter((OutputStream)buffer);
        formatter.setRepository(r);
        formatter.setDiffComparator(cmp);
        formatter.setDetectRenames(true);
        RevTree commitTree = commit.getTree();
        try {
            RevTree baseTree;
            if (baseCommit == null) {
                if (commit.getParentCount() > 0) {
                    RevWalk rw = new RevWalk(r);
                    RevCommit parent = rw.parseCommit((AnyObjectId)commit.getParent(0).getId());
                    rw.dispose();
                    baseTree = parent.getTree();
                } else {
                    baseTree = commitTree;
                }
            } else {
                baseTree = baseCommit.getTree();
            }
            List diffEntries = formatter.scan(baseTree, commitTree);
            if (path != null && path.length() > 0) {
                for (DiffEntry diffEntry : diffEntries) {
                    if (!diffEntry.getNewPath().equalsIgnoreCase(path)) continue;
                    formatter.format(diffEntry);
                    break;
                }
            } else {
                formatter.format(diffEntries);
            }
            formatter.flush();
            return buffer.toString();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    protected abstract void checkoutBranch(Git var1, String var2) throws GitAPIException;

    protected abstract boolean isPushOnCommit();

    protected abstract Iterable<PushResult> doPush(Git var1) throws Exception;

    protected CommitInfo doCreateDirectory(Git git, File rootDir, String branch, String path, PersonIdent personIdent, String commitMessage) throws Exception {
        File file = this.getFile(rootDir, path);
        if (file.exists()) {
            return null;
        }
        file.mkdirs();
        String filePattern = GitFacadeSupport.getFilePattern(path);
        AddCommand add = git.add().addFilepattern(filePattern).addFilepattern(".");
        add.call();
        CommitCommand commit = git.commit().setAll(true).setAuthor(personIdent).setMessage(commitMessage);
        RevCommit revCommit = this.commitThenPush(git, branch, commit);
        return this.createCommitInfo(revCommit);
    }

    protected Void doRevert(Git git, File rootDir, String branch, String objectId, String blobPath, String commitMessage, PersonIdent personIdent) throws Exception {
        String contents = this.doGetContent(git, objectId, blobPath);
        if (contents != null) {
            this.doWrite(git, rootDir, branch, blobPath, contents, personIdent, commitMessage);
        }
        return null;
    }

    protected RevCommit doRename(Git git, File rootDir, String branch, String oldPath, String newPath, String commitMessage, PersonIdent personIdent) throws Exception {
        File file = this.getFile(rootDir, oldPath);
        File newFile = this.getFile(rootDir, newPath);
        if (file.exists()) {
            File parentFile = newFile.getParentFile();
            parentFile.mkdirs();
            if (!parentFile.exists()) {
                throw new IOException("Could not create directory " + parentFile + " when trying to move " + file + " to " + newFile + ". Maybe a file permission issue?");
            }
            file.renameTo(newFile);
            String filePattern = GitFacadeSupport.getFilePattern(newPath);
            git.add().addFilepattern(filePattern).call();
            CommitCommand commit = git.commit().setAll(true).setAuthor(personIdent).setMessage(commitMessage);
            return this.commitThenPush(git, branch, commit);
        }
        return null;
    }

    protected RevCommit doRemove(Git git, File rootDir, String branch, String path, String commitMessage, PersonIdent personIdent) throws Exception {
        File file = this.getFile(rootDir, path);
        if (file.exists()) {
            file.delete();
            String filePattern = GitFacadeSupport.getFilePattern(path);
            git.rm().addFilepattern(filePattern).call();
            CommitCommand commit = git.commit().setAll(true).setAuthor(personIdent).setMessage(commitMessage);
            return this.commitThenPush(git, branch, commit);
        }
        return null;
    }

    protected List<String> doListBranches(Git git) throws GitAPIException {
        TreeSet<String> names = new TreeSet<String>();
        List call = git.branchList().setListMode(ListBranchCommand.ListMode.ALL).call();
        for (Ref ref : call) {
            String name = ref.getName();
            int idx = name.lastIndexOf(47);
            if (idx >= 0) {
                name = name.substring(idx + 1);
            }
            if (name.length() <= 0) continue;
            names.add(name);
        }
        return new ArrayList<String>(names);
    }

    protected String doGetHead(Git git) {
        RevCommit commit = CommitUtils.getHead((Repository)git.getRepository());
        return commit.getName();
    }

    protected List<CommitInfo> doHistory(Git git, String branch, String objectId, String path, int limit) {
        Repository r = git.getRepository();
        CommitFinder finder = new CommitFinder(new Repository[]{r});
        CommitListFilter block = new CommitListFilter();
        if (Strings.isNotBlank((String)path)) {
            finder.setFilter(PathFilterUtils.and((String[])new String[]{path}));
        }
        finder.setFilter((RevFilter)block);
        if (limit > 0) {
            finder.setFilter((RevFilter)new CommitLimitFilter(100L).setStop(true));
        }
        if (Strings.isNotBlank((String)objectId)) {
            finder.findFrom(objectId);
        } else if (Strings.isNotBlank((String)branch)) {
            RevCommit base = CommitUtils.getBase((Repository)r, (String[])new String[]{branch});
            finder.findFrom((ObjectId)base);
        } else {
            finder.find();
        }
        List commits = block.getCommits();
        ArrayList<CommitInfo> results = new ArrayList<CommitInfo>();
        for (RevCommit entry : commits) {
            CommitInfo commitInfo = this.createCommitInfo(entry);
            results.add(commitInfo);
        }
        return results;
    }

    protected String getDefaultObjectName() {
        return "io.hawt.git:type=GitFacade";
    }

    protected String doGetContent(Git git, String objectId, String blobPath) {
        objectId = this.defaultObjectId(git, objectId);
        Repository r = git.getRepository();
        return BlobUtils.getContent((Repository)r, (String)objectId, (String)blobPath);
    }

    protected String defaultObjectId(Git git, String objectId) {
        if (objectId == null || objectId.trim().length() == 0) {
            RevCommit commit = CommitUtils.getHead((Repository)git.getRepository());
            objectId = commit.getName();
        }
        return objectId;
    }

    protected FileContents doRead(Git git, File rootDir, String branch, String pathOrEmpty) throws IOException, GitAPIException {
        this.checkoutBranch(git, branch);
        String path = Strings.isBlank((String)pathOrEmpty) ? "/" : pathOrEmpty;
        File file = this.getFile(rootDir, path);
        if (file.isFile()) {
            String contents = IOHelper.readFully((File)file);
            return new FileContents(false, contents, null);
        }
        ArrayList<FileInfo> children = new ArrayList<FileInfo>();
        if (file.exists()) {
            File[] files;
            for (File child : files = file.listFiles()) {
                if (this.isIgnoreFile(child)) continue;
                children.add(FileInfo.createFileInfo(rootDir, child));
            }
        }
        return new FileContents(file.isDirectory(), null, children);
    }

    protected FileInfo doExists(Git git, File rootDir, String branch, String pathOrEmpty) throws GitAPIException {
        this.checkoutBranch(git, branch);
        String path = Strings.isBlank((String)pathOrEmpty) ? "/" : pathOrEmpty;
        File file = this.getFile(rootDir, path);
        if (file.exists()) {
            return FileInfo.createFileInfo(rootDir, file);
        }
        return null;
    }

    protected List<String> doCompletePath(Git git, File rootDir, String branch, String completionText, boolean directoriesOnly) throws GitAPIException {
        this.checkoutBranch(git, branch);
        boolean empty = Strings.isBlank((String)completionText);
        String pattern = completionText;
        File file = this.getFile(rootDir, completionText);
        String prefix = completionText;
        if (file.exists()) {
            pattern = "";
        } else {
            int idx;
            String startPath = ".";
            if (!empty && (idx = completionText.lastIndexOf(47)) >= 0) {
                startPath = completionText.substring(0, idx);
                if (startPath.length() == 0) {
                    startPath = "/";
                }
                pattern = completionText.substring(idx + 1);
            }
            file = this.getFile(rootDir, startPath);
            prefix = startPath;
        }
        if (prefix.length() > 0 && !prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        if (prefix.equals("./")) {
            prefix = "";
        }
        File[] list = file.listFiles();
        ArrayList<String> answer = new ArrayList<String>();
        for (File aFile : list) {
            String name = aFile.getName();
            if (pattern.length() != 0 && !name.contains(pattern) || this.isIgnoreFile(aFile) || directoriesOnly && !aFile.isDirectory()) continue;
            answer.add(prefix + name);
        }
        return answer;
    }

    protected String doReadJsonChildContent(Git git, File rootDir, String branch, String path, String fileNameWildcard, String search) throws GitAPIException, IOException {
        this.checkoutBranch(git, branch);
        File file = this.getFile(rootDir, path);
        FileFilter filter = FileFilters.createFileFilter((String)fileNameWildcard);
        boolean first = true;
        StringBuilder buffer = new StringBuilder("{\n");
        ArrayList<FileInfo> children = new ArrayList<FileInfo>();
        if (file.isDirectory() && file.exists()) {
            File[] files;
            for (File child : files = file.listFiles()) {
                if (this.isIgnoreFile(child) || !child.isFile()) continue;
                String text = IOHelper.readFully((File)child);
                if (Strings.isNotBlank((String)search) && !text.contains(search)) continue;
                if (first) {
                    first = false;
                } else {
                    buffer.append(",\n");
                }
                buffer.append("\"");
                buffer.append(child.getName());
                buffer.append("\": ");
                buffer.append(text);
                children.add(FileInfo.createFileInfo(rootDir, child));
            }
        }
        buffer.append("\n}");
        return buffer.toString();
    }

    protected CommitInfo doWrite(Git git, File rootDir, String branch, String path, String contents, PersonIdent personIdent, String commitMessage) throws Exception {
        File file = this.getFile(rootDir, path);
        file.getParentFile().mkdirs();
        IOHelper.write((File)file, (String)contents);
        String filePattern = GitFacadeSupport.getFilePattern(path);
        AddCommand add = git.add().addFilepattern(filePattern).addFilepattern(".");
        add.call();
        CommitCommand commit = git.commit().setAll(true).setAuthor(personIdent).setMessage(commitMessage);
        RevCommit revCommit = this.commitThenPush(git, branch, commit);
        return this.createCommitInfo(revCommit);
    }

    protected static String getFilePattern(String path) {
        String filePattern = path;
        if (filePattern.startsWith("/")) {
            filePattern = filePattern.substring(1);
        }
        return filePattern;
    }

    protected RevCommit commitThenPush(Git git, String branch, CommitCommand commit) throws Exception {
        RevCommit answer = commit.call();
        LOG.info("Committed " + answer.getId() + " " + answer.getFullMessage());
        if (this.isPushOnCommit()) {
            Iterable<PushResult> results = this.doPush(git);
            for (PushResult result : results) {
                LOG.info("Pushed " + result.getMessages() + " " + result.getURI() + " branch: " + branch + " updates:  " + this.toString(result.getRemoteUpdates()));
            }
        }
        return answer;
    }

    protected String toString(Collection<RemoteRefUpdate> updates) {
        StringBuilder builder = new StringBuilder();
        for (RemoteRefUpdate update : updates) {
            if (builder.length() > 0) {
                builder.append(" ");
            }
            builder.append(update.getMessage() + " " + update.getRemoteName() + " " + update.getNewObjectId());
        }
        return builder.toString();
    }

    public CommitInfo createCommitInfo(RevCommit entry) {
        Date date = GitFacade.getCommitDate(entry);
        String author = entry.getAuthorIdent().getName();
        boolean merge = entry.getParentCount() > 1;
        String shortMessage = entry.getShortMessage();
        String trimmedMessage = Strings.trimString((String)shortMessage, (int)78);
        String name = entry.getName();
        String commitHashText = this.getShortCommitHash(name);
        return new CommitInfo(commitHashText, name, author, date, merge, trimmedMessage, shortMessage);
    }

    protected String getShortCommitHash(String name) {
        int hashLen = this.shortCommitIdLength;
        return name.substring(0, hashLen);
    }

    protected String removeLeadingSlash(String path) {
        if (path.startsWith("/")) {
            return path.substring(1);
        }
        return path;
    }

    protected boolean isIgnoreFile(File child) {
        return child.getName().startsWith(".");
    }

    protected File getFile(File rootDir, String path) {
        return new File(rootDir, this.removeLeadingSlash(path));
    }
}

