/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.filter.commit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.gitective.core.TreeUtils;
import org.gitective.core.filter.commit.CommitFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitDiffFilter
extends CommitFilter {
    protected final boolean detectRenames;
    protected RenameDetector renameDetector;

    public CommitDiffFilter() {
        this(false);
    }

    public CommitDiffFilter(boolean detectRenames) {
        this.detectRenames = detectRenames;
    }

    @Override
    public CommitFilter setRepository(Repository repository) {
        if (this.detectRenames) {
            this.renameDetector = new RenameDetector(repository);
        }
        return super.setRepository(repository);
    }

    protected TreeWalk createTreeWalk(RevWalk walker, RevCommit commit) {
        TreeWalk walk = TreeUtils.diffWithParents(walker, commit);
        walk.setRecursive(true);
        return walk;
    }

    public boolean include(RevWalk walker, RevCommit commit) throws IOException {
        ArrayList<DiffEntry> diffs;
        TreeWalk walk = this.createTreeWalk(walker, commit);
        int treeCount = walk.getTreeCount();
        switch (treeCount) {
            case 0: 
            case 1: {
                diffs = Collections.emptyList();
                break;
            }
            case 2: {
                diffs = DiffEntry.scan((TreeWalk)walk);
                break;
            }
            default: {
                diffs = new ArrayList<DiffEntry>();
                MutableObjectId currentId = new MutableObjectId();
                int currentTree = treeCount - 1;
                while (walk.next()) {
                    int currentMode = walk.getRawMode(currentTree);
                    int parentMode = 0;
                    boolean same = false;
                    for (int i = 0; i < currentTree; ++i) {
                        int mode = walk.getRawMode(i);
                        boolean bl = same = mode == currentMode && walk.idEqual(currentTree, i);
                        if (same) break;
                        parentMode |= mode;
                    }
                    if (same) continue;
                    LocalDiffEntry diff = new LocalDiffEntry(walk.getPathString());
                    diff.setOldMode(FileMode.fromBits((int)parentMode));
                    diff.setNewMode(FileMode.fromBits((int)currentMode));
                    walk.getObjectId(currentId, currentTree);
                    diff.setNewId(AbbreviatedObjectId.fromObjectId((AnyObjectId)currentId));
                    if (parentMode == 0 && currentMode != 0) {
                        diff.setChangeType(DiffEntry.ChangeType.ADD);
                    } else if (parentMode != 0 && currentMode == 0) {
                        diff.setChangeType(DiffEntry.ChangeType.DELETE);
                    } else {
                        diff.setChangeType(DiffEntry.ChangeType.MODIFY);
                    }
                    diffs.add(diff);
                }
                break block0;
            }
        }
        if (this.detectRenames) {
            this.renameDetector.reset();
            this.renameDetector.addAll(diffs);
            return this.include(walker, commit, this.renameDetector.compute(walker.getObjectReader(), (ProgressMonitor)NullProgressMonitor.INSTANCE)) ? true : this.include(false);
        }
        return this.include(walker, commit, diffs) ? true : this.include(false);
    }

    protected boolean isFileDiff(DiffEntry diff) {
        switch (diff.getChangeType()) {
            case DELETE: {
                return 32768 == (diff.getOldMode().getBits() & 0xF000);
            }
            case ADD: {
                return 32768 == (diff.getNewMode().getBits() & 0xF000);
            }
        }
        return 32768 == (diff.getOldMode().getBits() & 0xF000) && 32768 == (diff.getNewMode().getBits() & 0xF000);
    }

    public boolean include(RevWalk walker, RevCommit commit, Collection<DiffEntry> diffs) throws IOException {
        return this.include(commit, diffs);
    }

    public boolean include(RevCommit commit, Collection<DiffEntry> diffs) throws IOException {
        return true;
    }

    private static class LocalDiffEntry
    extends DiffEntry {
        public LocalDiffEntry(String path) {
            this.oldPath = path;
            this.newPath = path;
        }

        private LocalDiffEntry setOldMode(FileMode mode) {
            this.oldMode = mode;
            return this;
        }

        private LocalDiffEntry setNewMode(FileMode mode) {
            this.newMode = mode;
            return this;
        }

        private LocalDiffEntry setChangeType(DiffEntry.ChangeType type) {
            this.changeType = type;
            return this;
        }

        private LocalDiffEntry setNewId(AbbreviatedObjectId id) {
            this.newId = id;
            return this;
        }
    }
}

