/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.codec;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.linkedin.util.codec.OneWayCodec;

public class OneWayMessageDigestCodec
implements OneWayCodec {
    public static final String MODULE = OneWayMessageDigestCodec.class.getName();
    private final MessageDigest _md;
    private final OneWayCodec _codec;

    public OneWayMessageDigestCodec(String algorithm, OneWayCodec codec) throws NoSuchAlgorithmException, CloneNotSupportedException {
        this(algorithm, null, codec);
    }

    public OneWayMessageDigestCodec(String algorithm, String password, OneWayCodec codec) throws NoSuchAlgorithmException, CloneNotSupportedException {
        this._md = MessageDigest.getInstance(algorithm);
        if (password != null) {
            this._md.update(password.getBytes());
        }
        this._md.clone();
        this._codec = codec;
    }

    public OneWayMessageDigestCodec(MessageDigest md, OneWayCodec codec) throws CloneNotSupportedException {
        this._md = md;
        this._md.clone();
        this._codec = codec;
    }

    @Override
    public String encode(byte[] byteArray) {
        MessageDigest md = null;
        try {
            md = (MessageDigest)this._md.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return this._codec.encode(md.digest(byteArray));
    }

    public static OneWayMessageDigestCodec createMD5Instance(OneWayCodec codec) {
        return OneWayMessageDigestCodec.createMD5Instance(null, codec);
    }

    public static OneWayMessageDigestCodec createMD5Instance(String password, OneWayCodec codec) {
        return OneWayMessageDigestCodec.createWellKnownInstance("MD5", password, codec);
    }

    public static OneWayMessageDigestCodec createSHA1Instance(OneWayCodec codec) {
        return OneWayMessageDigestCodec.createSHA1Instance(null, codec);
    }

    public static OneWayMessageDigestCodec createSHA1Instance(String password, OneWayCodec codec) {
        return OneWayMessageDigestCodec.createWellKnownInstance("SHA-1", password, codec);
    }

    private static OneWayMessageDigestCodec createWellKnownInstance(String algorithm, String password, OneWayCodec codec) {
        try {
            return new OneWayMessageDigestCodec(algorithm, password, codec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

