/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport;

import java.net.InetAddress;
import java.net.URI;
import org.apache.activemq.transport.SocketConnectorFactory;
import org.apache.activemq.transport.TransportServerSupport;
import org.apache.activemq.util.InetAddressUtil;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;

public abstract class WebTransportServerSupport
extends TransportServerSupport {
    protected URI bindAddress;
    protected Server server;
    protected Connector connector;
    protected SocketConnectorFactory socketConnectorFactory;
    protected String host;

    public WebTransportServerSupport(URI location) {
        super(location);
    }

    public URI bind() throws Exception {
        URI bind = this.getBindLocation();
        String bindHost = bind.getHost();
        bindHost = bindHost == null || bindHost.length() == 0 ? "localhost" : bindHost;
        InetAddress addr = InetAddress.getByName(bindHost);
        this.host = addr.getCanonicalHostName();
        this.connector.setHost(this.host);
        this.connector.setPort(this.bindAddress.getPort());
        this.connector.setServer(this.server);
        this.server.addConnector(this.connector);
        if (addr.isAnyLocalAddress()) {
            this.host = InetAddressUtil.getLocalHostName();
        }
        URI boundUri = new URI(bind.getScheme(), bind.getUserInfo(), this.host, this.bindAddress.getPort(), bind.getPath(), bind.getQuery(), bind.getFragment());
        this.setConnectURI(boundUri);
        return boundUri;
    }
}

