/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto;

import gnu.classpath.ByteArray;
import gnu.classpath.debug.Component;
import gnu.classpath.debug.SystemLogger;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RSACipherImpl
extends CipherSpi {
    private static final Logger logger = SystemLogger.SYSTEM;
    private static final byte[] EMPTY = new byte[0];
    private int opmode;
    private RSAPrivateKey decipherKey;
    private RSAPublicKey blindingKey;
    private RSAPublicKey encipherKey;
    private SecureRandom random;
    private byte[] dataBuffer;
    private int pos;

    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException("only one mode available");
    }

    protected void engineSetPadding(String pad) throws NoSuchPaddingException {
        throw new NoSuchPaddingException("only one padding available");
    }

    protected int engineGetBlockSize() {
        return 1;
    }

    protected int engineGetOutputSize(int inputLen) {
        int outputLen = 0;
        if (this.decipherKey != null) {
            outputLen = (this.decipherKey.getModulus().bitLength() + 7) / 8;
        } else if (this.encipherKey != null) {
            outputLen = (this.encipherKey.getModulus().bitLength() + 7) / 8;
        } else {
            throw new IllegalStateException("not initialized");
        }
        if (inputLen > outputLen) {
            throw new IllegalArgumentException("not configured to encode " + inputLen + "bytes; at most " + outputLen);
        }
        return outputLen;
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (!(key instanceof RSAKey)) {
            throw new InvalidKeyException("not an RSA key");
        }
        return ((RSAKey)((Object)key)).getModulus().bitLength();
    }

    protected byte[] engineGetIV() {
        return null;
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        int outputLen = 0;
        if (opmode == 1) {
            if (!(key instanceof RSAPublicKey)) {
                throw new InvalidKeyException("expecting a RSAPublicKey");
            }
            this.encipherKey = (RSAPublicKey)key;
            this.decipherKey = null;
            this.blindingKey = null;
            outputLen = (this.encipherKey.getModulus().bitLength() + 7) / 8;
        } else {
            if (opmode != 2) throw new IllegalArgumentException("only encryption and decryption supported");
            if (key instanceof RSAPrivateKey) {
                this.decipherKey = (RSAPrivateKey)key;
                this.encipherKey = null;
                this.blindingKey = null;
                outputLen = (this.decipherKey.getModulus().bitLength() + 7) / 8;
            } else {
                if (!(key instanceof RSAPublicKey)) throw new InvalidKeyException("expecting either an RSAPrivateKey or an RSAPublicKey (for blinding)");
                if (this.decipherKey == null) {
                    throw new IllegalStateException("must configure decryption key first");
                }
                if (!this.decipherKey.getModulus().equals(((RSAPublicKey)key).getModulus())) {
                    throw new InvalidKeyException("blinding key is not compatible");
                }
                this.blindingKey = (RSAPublicKey)key;
                return;
            }
        }
        this.random = random;
        this.opmode = opmode;
        this.pos = 0;
        this.dataBuffer = new byte[outputLen];
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec spec, SecureRandom random) throws InvalidKeyException {
        this.engineInit(opmode, key, random);
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException {
        this.engineInit(opmode, key, random);
    }

    protected byte[] engineUpdate(byte[] in, int offset, int length) {
        if (this.opmode != 1 && this.opmode != 2) {
            throw new IllegalStateException("not initialized");
        }
        System.arraycopy(in, offset, this.dataBuffer, this.pos, length);
        this.pos += length;
        return EMPTY;
    }

    protected int engineUpdate(byte[] in, int offset, int length, byte[] out, int outOffset) {
        this.engineUpdate(in, offset, length);
        return 0;
    }

    protected byte[] engineDoFinal(byte[] in, int offset, int length) throws IllegalBlockSizeException, BadPaddingException {
        this.engineUpdate(in, offset, length);
        if (this.opmode == 2) {
            if (this.pos < this.dataBuffer.length) {
                throw new IllegalBlockSizeException("expecting exactly " + this.dataBuffer.length + " bytes");
            }
            BigInteger enc = new BigInteger(1, this.dataBuffer);
            byte[] dec = this.rsaDecrypt(enc);
            logger.log((Level)Component.CRYPTO, "RSA: decryption produced\n{0}", new ByteArray(dec));
            if (dec[0] != 2) {
                throw new BadPaddingException("expected padding type 2");
            }
            int i = 1;
            while (i < dec.length && dec[i] != 0) {
                ++i;
            }
            int len = dec.length - i;
            byte[] result = new byte[len];
            System.arraycopy(dec, i, result, 0, len);
            this.pos = 0;
            return result;
        }
        offset = this.dataBuffer.length - this.pos;
        if (offset < 3) {
            throw new IllegalBlockSizeException("input is too large to encrypt");
        }
        byte[] dec = new byte[this.dataBuffer.length];
        dec[0] = 2;
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        byte[] pad = new byte[offset - 2];
        this.random.nextBytes(pad);
        int i = 0;
        while (i < pad.length) {
            if (pad[i] == 0) {
                pad[i] = 1;
            }
            ++i;
        }
        System.arraycopy(pad, 0, dec, 1, pad.length);
        dec[dec.length - this.pos] = 0;
        System.arraycopy(this.dataBuffer, 0, dec, offset, this.pos);
        logger.log((Level)Component.CRYPTO, "RSA: produced padded plaintext\n{0}", new ByteArray(dec));
        BigInteger x = new BigInteger(1, dec);
        BigInteger y = x.modPow(this.encipherKey.getPublicExponent(), this.encipherKey.getModulus());
        byte[] enc = y.toByteArray();
        if (enc[0] == 0) {
            byte[] tmp = new byte[enc.length - 1];
            System.arraycopy(enc, 1, tmp, 0, tmp.length);
            enc = tmp;
        }
        this.pos = 0;
        return enc;
    }

    protected int engineDoFinal(byte[] out, int offset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        byte[] result = this.engineDoFinal(EMPTY, 0, 0);
        if (out.length - offset < result.length) {
            throw new ShortBufferException("need " + result.length + ", have " + (out.length - offset));
        }
        System.arraycopy(result, 0, out, offset, result.length);
        return result.length;
    }

    protected int engineDoFinal(byte[] input, int offset, int length, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        byte[] result = this.engineDoFinal(input, offset, length);
        if (output.length - outputOffset < result.length) {
            throw new ShortBufferException("need " + result.length + ", have " + (output.length - outputOffset));
        }
        System.arraycopy(result, 0, output, outputOffset, result.length);
        return result.length;
    }

    private final byte[] rsaDecrypt(BigInteger enc) {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        BigInteger n = this.decipherKey.getModulus();
        BigInteger r = null;
        BigInteger pubExp = null;
        if (this.blindingKey != null) {
            pubExp = this.blindingKey.getPublicExponent();
        }
        if (pubExp != null && this.decipherKey instanceof RSAPrivateCrtKey) {
            pubExp = ((RSAPrivateCrtKey)this.decipherKey).getPublicExponent();
        }
        if (pubExp != null) {
            r = new BigInteger(n.bitLength() - 1, this.random);
            enc = r.modPow(pubExp, n).multiply(enc).mod(n);
        }
        BigInteger dec = enc.modPow(this.decipherKey.getPrivateExponent(), n);
        if (pubExp != null) {
            dec = dec.multiply(r.modInverse(n)).mod(n);
        }
        return dec.toByteArray();
    }

    private final /* synthetic */ void this() {
        this.opmode = -1;
        this.decipherKey = null;
        this.blindingKey = null;
        this.encipherKey = null;
        this.random = null;
        this.dataBuffer = null;
        this.pos = 0;
    }

    public RSACipherImpl() {
        this.this();
    }
}

