#declare STAT
#declare PT
#set STAT = $setdatefmt(yyyy-mm-dd)

#proc getdata
file: timewin.dta

#proc areadef
yscaletype: pltab
xscaletype: date  yyyy-mm-dd
xrange: 1999-01-01 2005-01-01

// do bottom axis..
#proc xaxis
stubs: incremental 1 year
minorticinc: 1 month
stubformat: 'yy
grid: width=0.2
label: Year

// do top axis..
#proc xaxis
location: max
stubs: incremental 1 year
stubdetails: adjust=0,0.25
minorticinc: 1 month
ticlen: 0 0.06
minorticlen: 0 0.03
stubformat: 'yy
label: Visit Windows
labeldetails: adjust=0,0.8

#proc yaxis
ticincrement: 1
grid: color=pink


#loop
  #set PT = $nextstub(5)
  #if $strlen(@PT) < 1
    #break
  #endif
  #if $isnumber( @PT ) = 0
    #continue
  #endif

  #proc transform
  stack: yes
  action: select
  select: @@1 = @PT

  #proc bars
  locfield: 1 
  horizontalbars: yes
  segmentfields: 3 5 
  color: purple
  barwidth: 0.01

  #proc scatterplot
  xfield: 4
  yfield: 1
  labelfield: 2
  textdetails: adjust=0,0.06

  #proc originaldata

#endloop
