/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class BasicTableHeaderUI
extends TableHeaderUI {
    protected JTableHeader header;
    protected MouseInputListener mouseInputListener = this.createMouseInputListener();
    protected CellRendererPane rendererPane;
    protected Border cellBorder;

    public static ComponentUI createUI(JComponent h) {
        return new BasicTableHeaderUI();
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.header, "TableHeader.background", "TableHeader.foreground", "TableHeader.font");
        this.cellBorder = UIManager.getBorder("TableHeader.cellBorder");
    }

    protected void installKeyboardActions() {
    }

    protected void installListeners() {
        this.header.addMouseListener(this.mouseInputListener);
    }

    public void installUI(JComponent c) {
        this.header = (JTableHeader)c;
        this.installDefaults();
        this.installKeyboardActions();
        this.installListeners();
    }

    protected void uninstallDefaults() {
        this.header.setBackground(null);
        this.header.setForeground(null);
        this.header.setFont(null);
    }

    protected void uninstallKeyboardActions() {
    }

    protected void uninstallListeners() {
        this.header.removeMouseListener(this.mouseInputListener);
    }

    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.uninstallDefaults();
    }

    public void paint(Graphics gfx, JComponent c) {
        TableColumnModel cmod = this.header.getColumnModel();
        int ncols = cmod.getColumnCount();
        if (ncols == 0) {
            return;
        }
        Rectangle clip = gfx.getClipBounds();
        TableCellRenderer defaultRend = this.header.getDefaultRenderer();
        int i = 0;
        while (i < ncols) {
            Rectangle bounds = this.header.getHeaderRect(i);
            if (bounds.intersects(clip)) {
                Rectangle oldClip = gfx.getClipBounds();
                TableColumn col = cmod.getColumn(i);
                TableCellRenderer rend = col.getHeaderRenderer();
                if (rend == null) {
                    rend = defaultRend;
                }
                Object val = col.getHeaderValue();
                Component comp = rend.getTableCellRendererComponent(this.header.getTable(), val, false, false, -1, i);
                comp.setFont(this.header.getFont());
                comp.setBackground(this.header.getBackground());
                comp.setForeground(this.header.getForeground());
                if (comp instanceof JComponent) {
                    ((JComponent)comp).setBorder(this.cellBorder);
                }
                gfx.translate(bounds.x, bounds.y);
                gfx.setClip(0, 0, bounds.width, bounds.height);
                comp.setSize(bounds.width, bounds.height);
                comp.setLocation(0, 0);
                comp.paint(gfx);
                gfx.translate(-bounds.x, -bounds.y);
                gfx.setClip(oldClip);
            }
            ++i;
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        TableColumnModel cmod = this.header.getColumnModel();
        TableCellRenderer defaultRend = this.header.getDefaultRenderer();
        int ncols = cmod.getColumnCount();
        Dimension ret = new Dimension(0, 0);
        int spacing = 0;
        if (this.header.getTable() != null && this.header.getTable().getIntercellSpacing() != null) {
            spacing = this.header.getTable().getIntercellSpacing().width;
        }
        int i = 0;
        while (i < ncols) {
            TableColumn col = cmod.getColumn(i);
            TableCellRenderer rend = col.getHeaderRenderer();
            if (rend == null) {
                rend = defaultRend;
            }
            Object val = col.getHeaderValue();
            Component comp = rend.getTableCellRendererComponent(this.header.getTable(), val, false, false, -1, i);
            comp.setFont(this.header.getFont());
            comp.setBackground(this.header.getBackground());
            comp.setForeground(this.header.getForeground());
            if (comp instanceof JComponent) {
                ((JComponent)comp).setBorder(this.cellBorder);
            }
            Dimension d = comp.getPreferredSize();
            ret.width += spacing;
            ret.height = Math.max(d.height, ret.height);
            ++i;
        }
        ret.width = cmod.getTotalColumnWidth();
        return ret;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class MouseInputHandler
    implements MouseInputListener {
        public void mouseClicked(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }
    }
}

