/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.beans.decoder;

import gnu.java.beans.decoder.AbstractElementHandler;
import gnu.java.beans.decoder.ArrayHandler;
import gnu.java.beans.decoder.AssemblyException;
import gnu.java.beans.decoder.BooleanHandler;
import gnu.java.beans.decoder.ByteHandler;
import gnu.java.beans.decoder.CharHandler;
import gnu.java.beans.decoder.ClassHandler;
import gnu.java.beans.decoder.Context;
import gnu.java.beans.decoder.DoubleHandler;
import gnu.java.beans.decoder.DummyHandler;
import gnu.java.beans.decoder.ElementHandler;
import gnu.java.beans.decoder.FloatHandler;
import gnu.java.beans.decoder.IntHandler;
import gnu.java.beans.decoder.JavaHandler;
import gnu.java.beans.decoder.LongHandler;
import gnu.java.beans.decoder.NullHandler;
import gnu.java.beans.decoder.ObjectHandler;
import gnu.java.beans.decoder.ShortHandler;
import gnu.java.beans.decoder.StringHandler;
import gnu.java.beans.decoder.VoidHandler;
import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PersistenceParser
extends DefaultHandler
implements Context {
    private ExceptionListener exceptionListener;
    private int skipElement;
    private HashMap handlerCreators;
    private ElementHandler currentHandler;
    JavaHandler javaHandler;
    private List objects;
    private XMLDecoder decoder;

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.currentHandler.hasFailed() || this.skipElement > 0) {
            this.exceptionListener.exceptionThrown(new IllegalArgumentException("Element unusable due to previous error: " + qName));
            ++this.skipElement;
            return;
        }
        if (!this.currentHandler.isSubelementAllowed(qName)) {
            this.exceptionListener.exceptionThrown(new IllegalArgumentException("Element is not allowed here: " + qName));
            ++this.skipElement;
            return;
        }
        if (!this.handlerCreators.containsKey(qName)) {
            this.exceptionListener.exceptionThrown(new IllegalArgumentException("Element unusable because tag is unknown: " + qName));
            ++this.skipElement;
            return;
        }
        AbstractElementHandler handler = ((Creator)this.handlerCreators.get(qName)).createHandler(this.currentHandler);
        this.currentHandler = handler;
        this.currentHandler.start(attributes, this.exceptionListener);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.skipElement > 0) {
            --this.skipElement;
            return;
        }
        this.currentHandler.end(this.exceptionListener);
        this.currentHandler = this.currentHandler.getParent();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.skipElement > 0) {
            return;
        }
        this.currentHandler.characters(ch, start, length);
    }

    public void addParameterObject(Object o) throws AssemblyException {
        this.objects.add(o);
    }

    public void notifyStatement(Context outerContext) throws AssemblyException {
    }

    public Object endContext(Context outerContext) throws AssemblyException {
        return null;
    }

    public boolean subContextFailed() {
        return false;
    }

    public void set(int index, Object o) throws AssemblyException {
        throw new AssemblyException(new IllegalArgumentException("Set method is not allowed in decoder context."));
    }

    public Object get(int index) throws AssemblyException {
        throw new AssemblyException(new IllegalArgumentException("Get method is not allowed in decoder context."));
    }

    public Object getResult() {
        return this.decoder;
    }

    public void setId(String id) {
        this.exceptionListener.exceptionThrown(new IllegalArgumentException("id attribute is not allowed for <java> tag."));
    }

    public String getId() {
        return null;
    }

    public boolean isStatement() {
        return true;
    }

    public void setStatement(boolean b) {
    }

    public Iterator iterator() {
        return this.objects.iterator();
    }

    private final /* synthetic */ void this() {
        this.handlerCreators = new HashMap();
        this.objects = new LinkedList();
    }

    public PersistenceParser(InputStream inputStream, ExceptionListener exceptionListener, ClassLoader cl, XMLDecoder decoder) {
        SAXParser parser;
        this.this();
        this.exceptionListener = exceptionListener;
        this.decoder = decoder;
        DummyHandler dummyHandler = new DummyHandler();
        this.currentHandler = dummyHandler;
        this.javaHandler = new JavaHandler(dummyHandler, this, cl);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            parser = factory.newSAXParser();
        }
        catch (ParserConfigurationException pce) {
            throw (InternalError)new InternalError("No SAX Parser available.").initCause(pce);
        }
        catch (SAXException saxe) {
            throw (InternalError)new InternalError("No SAX Parser available.").initCause(saxe);
        }
        this.handlerCreators.put("java", new JavaHandlerCreator());
        this.handlerCreators.put("object", new ObjectHandlerCreator());
        this.handlerCreators.put("void", new VoidHandlerCreator());
        this.handlerCreators.put("array", new ArrayHandlerCreator());
        this.handlerCreators.put("class", new ClassHandlerCreator());
        this.handlerCreators.put("null", new NullHandlerCreator());
        this.handlerCreators.put("char", new CharHandlerCreator());
        this.handlerCreators.put("string", new StringHandlerCreator());
        this.handlerCreators.put("boolean", new BooleanHandlerCreator());
        this.handlerCreators.put("byte", new ByteHandlerCreator());
        this.handlerCreators.put("short", new ShortHandlerCreator());
        this.handlerCreators.put("int", new IntHandlerCreator());
        this.handlerCreators.put("long", new LongHandlerCreator());
        this.handlerCreators.put("float", new FloatHandlerCreator());
        this.handlerCreators.put("double", new DoubleHandlerCreator());
        try {
            parser.parse(inputStream, (DefaultHandler)this);
        }
        catch (SAXException saxe) {
            exceptionListener.exceptionThrown(new IllegalArgumentException("XML data not well-formed."));
        }
        catch (IOException ioe) {
            exceptionListener.exceptionThrown(ioe);
        }
    }

    static interface Creator {
        public AbstractElementHandler createHandler(ElementHandler var1);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class JavaHandlerCreator
    implements Creator {
        public AbstractElementHandler createHandler(ElementHandler parent) {
            return PersistenceParser.this.javaHandler;
        }

        JavaHandlerCreator() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ObjectHandlerCreator
    implements Creator {
        public AbstractElementHandler createHandler(ElementHandler parent) {
            return new ObjectHandler(parent);
        }

        ObjectHandlerCreator() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class VoidHandlerCreator
    implements Creator {
        public AbstractElementHandler createHandler(ElementHandler parent) {
            return new VoidHandler(parent);
        }

        VoidHandlerCreator() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ArrayHandlerCreator
    implements Creator {
        public AbstractElementHandler createHandler(ElementHandler parent) {
            return new ArrayHandler(parent);
        }

        ArrayHandlerCreator() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ClassHandlerCreator
    implements Creator {
        public AbstractElementHandler createHandler(ElementHandler parent) {
            return new ClassHandler(parent);
        }

        ClassHandlerCreator() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class NullHandlerCreator
    implements Creator {
        public AbstractElementHandler createHandler(ElementHandler parent) {
            return new NullHandler(parent);
        }

        NullHandlerCreator() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class CharHandlerCreator
    implements Creator {
        public AbstractElementHandler createHandler(ElementHandler parent) {
            return new CharHandler(parent);
        }

        CharHandlerCreator() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class StringHandlerCreator
    implements Creator {
        public AbstractElementHandler createHandler(ElementHandler parent) {
            return new StringHandler(parent);
        }

        StringHandlerCreator() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BooleanHandlerCreator
    implements Creator {
        public AbstractElementHandler createHandler(ElementHandler parent) {
            return new BooleanHandler(parent);
        }

        BooleanHandlerCreator() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ByteHandlerCreator
    implements Creator {
        public AbstractElementHandler createHandler(ElementHandler parent) {
            return new ByteHandler(parent);
        }

        ByteHandlerCreator() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ShortHandlerCreator
    implements Creator {
        public AbstractElementHandler createHandler(ElementHandler parent) {
            return new ShortHandler(parent);
        }

        ShortHandlerCreator() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class IntHandlerCreator
    implements Creator {
        public AbstractElementHandler createHandler(ElementHandler parent) {
            return new IntHandler(parent);
        }

        IntHandlerCreator() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class LongHandlerCreator
    implements Creator {
        public AbstractElementHandler createHandler(ElementHandler parent) {
            return new LongHandler(parent);
        }

        LongHandlerCreator() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class FloatHandlerCreator
    implements Creator {
        public AbstractElementHandler createHandler(ElementHandler parent) {
            return new FloatHandler(parent);
        }

        FloatHandlerCreator() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class DoubleHandlerCreator
    implements Creator {
        public AbstractElementHandler createHandler(ElementHandler parent) {
            return new DoubleHandler(parent);
        }

        DoubleHandlerCreator() {
        }
    }
}

