package TDS::Admin::Comment;
# $Id: Comment.pm,v 1.8 2000/12/04 17:35:34 tom Exp $
################################################################


use strict;
use vars qw(@ISA);

use File::Copy;
use File::Basename;

use CGI::Tools;
use Template;

use TDS::Comment;
use TDS::Admin::Skelton;
use TDS::Admin::WriteServer;
use TDS::Admin::WriteServer::Selector;

@ISA = qw(TDS::Comment);

attributes qw();

################################################################

sub AsEditForm($)
{
    my $self = shift;

    open(F, $self->logfile) || return;
    my $html;
    my $i = 1;
    my $time = new DateTime::Time;
    while (<F>){
	chomp;
	my ($name, $id, $tm, $comment) = split(/\t/, Escape($_));
	my $date_str = "";
	unless ($comment){                # for old format (w/o $date)
	    $comment = $tm;
	} else {
	    $time->SetTime($tm);
	    $date_str = Expand($TDS::Comment::DateTemplate, $time->GetParams);
	}
	my $template = qq(<tr><td><input type="checkbox" name="$i">
			  <td>%date<td>%name<td>%comment\n);
	$html .=
	    Expand($template, {name=>$name, comment=>$comment,
			       date=>$date_str
			       });
	$i++;
    }
    close (F);

    my $skelton = new TDS::Admin::Skelton;
    $skelton->skelton(qq(<html><head><title><!--#macro cmd="TITLE" --></title>
			 </head><body>
			 <h1><!--#macro cmd="TITLE" --></h1>
			 <form action="comment.cgi" method="post">
			 <table border="1">
			 <!--#macro cmd="CONTENT" --></table>
			 <hr>
			 <input type="hidden" name="command" value="delete">
			 <!--#macro cmd="INPUT_PASSWORD" --><br>
			 <input type="submit" value="Delete">
			 <input type="reset" value="Reset">
			 </form>
			 </body></html>));
    $skelton->SetMacro("TITLE", "delete comments");
    $skelton->SetMacro("CONTENT", $html);
    return $skelton->AsHTML;
}
################################################################
sub DeleteComments($@)
{
    my ($self, @numbers) = @_;

    copy($self->logfile, $self->logfile . "-bak");
    
    open(F, $self->logfile) || return;
    my $i = 1;
    my $lines;
    while (<F>){
	my $line = $_;
	my $delete;
	for (@numbers){
	    if ($i == $_){
		$delete = 1;
		print "deleted: $line<br>";
		last;
	    }
	}
	unless ($delete){
	    $lines .= $_;
	}
	$i++;
    }
    close F;

    # write to server
    my $basename = basename($self->logfile);
    my $write_server =
	new TDS::Admin::WriteServer::Selector(type=>'log',
					      kind=>'comment');

    $write_server->Write($lines);
}
1;
