package SigSearch;
# $Id: SigSearch.pm,v 1.1.1.1 2000/01/25 17:00:55 tom Exp $
################################################################

=head1 NAME

SigSearch - ͥˡˤʰ׸

=head1 SYNOPSIS

 use SigSearch;

 yet..

=cut

use strict;
use vars qw(@ISA
	    $SIGBITS $SIGBYTES);

use ObjectTemplate;
@ISA = qw(ObjectTemplate);

use SimpleDB::Hash;

=head1 STATIC VARIABLES

 $SIGBYTES      ͥΥХĹ
 $SIGBITS       Ʊӥåȴ

=cut

$SIGBYTES = 1024;
$SIGBITS = $SIGBYTES * 6;


=head1 MEMBER VARIABLES

 @objects         оݥե륷ͥ

=cut

attributes qw(objects);


=head1 MEMBER FUNCTIONS

=cut

################################################################
sub initialize ($)
{
    my $self = shift;
    
    $self->objects([]);
    $self->SUPER::initialize;
}
################################################################

=head2 $s->CreateSigFile(@files);

ꤷե뷲饷ͥե

=cut

sub CreateSigFile($$@)
{
    my ($self, $sig_file, @files) = @_;

    open(SIGS, ">$sig_file") || die $sig_file;
    for (@files){
	printf(SIGS "%s\t%s\n", $_, file_sig($_));
    }
    close SIGS;
}


=head2 $s->UpdateSigFile(@files);

ꤷե뷲饷ͥե򹹿

=cut

sub UpdateSigFile($$@)
{
    my ($self, $sig_file, @files) = @_;

    my $sig_file_lm = (stat($sig_file))[9];

    my %hash;
    tie %hash, 'SimpleDB::Hash', $sig_file;
    print $hash{'dummy'};     # ʤѤˤʤ

    print "update: $sig_file:";
    for (@files){
	my $lm = (stat($_))[9];
	if ($lm > $sig_file_lm){    # sig_file 꿷й
	    print "$_, ";
	    $hash{$_} = file_sig($_);
	}
    }
    print "\n";

}

################################################################

=head2 $s->ReadSigFile;

sig_file 饷ͥɤ߹

ɤ߹ߤȿ֤

=cut

sub ReadSigFile($$)
{
    my ($self, $sig_file) = @_;

    return 0 unless -f $sig_file;
    
    my %db;
    tie %db, 'SimpleDB::Hash', $sig_file, 1;
#    print $db{"d:/tom/diary/1999/10/31.tdf"};
    print $db{'dummy'};    # ʤ tie ѿɤ߹ޤʤ褦
    push(@{$self->objects}, \%db);
    return 1;
}


=head2 $s->ReadSigFiles(@sig_files);

@sig_files 饷ͥɤ߹

=cut

sub ReadSigFiles($@)
{
    my ($self, @sig_files) = @_;
    my $flg;
    for (@sig_files){
	$flg &&= $self->ReadSigFile($_);
    }
    return $flg;
}

=head2 $s->Find($keyword);

оݥե뷲 $keyword ˹פե뷲֤

=cut

sub Find($$)
{
    my ($self, $keyword) = @_;

    my $key_sig = calc_sig($keyword);
#    print "key_sig: \n$key_sig\n";
    my @find_files;
    
    for (@{$self->objects}){
	my $hash = $_;
	my ($file, $sig);
#	while (($file, $sig) = each(%$hash)){
	for (sort keys %$hash){
#	    print "$file, $sig<br>";
	    if (match_sig($hash->{$_}, $key_sig)){
		push(@find_files, $_);
	    }
	}
    }
    return @find_files;
}

################################################################
# static functions
# ϥåͤ׻֤
sub hashpjw
{
    my $str = shift;

    my ($h, $g);
    
    for (0..length($str)-1){
	my $c = unpack("c", substr($str, $_, 1));
	$h = ($h<<4) + $c;
	if ($g = ($h & 0xf0000000)){
	    $h = $h ^ ($g >> 24);
	    $h = $h ^ $g;
	}
    }
    return $h;
}

# ͥ׻֤
sub calc_sig
{
    my $str = shift;
    
    my @sig;
    my $len = length($str);
    # 
    for (0..$SIGBYTES-1){
	$sig[$_] = 0x40;
    }
    # ͥ׻
    for(0..$len-3){
	my $v = hashpjw(substr($str, $_, 3)) % $SIGBITS;
	$sig[int($v/6)] |= (1 << $v%6);
    }
    # EUC פѴ
    my $rtn;
    for (0..$SIGBYTES-1){
	if ($sig[$_] == 0x7f){
	    $sig[$_] = 0x3f;
	}
	$rtn .= chr($sig[$_]);
    }
    # ʸȤ֤
    return $rtn;
}
################################################################
# Ϳ줿եΥ֤ͥ
sub file_sig ($)
{
    my $fname = shift;

    open(F, $fname) || die $fname;
    my $line = join('', <F>);
    close F;
    return calc_sig($line);
}
################################################################
# ĤΥͥӤ
sub match_sig ($$)
{
    my ($textsig, $patsig) = @_;

    for (0..$SIGBYTES-1){
	my $pat_char = unpack("c", substr($patsig, $_, 1)) & 0x3f;
	my $text_char = unpack("c", substr($textsig, $_, 1));
	if (($text_char & $pat_char) != $pat_char){
	    return 0;
	}
    }
    return 1;
}
    
1;

