(define (host) "armv6--netbsdelf-eabihf")

(define (machine-vendor-os)
  (let ((match (regexp-search (rx (submatch (+ (~ #\-))) "-"
                                  (submatch (+ (~ #\-))) "-"
                                  (submatch (+ any)))
                              (host))))
    (list (match:substring match 1)
          (match:substring match 2)
          (match:substring match 3))))

(define (machine)
  (car (machine-vendor-os)))

(define (vendor)
  (cadr (machine-vendor-os)))

(define (os)
  (caddr (machine-vendor-os)))

(define (prefix) "/usr/pkg")

(define (exec-prefix) "/usr/pkg")

(define (bin-dir) "/usr/pkg/bin")

(define (lib-dir) "/usr/pkg/lib")

(define (include-dir) "/usr/pkg/include")

(define (man-dir) "/usr/pkg/man/man1")

(define (lib-dirs-list) (quote ("/usr/pkg/lib/scsh/modules" "/usr/pkg/lib/scsh/modules/0.6")))

(define (libs) "-lelf -lcrypt -lm  -lutil")

(define (defs) "-DHAVE_CONFIG_H")

(define (cflags) "-O2")

(define (cppflags) "")

(define (ldflags) "-Wl,--export-dynamic -rdynamic")

(define (compiler-flags)
  (string-join (list "-I" (include-dir) (defs))))

(define (linker-flags)
  (string-join (list "-L" (lib-dir) (libs) "-lscsh") " "))

;;; Local Variables: 
;;; mode: Scheme
;;; End: 
