/*
 * Decompiled with CFR 0.152.
 */
package lts;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import lts.AutCompactState;
import lts.CompactState;
import lts.CompositeState;
import lts.CompositionExpression;
import lts.Diagnostics;
import lts.Expression;
import lts.LTSOutput;
import lts.ProcessSpec;
import lts.StateMachine;
import lts.Symbol;
import lts.Value;

class ProcessRef {
    Symbol name;
    Vector actualParams;

    ProcessRef() {
    }

    public void instantiate(CompositionExpression compositionExpression, Vector vector, LTSOutput lTSOutput, Hashtable hashtable) {
        CompositeState compositeState;
        Object object;
        Vector vector2 = this.paramValues(hashtable, compositionExpression);
        String string = vector2 == null ? this.name.toString() : this.name.toString() + StateMachine.paramString(vector2);
        CompactState compactState = (CompactState)compositionExpression.compiledProcesses.get(string);
        if (compactState != null) {
            vector.addElement(compactState.myclone());
            return;
        }
        ProcessSpec processSpec = (ProcessSpec)compositionExpression.processes.get(this.name.toString());
        if (processSpec != null) {
            if (this.actualParams != null && this.actualParams.size() != processSpec.parameters.size()) {
                Diagnostics.fatal("actuals do not match formal parameters", this.name);
            }
            if (!processSpec.imported()) {
                StateMachine stateMachine = new StateMachine(processSpec, vector2);
                compactState = stateMachine.makeCompactState();
            } else {
                compactState = new AutCompactState(processSpec.name, processSpec.importFile);
            }
            vector.addElement(compactState.myclone());
            compositionExpression.compiledProcesses.put(compactState.name, compactState);
            if (!processSpec.imported()) {
                compositionExpression.output.outln("Compiled: " + compactState.name);
            } else {
                compositionExpression.output.outln("Imported: " + compactState.name);
            }
            return;
        }
        CompositionExpression compositionExpression2 = (CompositionExpression)compositionExpression.composites.get(this.name.toString());
        if (compositionExpression2 == null) {
            Diagnostics.fatal("definition not found- " + this.name, this.name);
        }
        if (this.actualParams != null && this.actualParams.size() != compositionExpression2.parameters.size()) {
            Diagnostics.fatal("actuals do not match formal parameters", this.name);
        }
        if (compositionExpression2 == compositionExpression) {
            object = (Hashtable)compositionExpression.constants.clone();
            compositeState = compositionExpression2.compose(vector2);
            compositionExpression.constants = object;
        } else {
            compositeState = compositionExpression2.compose(vector2);
        }
        if (compositeState.needNotCreate()) {
            object = compositeState.machines.elements();
            while (object.hasMoreElements()) {
                compactState = (CompactState)object.nextElement();
                compactState.name = compositeState.name + "." + compactState.name;
            }
            vector.addElement(compositeState);
        } else {
            compactState = compositeState.create(lTSOutput);
            compositionExpression.compiledProcesses.put(compactState.name, compactState);
            compositionExpression.output.outln("Compiled: " + compactState.name);
            vector.addElement(compactState.myclone());
        }
    }

    private Vector paramValues(Hashtable hashtable, CompositionExpression compositionExpression) {
        if (this.actualParams == null) {
            return null;
        }
        Enumeration enumeration = this.actualParams.elements();
        Vector<Value> vector = new Vector<Value>();
        while (enumeration.hasMoreElements()) {
            Stack stack = (Stack)enumeration.nextElement();
            vector.addElement(Expression.getValue(stack, hashtable, compositionExpression.constants));
        }
        return vector;
    }
}

