/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdatavalidation.packet;

import java.math.BigInteger;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.datatypes.UInt32;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.FullyQualifiedElement;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.xdata.AbstractSingleStringValueFormField;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.FormFieldChildElement;
import org.jivesoftware.smackx.xdatavalidation.ValidationConsistencyException;

public abstract class ValidateElement
implements FormFieldChildElement {
    public static final String DATATYPE_XS_STRING = "xs:string";
    public static final String ELEMENT = "validate";
    public static final String NAMESPACE = "http://jabber.org/protocol/xdata-validate";
    public static final QName QNAME = new QName("http://jabber.org/protocol/xdata-validate", "validate");
    private final String datatype;
    private ListRange listRange;

    private ValidateElement(String datatype) {
        this.datatype = StringUtils.isNotEmpty((CharSequence)datatype) ? datatype : null;
    }

    public String getDatatype() {
        return this.datatype != null ? this.datatype : DATATYPE_XS_STRING;
    }

    public String getElementName() {
        return ELEMENT;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public QName getQName() {
        return QNAME;
    }

    @Override
    public final boolean mustBeOnlyOfHisKind() {
        return true;
    }

    public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
        XmlStringBuilder buf = new XmlStringBuilder((FullyQualifiedElement)this, enclosingNamespace);
        buf.optAttribute("datatype", this.datatype);
        buf.rightAngleBracket();
        this.appendXML(buf);
        buf.optAppend((Element)this.getListRange());
        buf.closeElement((NamedElement)this);
        return buf;
    }

    protected abstract void appendXML(XmlStringBuilder var1);

    public void setListRange(ListRange listRange) {
        this.listRange = listRange;
    }

    public ListRange getListRange() {
        return this.listRange;
    }

    @Override
    public abstract void checkConsistency(FormField.Builder<?, ?> var1);

    public static ValidateElement from(FormField formField) {
        return (ValidateElement)formField.getFormFieldChildElement(QNAME);
    }

    protected void checkListRangeConsistency(FormField.Builder<?, ?> formField) {
        ListRange listRange = this.getListRange();
        if (listRange == null) {
            return;
        }
        UInt32 max = listRange.getMax();
        UInt32 min = listRange.getMin();
        if ((max != null || min != null) && formField.getType() != FormField.Type.list_multi) {
            throw new ValidationConsistencyException("Field type is not of type 'list-multi' while a 'list-range' is defined.");
        }
    }

    protected void checkNonMultiConsistency(FormField.Builder<?, ?> formField, String method) {
        this.checkListRangeConsistency(formField);
        if (formField.getType() != null) {
            switch (formField.getType()) {
                case hidden: 
                case jid_multi: 
                case list_multi: 
                case text_multi: {
                    throw new ValidationConsistencyException(String.format("Field type '%1$s' is not consistent with validation method '%2$s'.", new Object[]{formField.getType(), method}));
                }
            }
        }
    }

    public static class ListRange
    implements FullyQualifiedElement {
        public static final String ELEMENT = "list-range";
        private final UInt32 min;
        private final UInt32 max;

        public ListRange(Long min, Long max) {
            this(min != null ? UInt32.from((long)min) : null, max != null ? UInt32.from((long)max) : null);
        }

        public ListRange(UInt32 min, UInt32 max) {
            if (max == null && min == null) {
                throw new IllegalArgumentException("Either min or max must be given");
            }
            this.min = min;
            this.max = max;
        }

        public XmlStringBuilder toXML(XmlEnvironment enclosingXmlEnvironment) {
            XmlStringBuilder buf = new XmlStringBuilder((FullyQualifiedElement)this, enclosingXmlEnvironment);
            buf.optAttributeCs("min", (CharSequence)this.getMin());
            buf.optAttributeCs("max", (CharSequence)this.getMax());
            buf.closeEmptyElement();
            return buf;
        }

        public String getElementName() {
            return ELEMENT;
        }

        public UInt32 getMin() {
            return this.min;
        }

        public UInt32 getMax() {
            return this.max;
        }

        public String getNamespace() {
            return ValidateElement.NAMESPACE;
        }
    }

    public static class RegexValidateElement
    extends ValidateElement {
        public static final String METHOD = "regex";
        private final String regex;

        public RegexValidateElement(String datatype, String regex) {
            super(datatype);
            this.regex = regex;
        }

        public String getRegex() {
            return this.regex;
        }

        @Override
        protected void appendXML(XmlStringBuilder buf) {
            buf.element(METHOD, this.getRegex());
        }

        @Override
        public void checkConsistency(FormField.Builder<?, ?> formField) {
            this.checkNonMultiConsistency(formField, METHOD);
        }
    }

    public static class RangeValidateElement
    extends ValidateElement {
        public static final String METHOD = "range";
        private final String min;
        private final String max;

        public RangeValidateElement(String datatype, String min, String max) {
            super(datatype);
            this.min = min;
            this.max = max;
        }

        @Override
        protected void appendXML(XmlStringBuilder buf) {
            buf.halfOpenElement(METHOD);
            buf.optAttribute("min", this.getMin());
            buf.optAttribute("max", this.getMax());
            buf.closeEmptyElement();
        }

        public String getMin() {
            return this.min;
        }

        public String getMax() {
            return this.max;
        }

        @Override
        public void checkConsistency(FormField.Builder<?, ?> formField) {
            this.checkNonMultiConsistency(formField, METHOD);
            if (this.getDatatype().equals(ValidateElement.DATATYPE_XS_STRING)) {
                throw new ValidationConsistencyException(String.format("Field data type '%1$s' is not consistent with validation method '%2$s'.", this.getDatatype(), METHOD));
            }
        }

        @Override
        public void validate(FormField formField) {
            AbstractSingleStringValueFormField singleValueFormField = formField.ifPossibleAs(AbstractSingleStringValueFormField.class);
            if (singleValueFormField == null) {
                return;
            }
            String valueString = singleValueFormField.getValue();
            switch (this.getDatatype()) {
                case "xs:int": 
                case "xs:integer": {
                    BigInteger max;
                    BigInteger min;
                    BigInteger value = new BigInteger(valueString);
                    String minString = this.getMin();
                    if (minString != null && value.compareTo(min = new BigInteger(minString)) < 0) {
                        throw new IllegalArgumentException("The provided value " + valueString + " is lower than the allowed minimum of " + minString);
                    }
                    String maxString = this.getMax();
                    if (maxString == null || value.compareTo(max = new BigInteger(maxString)) <= 0) break;
                    throw new IllegalArgumentException("The provided value " + valueString + " is higher than the allowed maximum of " + maxString);
                }
            }
        }
    }

    public static class OpenValidateElement
    extends ValidateElement {
        public static final String METHOD = "open";

        public OpenValidateElement(String datatype) {
            super(datatype);
        }

        @Override
        protected void appendXML(XmlStringBuilder buf) {
            buf.emptyElement(METHOD);
        }

        @Override
        public void checkConsistency(FormField.Builder<?, ?> formField) {
            this.checkListRangeConsistency(formField);
            if (formField.getType() != null) {
                switch (formField.getType()) {
                    case hidden: {
                        throw new ValidationConsistencyException(String.format("Field type '%1$s' is not consistent with validation method '%2$s'.", new Object[]{formField.getType(), METHOD}));
                    }
                }
            }
        }
    }

    public static class BasicValidateElement
    extends ValidateElement {
        public static final String METHOD = "basic";

        public BasicValidateElement(String datatype) {
            super(datatype);
        }

        @Override
        protected void appendXML(XmlStringBuilder buf) {
            buf.emptyElement(METHOD);
        }

        @Override
        public void checkConsistency(FormField.Builder<?, ?> formField) {
            this.checkListRangeConsistency(formField);
            if (formField.getType() != null) {
                switch (formField.getType()) {
                    case hidden: 
                    case jid_multi: 
                    case jid_single: {
                        throw new ValidationConsistencyException(String.format("Field type '%1$s' is not consistent with validation method '%2$s'.", new Object[]{formField.getType(), METHOD}));
                    }
                }
            }
        }
    }
}

