/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.util.NotMutable;
import com.unboundid.util.NullOutputStream;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.File;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ToolInvocationLogDetails {
    private final boolean logInvocation;
    private final PrintStream toolErrorStream;
    private final Set<File> logFiles;
    private final String commandName;
    private final String invocationID;

    private ToolInvocationLogDetails(boolean logInvocation, String commandName, String invocationID, Set<File> logFiles, PrintStream toolErrorStream) {
        this.logInvocation = logInvocation;
        this.commandName = commandName;
        this.toolErrorStream = toolErrorStream;
        this.invocationID = invocationID == null ? UUID.randomUUID().toString() : invocationID;
        this.logFiles = logFiles == null ? Collections.emptySet() : Collections.unmodifiableSet(logFiles);
    }

    static ToolInvocationLogDetails createDoNotLogDetails(String commandName) {
        return new ToolInvocationLogDetails(false, commandName, "", Collections.emptySet(), NullOutputStream.getPrintStream());
    }

    static ToolInvocationLogDetails createLogDetails(String commandName, String invocationID, Set<File> logFiles, PrintStream toolErrorStream) {
        return new ToolInvocationLogDetails(true, commandName, invocationID, logFiles, toolErrorStream);
    }

    public String getCommandName() {
        return this.commandName;
    }

    public boolean logInvocation() {
        return this.logInvocation;
    }

    public String getInvocationID() {
        return this.invocationID;
    }

    public Set<File> getLogFiles() {
        return this.logFiles;
    }

    public PrintStream getToolErrorStream() {
        return this.toolErrorStream;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("ToolInvocationLogDetails(commandName='");
        buffer.append(this.commandName);
        buffer.append("', logInvocation=");
        buffer.append(this.logInvocation);
        if (this.logInvocation) {
            buffer.append(", invocationID='");
            buffer.append(this.invocationID);
            buffer.append("', logFiles={");
            Iterator<File> fileIterator = this.logFiles.iterator();
            while (fileIterator.hasNext()) {
                buffer.append('\'');
                buffer.append(fileIterator.next().getAbsolutePath());
                buffer.append('\'');
                if (!fileIterator.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

