/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum EntryRight {
    ADD("add"),
    DELETE("delete"),
    READ("read"),
    WRITE("write"),
    PROXY("proxy");

    private final String name;

    private EntryRight(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static EntryRight forName(String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "add": {
                return ADD;
            }
            case "delete": {
                return DELETE;
            }
            case "read": {
                return READ;
            }
            case "write": {
                return WRITE;
            }
            case "proxy": {
                return PROXY;
            }
        }
        return null;
    }

    public String toString() {
        return this.name;
    }
}

