/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.querydsl.query;

import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.xpack.sql.querydsl.query.LeafQuery;
import org.elasticsearch.xpack.sql.tree.Source;

public class RangeQuery
extends LeafQuery {
    private final String field;
    private final Object lower;
    private final Object upper;
    private final boolean includeLower;
    private final boolean includeUpper;
    private final String format;

    public RangeQuery(Source source, String field, Object lower, boolean includeLower, Object upper, boolean includeUpper) {
        this(source, field, lower, includeLower, upper, includeUpper, null);
    }

    public RangeQuery(Source source, String field, Object lower, boolean includeLower, Object upper, boolean includeUpper, String format) {
        super(source);
        this.field = field;
        this.lower = lower;
        this.upper = upper;
        this.includeLower = includeLower;
        this.includeUpper = includeUpper;
        this.format = format;
    }

    public String field() {
        return this.field;
    }

    public Object lower() {
        return this.lower;
    }

    public Object upper() {
        return this.upper;
    }

    public boolean includeLower() {
        return this.includeLower;
    }

    public boolean includeUpper() {
        return this.includeUpper;
    }

    public String format() {
        return this.format;
    }

    @Override
    public QueryBuilder asBuilder() {
        RangeQueryBuilder queryBuilder = QueryBuilders.rangeQuery((String)this.field).from(this.lower, this.includeLower).to(this.upper, this.includeUpper);
        if (Strings.hasText((String)this.format)) {
            queryBuilder.format(this.format);
        }
        return queryBuilder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field, this.lower, this.upper, this.includeLower, this.includeUpper, this.format);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RangeQuery other = (RangeQuery)obj;
        return Objects.equals(this.field, other.field) && Objects.equals(this.includeLower, other.includeLower) && Objects.equals(this.includeUpper, other.includeUpper) && Objects.equals(this.lower, other.lower) && Objects.equals(this.upper, other.upper) && Objects.equals(this.format, other.format);
    }

    @Override
    protected String innerToString() {
        return this.field + ":" + (this.includeLower ? "[" : "(") + this.lower + ", " + this.upper + (this.includeUpper ? "]" : ")");
    }
}

