/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.gui.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.diylc.common.PropertyWrapper;
import org.diylc.core.ValidationException;
import org.diylc.swing.gui.editor.FieldEditorFactory;
import org.diylc.swingframework.ButtonDialog;

public class PropertyEditorDialog
extends ButtonDialog {
    private static final Logger LOG = Logger.getLogger(PropertyEditorDialog.class);
    private static final long serialVersionUID = 1L;
    public static boolean SHOW_DEFAULT_BOXES = true;
    private static final String DEFAULT_BOX_TOOLTIP = "<html>If this box is checked application will use the current value as a<br>default when creating new components of the same type</html>";
    private List<PropertyWrapper> properties;
    private Set<PropertyWrapper> defaultedProperties;
    private Component componentToFocus = null;

    public PropertyEditorDialog(JFrame jFrame, List<PropertyWrapper> list, String string) {
        super(jFrame, string, new String[]{"OK", "Cancel"});
        LOG.debug((Object)("Creating property editor for: " + list));
        this.properties = list;
        this.defaultedProperties = new HashSet<PropertyWrapper>();
        this.setMinimumSize(new Dimension(240, 40));
        this.layoutGui();
        this.setLocationRelativeTo(jFrame);
    }

    protected boolean validateInput(String string) {
        if (string.equals("OK")) {
            for (PropertyWrapper propertyWrapper : this.properties) {
                try {
                    propertyWrapper.getValidator().validate(propertyWrapper.getValue());
                }
                catch (ValidationException validationException) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Input error for \"" + propertyWrapper.getName() + "\": " + validationException.getMessage(), "Error", 0);
                    return false;
                }
            }
        }
        return true;
    }

    private JPanel createEditorFields() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 21;
        for (PropertyWrapper propertyWrapper : this.properties) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            jPanel.add((Component)new JLabel(propertyWrapper.getName() + ": "), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            Component component = FieldEditorFactory.createFieldEditor(propertyWrapper);
            component.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        PropertyEditorDialog.this.getButton("OK").doClick();
                    } else if (keyEvent.getKeyCode() == 27) {
                        PropertyEditorDialog.this.getButton("Cancel").doClick();
                    }
                }
            });
            jPanel.add(component, gridBagConstraints);
            if (propertyWrapper.isDefaultable()) {
                gridBagConstraints.gridx = 2;
                gridBagConstraints.fill = 0;
                gridBagConstraints.weightx = 0.0;
                if (SHOW_DEFAULT_BOXES) {
                    jPanel.add((Component)this.createDefaultCheckBox(propertyWrapper), gridBagConstraints);
                }
            }
            if (propertyWrapper.getName().equalsIgnoreCase("value")) {
                this.componentToFocus = component;
            }
            ++gridBagConstraints.gridy;
        }
        return jPanel;
    }

    private JCheckBox createDefaultCheckBox(final PropertyWrapper propertyWrapper) {
        final JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setToolTipText(DEFAULT_BOX_TOOLTIP);
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jCheckBox.isSelected()) {
                    PropertyEditorDialog.this.defaultedProperties.add(propertyWrapper);
                } else {
                    PropertyEditorDialog.this.defaultedProperties.remove(propertyWrapper);
                }
            }
        });
        return jCheckBox;
    }

    public Set<PropertyWrapper> getDefaultedProperties() {
        return this.defaultedProperties;
    }

    public static boolean showFor(JFrame jFrame, List<PropertyWrapper> list, String string) {
        PropertyEditorDialog propertyEditorDialog = new PropertyEditorDialog(jFrame, list, string);
        propertyEditorDialog.setVisible(true);
        return "OK".equals(propertyEditorDialog.getSelectedButtonCaption());
    }

    public void setVisible(boolean bl) {
        if (bl && this.componentToFocus != null) {
            this.componentToFocus.requestFocusInWindow();
            this.componentToFocus = null;
        }
        super.setVisible(bl);
    }

    protected JComponent getMainComponent() {
        return this.createEditorFields();
    }
}

