/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.extension;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.extension.Extension;
import org.apache.tools.ant.taskdefs.optional.extension.ExtensionAdapter;
import org.apache.tools.ant.taskdefs.optional.extension.LibFileSet;
import org.apache.tools.ant.types.FileSet;

public final class ExtensionUtil {
    private ExtensionUtil() {
    }

    static ArrayList toExtensions(List adapters) throws BuildException {
        ArrayList<Extension> results = new ArrayList<Extension>();
        int size = adapters.size();
        for (int i = 0; i < size; ++i) {
            ExtensionAdapter adapter = (ExtensionAdapter)adapters.get(i);
            Extension extension = adapter.toExtension();
            results.add(extension);
        }
        return results;
    }

    static void extractExtensions(Project project, List libraries, List fileset) throws BuildException {
        if (!fileset.isEmpty()) {
            Extension[] extensions = ExtensionUtil.getExtensions(project, fileset);
            for (int i = 0; i < extensions.length; ++i) {
                libraries.add(extensions[i]);
            }
        }
    }

    private static Extension[] getExtensions(Project project, List libraries) throws BuildException {
        ArrayList extensions = new ArrayList();
        for (FileSet fileSet : libraries) {
            boolean includeImpl = true;
            boolean includeURL = true;
            if (fileSet instanceof LibFileSet) {
                LibFileSet libFileSet = (LibFileSet)fileSet;
                includeImpl = libFileSet.isIncludeImpl();
                includeURL = libFileSet.isIncludeURL();
            }
            DirectoryScanner scanner = fileSet.getDirectoryScanner(project);
            File basedir = scanner.getBasedir();
            for (String fileName : scanner.getIncludedFiles()) {
                File file = new File(basedir, fileName);
                ExtensionUtil.loadExtensions(file, extensions, includeImpl, includeURL);
            }
        }
        return extensions.toArray(new Extension[extensions.size()]);
    }

    private static void loadExtensions(File file, List extensionList, boolean includeImpl, boolean includeURL) throws BuildException {
        JarFile jarFile = null;
        try {
            try {
                jarFile = new JarFile(file);
                Extension[] extensions = Extension.getAvailable(jarFile.getManifest());
                for (int i = 0; i < extensions.length; ++i) {
                    Extension extension = extensions[i];
                    ExtensionUtil.addExtension(extensionList, extension, includeImpl, includeURL);
                }
                Object var9_9 = null;
            }
            catch (Exception e) {
                throw new BuildException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            ExtensionUtil.close(jarFile);
            throw throwable;
        }
        ExtensionUtil.close(jarFile);
    }

    private static void addExtension(List extensionList, Extension originalExtension, boolean includeImpl, boolean includeURL) {
        boolean hasImplAttributes;
        Extension extension = originalExtension;
        if (!includeURL && null != extension.getImplementationURL()) {
            extension = new Extension(extension.getExtensionName(), extension.getSpecificationVersion().toString(), extension.getSpecificationVendor(), extension.getImplementationVersion().toString(), extension.getImplementationVendor(), extension.getImplementationVendorID(), null);
        }
        boolean bl = hasImplAttributes = null != extension.getImplementationURL() || null != extension.getImplementationVersion() || null != extension.getImplementationVendorID() || null != extension.getImplementationVendor();
        if (!includeImpl && hasImplAttributes) {
            extension = new Extension(extension.getExtensionName(), extension.getSpecificationVersion().toString(), extension.getSpecificationVendor(), null, null, null, extension.getImplementationURL());
        }
        extensionList.add(extension);
    }

    static Manifest getManifest(File file) throws BuildException {
        Manifest manifest;
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
            Manifest m = jarFile.getManifest();
            if (m == null) {
                throw new BuildException(file + " doesn't have a MANIFEST");
            }
            manifest = m;
            Object var5_5 = null;
        }
        catch (IOException ioe) {
            try {
                throw new BuildException(ioe.getMessage(), ioe);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                ExtensionUtil.close(jarFile);
                throw throwable;
            }
        }
        ExtensionUtil.close(jarFile);
        return manifest;
    }

    private static void close(JarFile device) {
        if (null != device) {
            try {
                device.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

