/**
 * User evidence actions.
 *
 * @module     tool_lp/user_evidence_actions
 * @copyright  2015 Frédéric Massart - FMCorz.net
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("tool_lp/user_evidence_actions",["jquery","core/templates","core/ajax","core/notification","core/str","tool_lp/menubar","tool_lp/competencypicker_user_plans"],(function($,templates,ajax,notification,str,Menubar,PickerUserPlans){var UserEvidenceActions=function(type){if(this._type=type,"evidence"===type)this._region='[data-region="user-evidence-page"]',this._evidenceNode='[data-region="user-evidence-page"]',this._template="tool_lp/user_evidence_page",this._contextMethod="tool_lp_data_for_user_evidence_page";else{if("list"!==type)throw new TypeError("Unexpected type.");this._region='[data-region="user-evidence-list"]',this._evidenceNode='[data-region="user-evidence-node"]',this._template="tool_lp/user_evidence_list_page",this._contextMethod="tool_lp_data_for_user_evidence_list_page"}};return UserEvidenceActions.prototype._contextMethod=null,UserEvidenceActions.prototype._evidenceNode=null,UserEvidenceActions.prototype._region=null,UserEvidenceActions.prototype._template=null,UserEvidenceActions.prototype._type=null,UserEvidenceActions.prototype._getContextArgs=function(evidenceData){var args={};return"evidence"===this._type?args={id:evidenceData.id}:"list"===this._type&&(args={userid:evidenceData.userid}),args},UserEvidenceActions.prototype._renderView=function(context){var self=this;return templates.render(self._template,context).then((function(newhtml,newjs){templates.replaceNode($(self._region),newhtml,newjs)}))},UserEvidenceActions.prototype._callAndRefresh=function(calls,evidenceData){var self=this;return calls.push({methodname:self._contextMethod,args:self._getContextArgs(evidenceData)}),$.when.apply($.when,ajax.call(calls)).then((function(){return self._renderView(arguments[arguments.length-1])})).fail(notification.exception)},UserEvidenceActions.prototype._doDelete=function(evidenceData){var calls=[{methodname:"core_competency_delete_user_evidence",args:{id:evidenceData.id}}];this._callAndRefresh(calls,evidenceData)},UserEvidenceActions.prototype.deleteEvidence=function(evidenceData){var self=this;ajax.call([{methodname:"core_competency_read_user_evidence",args:{id:evidenceData.id}}])[0].done((function(evidence){str.get_strings([{key:"confirm",component:"moodle"},{key:"deleteuserevidence",component:"tool_lp",param:evidence.name},{key:"delete",component:"moodle"},{key:"cancel",component:"moodle"}]).done((function(strings){notification.confirm(strings[0],strings[1],strings[2],strings[3],(function(){self._doDelete(evidenceData)}))})).fail(notification.exception)})).fail(notification.exception)},UserEvidenceActions.prototype._deleteEvidenceHandler=function(e){e.preventDefault();var data=this._findEvidenceData($(e.target));this.deleteEvidence(data)},UserEvidenceActions.prototype._doCreateUserEvidenceCompetency=function(evidenceData,competencyIds){var calls=[];$.each(competencyIds,(function(index,competencyId){calls.push({methodname:"core_competency_create_user_evidence_competency",args:{userevidenceid:evidenceData.id,competencyid:competencyId}})})),this._callAndRefresh(calls,evidenceData)},UserEvidenceActions.prototype.createUserEvidenceCompetency=function(evidenceData){var self=this,picker=new PickerUserPlans(evidenceData.userid);picker.on("save",(function(e,data){var competencyIds=data.competencyIds;self._doCreateUserEvidenceCompetency(evidenceData,competencyIds,data.requestReview)})),picker.display()},UserEvidenceActions.prototype._createUserEvidenceCompetencyHandler=function(e){e.preventDefault();var data=this._findEvidenceData($(e.target));this.createUserEvidenceCompetency(data)},UserEvidenceActions.prototype._doDeleteUserEvidenceCompetency=function(evidenceData,competencyId){var calls=[];calls.push({methodname:"core_competency_delete_user_evidence_competency",args:{userevidenceid:evidenceData.id,competencyid:competencyId}}),this._callAndRefresh(calls,evidenceData)},UserEvidenceActions.prototype.deleteUserEvidenceCompetency=function(evidenceData,competencyId){this._doDeleteUserEvidenceCompetency(evidenceData,competencyId)},UserEvidenceActions.prototype._deleteUserEvidenceCompetencyHandler=function(e){var data=this._findEvidenceData($(e.currentTarget)),competencyId=$(e.currentTarget).data("id");e.preventDefault(),this.deleteUserEvidenceCompetency(data,competencyId)},UserEvidenceActions.prototype._doReviewUserEvidenceCompetencies=function(evidenceData){var calls=[{methodname:"core_competency_request_review_of_user_evidence_linked_competencies",args:{id:evidenceData.id}}];this._callAndRefresh(calls,evidenceData)},UserEvidenceActions.prototype.reviewUserEvidenceCompetencies=function(evidenceData){var self=this;ajax.call([{methodname:"core_competency_read_user_evidence",args:{id:evidenceData.id}}])[0].done((function(evidence){str.get_strings([{key:"confirm",component:"moodle"},{key:"sendallcompetenciestoreview",component:"tool_lp",param:evidence.name},{key:"confirm",component:"moodle"},{key:"cancel",component:"moodle"}]).done((function(strings){notification.confirm(strings[0],strings[1],strings[2],strings[3],(function(){self._doReviewUserEvidenceCompetencies(evidenceData)}))})).fail(notification.exception)})).fail(notification.exception)},UserEvidenceActions.prototype._reviewUserEvidenceCompetenciesHandler=function(e){e.preventDefault();var data=this._findEvidenceData($(e.target));this.reviewUserEvidenceCompetencies(data)},UserEvidenceActions.prototype._findEvidenceData=function(node){var data,parent=node.parentsUntil($(this._region).parent(),this._evidenceNode);if(1!=parent.length)throw new Error("The evidence node was not located.");if(void 0===(data=parent.data())||void 0===data.id)throw new Error("Evidence data could not be found.");return data},UserEvidenceActions.prototype.enhanceMenubar=function(selector){Menubar.enhance(selector,{'[data-action="user-evidence-delete"]':this._deleteEvidenceHandler.bind(this),'[data-action="link-competency"]':this._createUserEvidenceCompetencyHandler.bind(this),'[data-action="send-competencies-review"]':this._reviewUserEvidenceCompetenciesHandler.bind(this)})},UserEvidenceActions.prototype.registerEvents=function(){var wrapper=$(this._region);wrapper.find('[data-action="user-evidence-delete"]').click(this._deleteEvidenceHandler.bind(this)),wrapper.find('[data-action="link-competency"]').click(this._createUserEvidenceCompetencyHandler.bind(this)),wrapper.find('[data-action="delete-competency-link"]').click(this._deleteUserEvidenceCompetencyHandler.bind(this)),wrapper.find('[data-action="send-competencies-review"]').click(this._reviewUserEvidenceCompetenciesHandler.bind(this))},UserEvidenceActions}));

//# sourceMappingURL=user_evidence_actions.min.js.map